#ifndef __LUCENE_INDEX_DOCUMENT_WRITER__
#define __LUCENE_INDEX_DOCUMENT_WRITER__

#include <Foundation/Foundation.h>

@interface LCPosting: NSObject
{
	LCTerm *term;
	int freq;
	NSArray *positions; //int
	NSArray *offsets; // LCTermVectorOffsetInfo
}

- (id) initWithTerm: (LCTerm *) t
       position: (int) position
       offset: (LCTermVectorOffsetInfo *) offset;
@end

@interface LCDocumentWriter: NSObject
{
	LCAnalyzer *analyzer;
	id <LCDirectory> directory;
	LCSimilarity *similarity;
	LCFiledInfos *fieldInfos;
	int masFieldLength;
	int termIndexInterval;
	// PrintStream infoStream;
	
	NSMutableDictionary *postingTable;
	NSMutableArray *fieldLengths; //int
	NSMutableArray *fieldPositions;  //int
	NSMutableArray *fieldOffsets; // int
	NSMutableArray *fieldBoosts; // flost

	LCTerm *termBuffer;
}

- (id) initWithDirectory: (id <LCDirectory>) directory
       analyzer: (LCAnalyzer *) analyzer
       indexWriter: (LCIndexWriter *) indexWriter;
- (void) addDocument: (NSString *) segment
         document: (LCDocument *) doc;
- (void) invertDocument: (LCDocument *) doc;
- (void) addField: (NSString *) field
             text: (NSString *) text
         position: (int) position
	 offset: (LCTermVectorOffsetInfo *) offset;
- (NSArray *) sortPostingTable;
- (void) quickSort: (NSArray *) postings
	 low: (int) lo high: (int) hi;
- (void) writePostings: (NSArray *) postings 
         segment: (NSString *) segment;
- (void) writeNorms: (NSString *) segment;
#if 0
- (void) setInfoStream: (PrintStream infoStream);
#endif
	
@end

#endif /* __LUCENE_INDEX_DOCUMENT_WRITER__ */
