#ifndef __LUCENE_INDEX_INDEX_READER__
#define __LUCENE_INDEX_INDEX_READER__

#include <Foundation/Foundation.h>

// all fields
static NSString *LCFieldOption_ALL = @"ALL";
// all indexed fields
static NSString *LCFieldOption_INDEXED = @"INDEXED";
// all fields which are not indexed
static NSString *LCFieldOption_UNINDEXED = @"UNINDEXED";
// all fields which are indexed with termvectors enables
static NSString *LCFieldOption_INDEXED_WITH_TERMVECTOR = @"INDEXED_WITH_TERMVECTOR";
// all fields which are indexed but don't have termvectors enabled
static NSString *LCFieldOption_INDEXED_NO_TERMVECTOR = @"INDEXED_NO_TERMVECTOR";
// all fields where termvectors are enabled. Please note that only standard termvector fields are returned
static NSString *LCFieldOption_TERMVECTOR = @"TERMVECTOR";
// all field with termvectors wiht positions enabled
static NSString *LCFieldOption_TERMVECTOR_WITH_POSITION = @"TERMVECTOR_WITH_POSITION";
// all fields where termvectors with offset position are set
static NSString *LCFieldOption_TERMVECTOR_WITH_OFFSET = @"TERMVECTOR_WITH_OFFSET";
// all fields where termvectors with offset and position values set
static NSString *LCFieldOption_TERMVECTOR_WITH_POSITION_OFFSET = @"TERMVECTOR_WITH_POSITION_OFFSET";

@interface LCIndexReader: NSObject
{
  id <LCDirectory> directory;
  BOOL directoryOwner;
  BOOL closeDirectory;

  LCSegmentInfos *segmentInfos;
  // Lock writeLock
  BOOL stale;
  BOOL hasChanges;
}

- (id) initWithDirectory: (id <LCDirectory>) directory;
- (id) initWithDirectory: (id <LCDirectory>) dir       
	segmentInfos: (LCSegmentInfos *) seg       
	closeDirectory: (BOOL) close;
- (id) initWithDirectory: (id <LCDirectory>) dir       
	segmentInfos: (LCSegmentInfos *) seg       
	closeDirectory: (BOOL) close
	directoryOwner: (BOOL) owner;
+ (id) openPath: (NSString *) path;
+ (id) openDirectory: (id <LCDirectory>) directory;
+ (id) openDirectory: (id <LCDirectory>) directory close: (BOOL) close;
- (id <LCDirectory>) directory;
+ (long) currentVersionAtPath: (NSString *) path;
+ (long) currentVersionWithDirectory: (id <LCDirectory>) dir;
- (NSArray *) termFreqVectors: (int) number;
- (LCTermFreqVector *) termFreqVector: (int) docNumber
                       field: (NSString *) field;
+ (BOOL) indexExistsAtPath: (NSString *) dir;
+ (BOOL) indexExistsWithDirectory: (id <LCDirectory>) dir;
- (int) numDocs;
- (int) maxDoc;
- (LCDocument *) document: (int) n;
- (BOOL) isDeleted: (int) n;
- (BOOL) hasDeletes;
- (NSArray *) norms: (NSString *) field;
- (void) setNorms: (NSString *) field 
            bytes: (NSData *) bytes offset: (int) offset;
- (void) setNorm: (int) doc field: (NSString *) field charValue: (char) value;
- (void) doSetNorm: (int) doc field: (NSString *) field charValue: (char) value;
- (void) setNorm: (int) doc field: (NSString *) field floatValue: (float) value
- (LCTermEnum *) terms;
- (LCTermEnum *) termsWithTerm: (LCTerm *) t;
- (int) docFreq: (LCTerm *) t;
- (LCTermDocs *) termDocsWithTerm: (LCTerm *) term;
- (LCTermDocs *) termDocs;
- (LCTermPositions *) termPositionsWithTerm: (LCTerm *) term;
- (LCTermPositions *) termPositions;
- (void) aquireWriteLock;
- (void) delete: (int) docNum;
- (void) doDelete: (int) docNum;
- (int) deleteTerm: (LCTerm *) term;
- (void) undeleteAll;
- (void) doUndeleteAll;
- (void) commit;
- (void) doCommit;
- (void) close;
- (void) doClose;
- (NSArray *) fieldNames: (NSString *) fieldOption
+ (BOOL) isLocked: (id <LCDirectory>) dir
- (BOOL) isLockedAtPath: (NSString *) dir;
- (void) unlock: (id <LCDirectory>) dir;

@end

#endif /* __LUCENE_INDEX_INDEX_READER__ */
