#ifndef __LUCENE_INDEX_INDEX_WRITER__
#define __LUCENE_INDEX_INDEX_WRITER__

#include <Foundation/Foundation.h>

#define WRITE_LOCK_TIMEOUT 1000
#define COMMIT_LOCK_TIMEOUT 10000
#define WRITE_LOCK_NAME @"write.lock"
#define COMMIT_LOCK_NAME @"commit.lock"
#define DEFAULT_MERGE_FACTOR 10
#define DEFAULT_MIN_MERGE_DOCS 10
//#define DEFAULT_MAX_MERGE_DOCS INT_MAX
#define DEFAULT_MAX_FIELD_LENGTH 10000
#define DEFAULT_TERM_INDEX_INTERNAL 128

@interface LCIndexWriter: NSObject
{
  id <LCDirectory> directory;  // where this index resides
  LCAnalyzer *analyzer;    // how to analyze text
  LCSimilarity *similarity; // how to normalize
  LCSegmentInfos *segmentInfos; // the segments
  id <LCDirectory> ramDirectory; // for temp segs

  //Lock writeLock;
  int termIndexInterval;

  /** Use compound file setting. Defaults to true, minimizing the number of
   * files used.  Setting this to false may improve indexing performance, but
   * may also cause file handle problems.
   */
  BOOL useCompoundFile;
  BOOL closeDir;
}

- (BOOL) useCompoundFile;
- (void) setUseCompoundFile: (BOOL) value;
- (void) setSimilarity: (LCSimilarity *) similarity;
- (LCSimilarity *) similarity;
- (void) setTermIndexInternal: (int) interval;
- (int) termIndexInterval;
- (id) initWithPath: (NSString *) path 
       analyzer: (LCAnalyzer *) a
       create: (BOOL) create;
- (id) initWithDirectory: (id <LCDirectory>) dir 
       analyzer: (LCAnalyzer *) a
       create: (BOOL) create;
- (id) initWithDirectory: (id <LCDirectory>) dir 
       analyzer: (LCAnalyzer *) a
       create: (BOOL) create
       close: (BOOL) closeDir;
- (void) setMaxMergeDocs: (int) maxMergeDocs;
- (int) maxMergeDocs;
- (void) setMaxFieldLength: (int) maxFieldLength;
- (int) maxFieldLength;
- (void) setMaxBufferedDocs: (int) maxBufferedDocs;
- (int) maxBufferedDocs;
- (void) setMergeFactor: (int) mergeFactor;
- (int) mergeFactor;
// - (void) setInfoStream: (LCPrintStream *) infoStream;
// - (LCPrintStream *) infoStream;
- (void) close;
- (id <LCDirectory>) directory;
- (LCAnalyzer *) analyzer;
- (int) docCount;
- (void) addDocument: (LCDocument *) doc;
- (void) addDocument: (LCDocument *) doc
         analyzer: (LCAnalyzer *) analyzer;
- (int) segmentsCounter;
- (NSString *) newSegmentName;
- (void) optimize;
- (void) addIndexesWithDirectories: (NSArray *) dirs;
- (void) addIndexedWithReaders: (NSArray *) readers;
- (void) flushRamSegments;
- (void) maybeMergeSegments;
- (void) mergeSegments: (int) minSegment;
- (void) deleteSegments: (NSArray *) segments;
- (void) deleteFiles: (NSArray *) files;
- (void) deleteFiles: (NSArray *) files inDirectory: (id <LCDirectory>) dir;
- (void) deleteFiles: (NSArray *) files deletable: (NSArray *) deletable;
- (NSArray *) readDeleteableFiles;
- (void) writeDeleteableFiles: (NSArray *) files;

@end

#endif /* __LUCENE_INDEX_INDEX_WRITER__ */
