#ifndef __LUCENE_INDEX_MULTI_READER__
#define __LUCENE_INDEX_MULTI_READER__

#include "LuceneKit/Index/LCIndexReader.h"
#include "LuceneKit/Index/LCTermEnum.h"
#include "LuceneKit/Index/LCTermDocs.h"

@interface LCMultiTermEnum: LCTermEnum
{
  LCSegmentMergeQueue *queue;
  LCTerm *term;
  int docFreq;
}
- (id) initWithReaders: (NSArray *) reader
                 starts: (NSArray *) starts
		 term: (LCTerm *) t;
@end

@interface LCMultiTermDocs: NSObject <LCTermDocs>
{
  NSArray *readers;
  NSArray *starts;
  LCTerm *term;
  int base;
  int pointer;
  NSArray *readerTermDocs;
  id <LCTermDocs> current;
}
- (id) initWithReaders: (NSArray *) r 
                starts: (NSArray *) s;
- (id <LCTermDocs>) termDocs: (int) i;
- (id <LCTermDocs>) termDocsWithReader: (LCIndexReader *) reader;
@end

@interface LCMultiTermPositions: LCMultiTermDocs <LCTermPositions>
- (id) initWithReaders: (NSArray *) r
                starts: (NSArray *) s;
- (LCTermDocs *) termDocs: (LCIndexReader *) reader;
@end

@interface LCMultiReader: LCIndexReader
{
  NSArray *subReaders; // array of LCIndexReader
  NSArray *starts  // array of int, 1st docno for each segment
  NSMutableDictionary *normsCache;
  int maxDoc;
  int numDocs;
  BOOL hasDeletions;
}

- (id) initWithReaders: (NSArray *) subReaders;
- (id) initWithDirectory: (id <LCDirectory>) directory
       segmentInfos: (LCSegmentInfos *) sis
       close: (BOOL) closeDirectory
       readers: (NSArray *) subReaders;
- (int) readerIndex: (int) n;
@end

#endif /* __LUCENE_INDEX_MULTI_READER__ */
