#ifndef __LUCENE_INDEX_MULTIPLE_TERM_POSITION__
#define __LUCENE_INDEX_MULTIPLE_TERM_POSITION__

#include <Foundation/Foudation.h>
#include "LuceneKit/Index/LCTermPositions.h"
#include "LuceneKit/Util/LCPriorityQueue.h"

@interface LCTermPositionQueue: LCPriorityQueue
- (id) initWithTermPositions: (NSArray *) termPositions;
- (LCTermPositions *) peek;
@end

@interface LCIntQueue: NSObject
{
  int _arraySize;
  int _index;
  int _lastIndex;
  NSMutableArray *_array;
}

- (void) add: (int) i;
- (int) next;
- (void) sort;
- (void) clear;
- (int) size;
- (void) growArray;

@end

@interface LCMultipleTermPositions: NSObject <LCTermPositions>
{
  int _docl;
  int _freq;
  LCTermPositionQueue *_termPositionQueue;
  LCIntQueue *_posList;
}

- (id) initWithIndexReader: (LCIndexReader *) indexReader
                terms: (NSArray *) terms
@end

#endif /* __LUCENE_INDEX_MULTIPLE_TERM_POSITION__ */
