#ifndef __LUCENE_STORE_BUFFERED_INDEX_INPUT__
#define __LUCENE_STORE_BUFFERED_INDEX_INPUT__

#include "LCIndexInput.h"

#define INPUT_BUFFER_SIZE 1024

@interface LCBufferedIndexInput: LCIndexInput
{
  NSMutableData *buffer;
  long bufferStart;
  int bufferLength, bufferPosition;
}

- (void) refill;
- (void) readInternal: (char *) b offset: (int) offset length: (int) length;
- (void) seekInternal: (long) pos;

@end

#endif /* __LUCENE_STORE_BUFFERED_INDEX_INPUT__ */
