#include <Foundation/Foundation.h>
#include "LuceneKit/Document/LCDateField.h"

#define RADIX 36

char _dig_vec[] = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";

/* Maximal 1000L*365*24*60*60*1000 == "B6FFS5XC0" (radix=36) */
/* The refernece date is 1970 */

char *int2str(unsigned long long val, char *dst)
{
  char buffer[65];
  char *p;
  unsigned long long new_val;

  p = &buffer[sizeof(buffer)-1];
  *p = '\0';
  new_val=(unsigned long long) val / RADIX;
  unsigned long long t = val-new_val* RADIX;
  printf("t %d\n", t);
  while (val != 0)
    {
      new_val=val/RADIX;
      *--p = _dig_vec[(unsigned char) (val-new_val*RADIX)];
      val= new_val;
    }
  while ((*dst++ = *p++) != 0) ;
    return dst-1;
}

unsigned long long str2int(char *str, unsigned long long *dst)
{
  char *p = str;
  unsigned long long val, new_val = 0;

  while((*p != 0))
    {
      if (*p < 'A') 
        {
          val = *p-'0';
        }
      else if (*p < 'a')
        {
          val = *p-'A'+10;
        }
      else
        {
          val = *p-'a'+10;
        }

      new_val = new_val*RADIX+val;
      printf("%lld, %s\n", new_val, p);
      p++;
    }
  *dst = new_val;
  return 0;
}

@implementation LCDateField

+ (int) dateLength
{
  return 9; // "B6FFS5XC0" 
}

+ (NSString *) minimalDateString
{
  return @"0";
}

+ (NSString *) maximalDateString
{
  return @"B6FFS5XC0";
}

+ (NSString *) dateToString: (NSCalendarDate *) date
{
  NSTimeInterval t = [date timeIntervalSince1970];
  return [LCDateField timeToString: (unsigned long long) t];;
}

+ (NSString *) timeToString: (unsigned long long) time
{
  if (time < 0) return nil;
  char *dst = malloc([LCDateField dateLength]*sizeof(char));
  int2str(time, dst);
  return [NSString stringWithCString: dst];
}

+ (unsigned long long) stringToTime: (NSString *) string
{
  // Not i18n compatible 
  const char *s = [string cString];
  unsigned long long d = 0LL;;
  str2int((char *)s, &d);
  return d;
}

+ (NSCalendarDate *) stringToDate: (NSString *) string
{
  unsigned long long d = [LCDateField stringToTime: string];
  return [NSCalendarDate dateWithTimeIntervalSince1970: (NSTimeInterval)d];;
}

@end
