#include "LuceneKit/Document/LCIndex.h"
#include "GNUstep.h"

@implementation LCIndex
    
    /** Do not index the field value. This field can thus not be searched,
     * but one can still access its contents provided it is 
     * {@link Field.Store stored}. */
+ (LCIndex *) indexOfNO
{
  return AUTORELEASE([[LCIndex alloc] initWithName: @"NO"]);
}
    
    /** Index the field's value so it can be searched. An Analyzer will be used
     * to tokenize and possibly further normalize the text before its
     * terms will be stored in the index. This is useful for common text.
     */
+ (LCIndex *) indexOfTokenized
{
  return AUTORELEASE([[LCIndex alloc] initWithName: @"TOKENIZED"]);
}
    
    /** Index the field's value without using an Analyzer, so it can be searched.
     * As no analyzer is used the value will be stored as a single term. This is 
     * useful for unique Ids like product numbers.
     */
+ (LCIndex *) indexOfUnTokenized
{
  return AUTORELEASE([[LCIndex alloc] initWithName: @"UN_TOKENIZED"]);
}
    
@end
