#include "LuceneKit/Util/LCParameter.h"
#include "GNUstep.h"

/**
 * A serializable Enum class.
 */
static NSMutableDictionary *allParameters;

@implementation LCParameter

- (id) init
{
  self = [super init];
  if (allParameters == nil)
    allParameters = [[NSMutableDictionary alloc] init];
  return self;
}

- (id) initWithName: (NSString *) n
{
    // typesafe enum pattern, no public constructor
  self = [self init];
  ASSIGN(name, n);
  NSString *key = [self makeKey: name];
  id object = [allParameters objectForKey: key];;

  if (object)
    {
      NSLog(@"Parameter name %@ already used!", object);
      return nil;
    }
    
  [allParameters setObject: self forKey: key];
  return self;
}
  
- (NSString *) makeKey: (NSString *) n
{
  return [NSString stringWithFormat: @"%@ %@", NSStringFromClass([self class]), n];
}
  
- (NSString *) description
{
  return name;
}
  
  /**
   * Resolves the deserialized instance to the local reference for accurate
   * equals() and == comparisons.
   * 
   * @return a reference to Parameter as resolved in the local VM
   * @throws ObjectStreamException
   */
- (id) readResolve
{
  id par = [allParameters objectForKey: [self makeKey: name]];
    
  if(par == nil)
    {
      NSLog(@"Unknown parameter value: %@", name);
      return nil;
    }
  return par;
}

@end
