#include "LuceneKit/Document/LCStore.h"
#include "GNUstep.h"

@implementation LCStore
   /** Store the original field value in the index in a compressed form. This is
    * useful for long documents and for binary valued fields.
    */
+ (LCStore *) storeOfCompress
{
  return AUTORELEASE([[LCStore alloc] initWithName: @"COMPRESS"]);
}

 /** Store the original field value in the index. This is useful for short texts
  * like a document's title which should be displayed with the results. The
  * value is stored in its original form, i.e. no analyzer is used before it is
  * stored. 
  */
+ (LCStore *) storeOfYES
{
  return AUTORELEASE([[LCStore alloc] initWithName: @"YES"]);
}
    
    /** Do not store the field value in the index. */
+ (LCStore *) storeOfNO
{
  return AUTORELEASE([[LCStore alloc] initWithName: @"NO"]);
}

@end
