#include "LuceneKit/Document/LCTermVector.h"
#include "GNUstep.h"

@implementation LCTermVector
    
    /** Do not store term vectors. 
     */
+ (LCTermVector *) termVectorOfNO
{
  return AUTORELEASE([[LCTermVector alloc] initWithName: @"NO"]);
}
    
  /** Store the term vectors of each document. A term vector is a list
   * of the document's terms and their number of occurences in that document. */
+ (LCTermVector *) termVectorOfYES
{
  return AUTORELEASE([[LCTermVector alloc] initWithName: @"YES"]);
}
    
    /**
     * Store the term vector + token position information
     * 
     * @see #YES
     */ 
+ (LCTermVector *) termVectorWithPositions
{
  return AUTORELEASE([[LCTermVector alloc] initWithName: @"WITH_POSITIONS"]);
}
    
    /**
     * Store the term vector + Token offset information
     * 
     * @see #YES
     */ 
+ (LCTermVector *) termVectorWithOffsets
{
  return AUTORELEASE([[LCTermVector alloc] initWithName: @"WITH_OFFSETS"]);
}
    
    /**
     * Store the term vector + Token position and offset information
     * 
     * @see #YES
     * @see #WITH_POSITIONS
     * @see #WITH_OFFSETS
     */ 
+ (LCTermVector *) termVectorWithPositionsAndOffsets
{
  return AUTORELEASE([[LCTermVector alloc] initWithName: @"WITH_POSITIONS_OFFSETS"]);
}
  
@end
