#include "LuceneKit/Analysis/LCLowerCaseFilter.h"

/**
 * Normalizes token text to lower case.
 *
 * @version $Id: LowerCaseFilter.java,v 1.4 2004/03/29 22:48:00 cutting Exp $
 */
@implementation LCLowerCaseFilter

- (LCToken *) next
{
  LCToken *t = [input next];

  if (t == nil)
    return nil;

  NSString *s = [[t termText] lowercaseString];
  [t setTermText: s];

  return t;
}

@end
