#include "LuceneKit/Index/LCSegmentInfos.h"
#include "LuceneKit/Index/LCSegmentInfo.h"
#include "GNUstep.h"

  /** The file format version, a negative number. */
  /* Works since counter, the old 1st entry, is always >= 0 */
#define FORMAT -1

@implementation LCSegmentInfos

- (id) init
{
  self = [super init];
  counter = 0;
  version = 0;
  segments = [[NSMutableArray alloc] init];
  return self;
}

- (void) dealloc
{
  RELEASE(segments);
  [super dealloc];
}

- (LCSegmentInfo *) info: (int) i
{
  return [segments objectAtIndex: i];
}

- (void) read: (id <LCDirectory>) directory
{
  LCIndexInput *input = [directory openInput: @"segments"];
  int format = [input readInt];
  if (format < 0) 
   {     // file contains explicit format info
        // check that it is a format we can understand
      if (format < FORMAT)
        {
	  NSLog(@"Unknown format version: %d", format);
  	  return; 
	}
      version = [input readLong]; // read version
      counter = [input readInt]; // read counter
   }
  else{     // file is in old format without explicit format info
        counter = format;
      }
      
  int i;
  for (i = [input readInt]; i > 0; i--) { // read segmentInfos
        LCSegmentInfo *si = [[LCSegmentInfo alloc] initWithName: [input readString]
		    docCount: [input readInt]
		    directory: directory];
	[segments addObject: si];
	RELEASE(si);
      }
      
  if(format >= 0){    // in old format the version number may be at the end of the file
    if ([input getFilePointer] >= [input length])
          version = 0; // old file format without version number
    else
          version = [input readLong]; // read version
  }
  [input close];
}

- (void) write: (id <LCDirectory>) directory
{
  LCIndexOutput *output = [directory createOutput: @"segments.new"];
  [output writeInt: FORMAT]; // write FORMAT
  [output writeLong: ++version]; // every write changes the index
  [output writeInt: counter]; // write counter
  [output writeInt: [segments count]]; // write infos
  int i;
      for (i = 0; i < [segments count]; i++) {
        LCSegmentInfo *si = [self info:i];
        [output writeString: [si name]];
        [output writeInt: [si docCount]];
      }         
  [output close];

    // install new segment info
  [directory renameFile: @"segments.new" to:  @"segments"];
}

  /**
   * version number when this SegmentInfos was generated.
   */
- (long) version
{
  return version;
}

  /**
   * Current version number from segments file.
   */
+ (long) readCurrentVersion: (id <LCDirectory>) directory
{
  LCIndexInput *input = [directory openInput: @"segments"];
  int format = 0;
  long ver = 0;
  format = [input readInt];
  if(format < 0){
    if (format < FORMAT)
      {
        NSLog(@"Unknown format version: %d", format);
	return -1;
      }
    ver = [input readLong]; // read version
  }
       [input close];
     
     if(format < 0)
      return ver;

    // We cannot be sure about the format of the file.
    // Therefore we have to read the whole file and cannot simply seek to the version entry.

    LCSegmentInfos *sis = [[LCSegmentInfos alloc] init];
    [sis read: directory];
    return [sis version];
}

@end
