#include <stdio.h>

void usage() {
	printf("Usage : \n");
	printf("test export file.tar.bz2 [path]\n");
	printf("test import file.tar.bz2 [path]\n");
	printf("\nWhere the path isnt the full path,say :\n");
	printf("/home/smurfd/evolution/local/Inbox/subfolders/Temp/\n");
	printf("but instead :\n");
	printf("/Inbox/Temp/, wich would mean the same as the above,if the user smurfd ran the backup tool.\n");
	exit(9);
}

int calcLevel(char *path) {
	int level = 0;
	char *tmp;
	char *str;

	str = (char *) malloc(strlen(path)+1);
	strcpy(str,path);
	tmp = strtok(str,"/");
	while(tmp!=NULL) {
		level++;
		tmp = strtok(NULL,"/");
	}
	return level;
}

char *cv2r(char *path) {
	int level = 0;
	char *tmp;
	char *str;
	char *str2;

	str = (char *) malloc(strlen(path)+1);
	str2 = (char *) malloc(calcLevel(path)*strlen("subfolders")+strlen(path)+1);
	strcpy(str,path);
	tmp = strtok(str,"/");
	while(tmp!=NULL) {
		if(level>0)
			sprintf(str2,"%s/subfolders/%s",str2,tmp);
		else
			sprintf(str2,"%s/%s",str2,tmp);
		level++;
		tmp = strtok(NULL,"/");
	}

	return str2;
}	

void export(char *file, char *path) {
	char execstr[255];
	char fullpath[255];
	
	if(calcLevel(path)>1)
		sprintf(fullpath,"~/evolution/local%s",cv2r(path));
	else
		sprintf(fullpath,"~/evolution/local%s",path);
	printf("Exporting %s to %s...\n",fullpath,file);
	sprintf(execstr,"tar jvcf %s -C %s ./",file,fullpath);
	printf("executing : %s\n",execstr);
	system(execstr);
}

void import(char *file, char *path) {
	char execstr[255];
	char fullpath[255];
	char *tmp;

	tmp = (char *) malloc(strlen(path));
	strcpy(tmp,path);
	if(calcLevel(tmp)>1)
		sprintf(fullpath,"~/evolution/local%s",cv2r(tmp));
	else
		sprintf(fullpath,"~/evolution/local%s",tmp);
	strcpy(tmp,path);
	printf("Importing from %s to %s...%s\n",file,fullpath,cv2r(tmp));
	sprintf(execstr,"mkdir -p %s;tar -C %s -jvxf %s",fullpath,fullpath,file);
	printf("executing : %s\n", execstr);
	system(execstr);
	if(tmp!=NULL)
		free(tmp);
}

void main(int argc, char *argv[]) {
	char path[255];

	strcpy(path,"/");
	
	if((argc<=2)||(argc>=5)) {
		usage();
	} else {
		if( (strcmp(argv[1],"export")!=0)&&(strcmp(argv[1],"import")!=0))
			usage();
		else {
			if(argv[3]!=NULL)
				strcpy(path,argv[3]);
			if(strcmp(argv[1],"export")==0) export(argv[2],path);
			if(strcmp(argv[1],"import")==0) import(argv[2],path);
		}
			printf("Done!\n");
	}
}

