/*
 * makedumpfile.h
 *
 * Copyright (C) 2006  NEC Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <elf.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include <glib.h>
#include <zlib.h>
#include "diskdump_mod.h"

/*
 * Result of command
 */
#define COMPLETED	(0)
#define FAILED		(1)

/*
 * Page flags
 */
#define PG_locked	(0)	/* Page is locked. Don't touch. */
#define PG_error	(1)
#define PG_referenced	(2)
#define PG_uptodate	(3)
#define PG_dirty	(4)
#define PG_lru		(5)
#define PG_active	(6)
#define PG_slab		(7)	/* slab debug (Suparna wants this) */
#define PG_highmem	(8)
#define PG_checked	(9)	/* kill me in 2.5.<early>. */
#define PG_arch_1	(10)
#define PG_reserved	(11)
#define PG_private	(12)	/* Has something at ->private */
#define PG_writeback	(13)	/* Page is under writeback */
#define PG_nosave	(14)	/* Used for system suspend/resume */
#define PG_compound	(15)	/* Part of a compound page */
#define PG_swapcache	(16)	/* Swap page: swp_entry_t in private */
#define PG_mappedtodisk	(17)	/* Has blocks allocated on-disk */
#define PG_reclaim	(18)	/* To be reclaimed asap */

#define PAGE_MAPPING_ANON	(1)

#define LSEEKED_BITMAP	(1)
#define LSEEKED_PDESC	(2)
#define LSEEKED_PDATA	(3)

int
test_bit(int nr, unsigned long addr)
{
	int mask;

	mask = 1 << (nr & 0x1f);
	return ((mask & addr) != 0);
}

#define isLRU(flags)		test_bit(PG_lru, flags)
#define isReserved(flags)	test_bit(PG_reserved, flags)
#define isPrivate(flags)	test_bit(PG_private, flags)
#define isNosave(flags)		test_bit(PG_nosave, flags)
#define isCompound(flags)	test_bit(PG_compound, flags)
#define isSwapCache(flags)	test_bit(PG_swapcache, flags)

static inline int
isAnon(unsigned long mapping)
{
	return ((unsigned long)mapping & PAGE_MAPPING_ANON) != 0;
}

/*
 * Dump Level
 */
#define MIN_DUMP_LEVEL		(0)
#define MAX_DUMP_LEVEL		(15)
#define DL_EXCLUDE_ZERO		(0x001) /* Exclude Pages filled with Zeros */
#define DL_EXCLUDE_CACHE	(0x002) /* Exclude Cache Pages
				           without Private Pages */
#define DL_EXCLUDE_CACHE_PRI	(0x004) /* Exclude Cache Pages
				           with Private Pages */
#define DL_EXCLUDE_USER_DATA	(0x008) /* Exclude UserProcessData Pages */

/*
 * For parse_line()
 */
#define NULLCHAR	('\0')
#define MAXARGS		(100)   /* max number of arguments to one function */
#define LASTCHAR(s)	(s[strlen(s)-1])

/*
 * ELF flags
 */
#define ELF32	(1)
#define ELF64	(2)

#define BITPERBYTE		(8)
#define PGMM_CACHED		(512)
#define PFN_EXCLUDED		(256)
#define BUFSIZE_FGETS		(1500)
#define BUFSIZE_BITMAP		(4096)
#define PFN_BUFBITMAP		(BITPERBYTE*BUFSIZE_BITMAP)
#define FILENAME_BITMAP		"/tmp/kdump_bitmap.tmp"
/*
 * Minimam vmcore has 2 ProgramHeaderTables(PT_NOTE and PT_LOAD).
 */
#define MIN_ELF32_HEADER_SIZE \
	sizeof(Elf32_Ehdr)+sizeof(Elf32_Phdr)+sizeof(Elf32_Phdr)
#define MIN_ELF64_HEADER_SIZE \
	sizeof(Elf64_Ehdr)+sizeof(Elf64_Phdr)+sizeof(Elf64_Phdr)
#define MIN_ELF_HEADER_SIZE \
	MAX(MIN_ELF32_HEADER_SIZE, MIN_ELF64_HEADER_SIZE)
#define STRNEQ(A, B)	(A && B && \
	(strncmp((char *)(A), (char *)(B), strlen((char *)(B))) == 0))

/*
 * The values of linux 2.6.15.1
 */
#ifdef __i386__
#define SIZE_PAGEDESC_UP	(32)
#define SIZE_PAGEDESC_SMP	(44)
#define OFFSET_PAGE_FLAGS_UP	(0)
#define OFFSET_PAGE_FLAGS_SMP	(0)
#define OFFSET_PAGE__COUNT_UP	(4)
#define OFFSET_PAGE__COUNT_SMP	(4)
#define OFFSET_PAGE_MAPPING_UP	(16)
#define OFFSET_PAGE_MAPPING_SMP	(28)
#define PAGE_OFFSET     	0xc0000000
#define __VMALLOC_RESERVE       (128 << 20)
#define MAXMEM                  (-PAGE_OFFSET-__VMALLOC_RESERVE)
#endif /* i386 */
#ifdef __x86_64__
#define SIZE_PAGEDESC_UP	(56)
#define SIZE_PAGEDESC_SMP	(72)
#define OFFSET_PAGE_FLAGS_UP	(0)
#define OFFSET_PAGE_FLAGS_SMP	(0)
#define OFFSET_PAGE__COUNT_UP	(8)
#define OFFSET_PAGE__COUNT_SMP	(8)
#define OFFSET_PAGE_MAPPING_UP	(24)
#define OFFSET_PAGE_MAPPING_SMP	(40)
#define MAXMEM			0x3fffffffffffUL
#endif /* x86_64 */

#ifdef __ia64__ /* ia64 */
#endif          /* ia64 */

#define MSG(x...)	fprintf(stdout, x)
#define ERRMSG(x...)	fprintf(stderr, x)

struct pt_load_segment {
	loff_t			file_offset;
	unsigned long long	phys_start;
	unsigned long long	phys_end;
	unsigned long long	virt_start;
	unsigned long long	virt_end;
};

struct dump_bitmap {
	int		fd;
	int		no_block;
	char		*file_name;
	char		*buf;
	off_t		offset;
};

struct cache_data {
	int	fd;
	char	*file_name;
	char	*buf;
	size_t	buf_size;
	size_t	cache_size;
	off_t	offset;
};

struct DumpInfo {
	int		size_pagedesc;       /* size of page descriptor */
	int		offset_page_flags;   /* offset of page.flags */
	int		offset_page__count;  /* offset of page._count */
	int		offset_page_mapping; /* offset of page.mapping */
	int		flag_smp;            /* flag of smp.  0:up, 1:smp */
	unsigned long	addr_mem_map;        /* address of symbol mem_map */

	/*
	 * General info:
	 */
	int		dump_level;          /* dump level */
	int		flag_compress;       /* flag of compress */
	int		flag_elf;
	int		flag_elf_dumpfile;   /* flag of elf dump file */
	size_t		page_size;           /* size of page */
	unsigned int	max_mapnr;           /* number of page descriptor */

	/*
	 * diskdimp info:
	 */
	int		block_order;
	off_t		offset_bitmap1;
	unsigned long	len_bitmap;          /* size of bitmap(1st and 2nd) */
	struct disk_dump_header		*dump_header; 
	struct disk_dump_sub_header	*dump_sub_header; 

	/*
	 * ELF header info:
	 */
	unsigned int		num_load_memory;
	unsigned int		num_load_dumpfile;
	size_t			offset_load_memory;
	size_t			offset_load_dumpfile;
	struct pt_load_segment	*pt_load_segments;

	/*
	 * System.map file info:
	 */
	FILE			*map;
	char			*name_sysmap;

	/*
	 * Dump memory image info:
	 */
	int			fd_memory;
	char			*name_memory;

	/*
	 * Dump file info:
	 */
	int			fd_dumpfile;
	char			*name_dumpfile;

	/*
	 * bitmap info:
	 */
	int			fd_bitmap;
	char			*name_bitmap;
};
