#!/usr/bin/env ruby
require 'rubygems'
require 'ferret'
require 'fileutils'

include Ferret
include Ferret::Index

search_phrase = "earnings"

index = Index.new(:path => "index/")

highlight_options = {
  :field => :message,
  :pre_tag => "\033[36m",
  :post_tag => "\033[m",
  :ellipsis => " \342\200\246 "
}

index.search_each(search_phrase) do |id, score|
  puts "#{score} - #{index.highlight(search_phrase, id, highlight_options)}"
end

