#include <malloc.h>
#include <memory.h>
#include <stdio.h>
#include <process.h>
#include "ibase.h"

#define ERREXIT(status, rc)	{isc_print_status(status); abort();}

void Compare(const char* a, const char* b, size_t len)
{
	for (size_t i = 0; i<len; i++)
		if (a[i] != b[i])
		{
			printf("Comparsion failed at %d %u != %u\n", i, (unsigned char)a[i], (unsigned char)b[i]);
			return;
		}
}

int main(int argc, char* argv[])
{
    isc_stmt_handle         stmt = NULL;                /* statement handle */
    isc_db_handle           DB = NULL;                  /* database handle */
    isc_tr_handle           trans = NULL;               /* transaction handle */
    ISC_STATUS_ARRAY        status;                     /* status vector */
    XSQLDA  *               sqlda;

	if (isc_attach_database(status, 0, "TEST", &DB, 0, NULL))
        ERREXIT(status, 1)

    if (isc_start_transaction(status, &trans, 1, &DB, 0, NULL))
    {
        ERREXIT(status, 1)
    }
    
    /* Allocate an output SQLDA. */
    sqlda = (XSQLDA *) malloc(XSQLDA_LENGTH(3));
    sqlda->sqln = 3;
    sqlda->sqld = 3;
    sqlda->version = 1;

    /* Allocate a statement. */
    if (isc_dsql_allocate_statement(status, &DB, &stmt))
    {
        ERREXIT(status, 1)
    }
    
    /* Prepare the statement. */
    if (isc_dsql_prepare(status, &trans, &stmt, 0, "select rpad('a',32000,'b') a,rpad('a',32000,'b') b,rpad('a',32000,'b') c from rdb$database", 3, sqlda))
    {
        ERREXIT(status, 1)
    }
    
    /*
     *  Although all three selected columns are of type varchar, the
     *  third field's type is changed and printed as type TEXT.
     */


	char a[32002],b[32002],c[32002];
	char o[32002];

	o[0] = 32000%256;
	o[1] = 32000/256;
	o[2] = 'a';
	memset(o+3, 'b', 31999);

	short flag1 = 0, flag2 = 0, flag3 = 0;
    sqlda->sqlvar[0].sqldata = a;
	sqlda->sqlvar[0].sqlind = &flag1;
    sqlda->sqlvar[1].sqldata = b;
	sqlda->sqlvar[1].sqlind = &flag2;
    sqlda->sqlvar[2].sqldata = c;
	sqlda->sqlvar[2].sqlind = &flag3;

	printf("%s %d %d\n%s %d %d\n%s %d %d\n", sqlda->sqlvar[0].sqlname, sqlda->sqlvar[0].sqllen, sqlda->sqlvar[0].sqltype,
									sqlda->sqlvar[1].sqlname, sqlda->sqlvar[1].sqllen, sqlda->sqlvar[1].sqltype,
									sqlda->sqlvar[2].sqlname, sqlda->sqlvar[2].sqllen, sqlda->sqlvar[2].sqltype);

    /* Execute the statement. */

    if (isc_dsql_execute(status, &trans, &stmt, 3, NULL))
    {
        ERREXIT(status, 1)
    }
	printf("executed ok\n");

    /*
     *    Fetch and print the records.
     *    Status is 100 after the last row is fetched.
     */
	ISC_STATUS fetch_stat;

    while ((fetch_stat = isc_dsql_fetch(status, &stmt, 3, sqlda)) == 0)
    {
		printf("fetch ok\n");
		if (flag1 != 0)
			printf("a is NULL\n");
		Compare(a,o,32002);
		Compare(b,o,32002);
		Compare(c,o,32002);
    }

    if (fetch_stat != 100L)
    {
        ERREXIT(status, 1)
    }

    /* Free statement handle. */
	if (isc_dsql_free_statement(status, &stmt, DSQL_close))
    {
        ERREXIT(status, 1)
    }
	printf("statement closed\n");
	memset(a, 0, sizeof(a));
	memset(b, 0, sizeof(a));
	memset(c, 0, sizeof(a));

    if (isc_dsql_execute2(status, &trans, &stmt, 3, NULL, sqlda))
    {
        ERREXIT(status, 1)
    }
	printf("execute2 ok\n");
	Compare(a,o,32002);
	Compare(b,o,32002);
	Compare(c,o,32002);

    /* Free statement handle. */
	if (isc_dsql_free_statement(status, &stmt, DSQL_drop))
    {
        ERREXIT(status, 1)
    }
	stmt = 0;

	memset(a, 0, sizeof(a));
	memset(b, 0, sizeof(a));
	memset(c, 0, sizeof(a));

    if (isc_dsql_exec_immed2(status, &DB, &trans, 0, "select rpad('a',32000,'b') a,rpad('a',32000,'b') b,rpad('a',32000,'b') c from rdb$database", 3, NULL, sqlda))
    {
        ERREXIT(status, 1)
    }
	printf("execute immed2 ok\n");
	Compare(a,o,32002);
	Compare(b,o,32002);
	Compare(c,o,32002);

	memset(a, 0, sizeof(a));
	memset(b, 0, sizeof(a));
	memset(c, 0, sizeof(a));

    /* Allocate an input SQLDA. */
    XSQLDA* in_sqlda = (XSQLDA *) malloc(XSQLDA_LENGTH(3));
    in_sqlda->sqln = 3;
    in_sqlda->sqld = 3;
    in_sqlda->version = 1;

    /* Allocate a statement. */
    if (isc_dsql_allocate_statement(status, &DB, &stmt))
    {
        ERREXIT(status, 1)
    }
    
    /* Prepare the statement. */
    if (isc_dsql_prepare(status, &trans, &stmt, 0, "select cast(? as varchar(32000)) a,cast(? as varchar(32000)) b,cast(? as varchar(32000)) c from rdb$database", 3, sqlda))
    {
        ERREXIT(status, 1)
    }
	printf("prepared with params ok\n");

	if (isc_dsql_describe_bind(status, &stmt, 3, in_sqlda))
    {
        ERREXIT(status, 1)
    }
	printf("%s %d %d\n%s %d %d\n%s %d %d\n", in_sqlda->sqlvar[0].sqlname, in_sqlda->sqlvar[0].sqllen, in_sqlda->sqlvar[0].sqltype,
									in_sqlda->sqlvar[1].sqlname, in_sqlda->sqlvar[1].sqllen, in_sqlda->sqlvar[1].sqltype,
									in_sqlda->sqlvar[2].sqlname, in_sqlda->sqlvar[2].sqllen, in_sqlda->sqlvar[2].sqltype);

    in_sqlda->sqlvar[0].sqldata = o;
	in_sqlda->sqlvar[0].sqlind = &flag1;
    in_sqlda->sqlvar[1].sqldata = o;
	in_sqlda->sqlvar[1].sqlind = &flag2;
    in_sqlda->sqlvar[2].sqldata = o;
	in_sqlda->sqlvar[2].sqlind = &flag3;

    if (isc_dsql_execute(status, &trans, &stmt, 3, in_sqlda))
    {
        ERREXIT(status, 1)
    }
	printf("executed with params ok\n");

    /*
     *    Fetch and print the records.
     *    Status is 100 after the last row is fetched.
     */
    while ((fetch_stat = isc_dsql_fetch(status, &stmt, 3, sqlda)) == 0)
    {
		printf("fetch ok\n");
		if (flag1 != 0)
			printf("a is NULL\n");
		Compare(a,o,32002);
		Compare(b,o,32002);
		Compare(c,o,32002);
    }

    if (fetch_stat != 100L)
    {
        ERREXIT(status, 1)
    }

    /* Free statement handle. */
	if (isc_dsql_free_statement(status, &stmt, DSQL_close))
    {
        ERREXIT(status, 1)
    }
	printf("statement closed\n");
	memset(a, 0, sizeof(a));
	memset(b, 0, sizeof(a));
	memset(c, 0, sizeof(a));

    if (isc_dsql_execute2(status, &trans, &stmt, 3, in_sqlda, sqlda))
    {
        ERREXIT(status, 1)
    }
	printf("execute2 with params ok\n");
	Compare(a,o,32002);
	Compare(b,o,32002);
	Compare(c,o,32002);

    /* Free statement handle. */
	if (isc_dsql_free_statement(status, &stmt, DSQL_drop))
    {
        ERREXIT(status, 1)
    }
	stmt = 0;

	memset(a, 0, sizeof(a));
	memset(b, 0, sizeof(a));
	memset(c, 0, sizeof(a));

    if (isc_dsql_exec_immed2(status, &DB, &trans, 0, "select cast(? as varchar(32000)) a,cast(? as varchar(32000)) b,cast(? as varchar(32000)) c from rdb$database", 3, in_sqlda, sqlda))
    {
        ERREXIT(status, 1)
    }
	printf("execute immed2 with params ok\n");
	Compare(a,o,32002);
	Compare(b,o,32002);
	Compare(c,o,32002);

    if (isc_commit_transaction(status, &trans))
    {
        ERREXIT(status, 1)
    }
	printf("transaction committed\n");

    if (isc_detach_database(status, &DB))
    {
        ERREXIT(status, 1)
    }
	printf("detached\n");
    free( sqlda);

	return 0;
}

