#include <malloc.h>
#include <memory.h>
#include <stdio.h>
#include <process.h>
#include "ibase.h"

void print_blob_id(const char* w, ISC_QUAD blob_id)
{
	printf("%s: blob id = %x:%x\n", w, blob_id.gds_quad_high, blob_id.gds_quad_low);
}

int main(int argc, char* argv[])
{
    isc_stmt_handle         stmt = NULL;                /* statement handle */
    isc_db_handle           DB = NULL;                  /* database handle */
    isc_tr_handle           trans1 = NULL, trans2 = NULL;               /* transaction handle */
    ISC_STATUS_ARRAY        status;                     /* status vector */
    XSQLDA  *               sqlda;
	char tpb[] = {isc_tpb_version3, isc_tpb_read_committed, isc_tpb_rec_version};

	if (isc_attach_database(status, 0, "D_TEST", &DB, 0, NULL))
	{
        isc_print_status(status);
		exit(1);
	}

    if (isc_start_transaction(status, &trans1, 1, &DB, sizeof(tpb), tpb))
    {
		printf("transaction 1 failed to start\n");
        isc_print_status(status);
    }
	else
	{
		/* Allocate an output SQLDA. */
		sqlda = (XSQLDA *) malloc(XSQLDA_LENGTH(1));
		sqlda->sqln = 1;
		sqlda->sqld = 1;
		sqlda->version = 1;

		/* Allocate a statement. */
		if (isc_dsql_allocate_statement(status, &DB, &stmt))
		{
			printf("statement allocation failed\n");
			isc_print_status(status);
		}
		else
		{
			/* Prepare the statement. */
			if (isc_dsql_prepare(status, &trans1, &stmt, 0, "select b from g_test", 3, sqlda))
			{
				printf("preparation failed\n");
				isc_print_status(status);
			}
			else
			{
				short flag = 0;
				ISC_QUAD blob_id, saved_blob_id;

				sqlda->sqlvar[0].sqldata = (char*)&blob_id;
				sqlda->sqlvar[0].sqlind = &flag;

				if (isc_dsql_execute2(status, &trans1, &stmt, 3, NULL, sqlda))
				{
					printf("execution failed\n");
					isc_print_status(status);

				}
				else
				{
					saved_blob_id = blob_id;
					print_blob_id("tx1", saved_blob_id);
					if (isc_start_transaction(status, &trans2, 1, &DB, 0, NULL))
					{
						printf("start transaction 2 failed\n");
						isc_print_status(status);
					}
					else
					{
						// use returning here instead of select to prevent garbage collection
						if (isc_dsql_exec_immed2(status, &DB, &trans2, 0, "update g_test set b='abcdef' returning b", 3, NULL, sqlda))
						{
							printf("execute 2 failed\n");
							isc_print_status(status);
						}
						else
						{
							print_blob_id("tx2", blob_id);
						}

						if (isc_commit_transaction(status, &trans2))
						{
							printf("commit trnsaction 2 failed\n");
							isc_print_status(status);
						}
						blob_id = saved_blob_id;
						if (isc_dsql_exec_immed2(status, &DB, &trans1, 0, "update g_test set b=?", 3, sqlda, NULL))
						{
							printf("execute 3 failed\n");
							isc_print_status(status);
						}
						else
						{
							if (isc_dsql_execute2(status, &trans1, &stmt, 3, NULL, sqlda))
							{
								printf("execution 2 failed\n");
								isc_print_status(status);
							}
							else
							{
								print_blob_id("tx1", blob_id);
							}
						}
					}
				}
			}
			/* Free statement handle. */
			if (isc_dsql_free_statement(status, &stmt, DSQL_drop))
			{
				printf("statement drop failed\n");
				isc_print_status(status);
			}
			stmt = 0;


			//if (isc_dsql_execute2(status, &trans, &stmt, 3, in_sqlda, sqlda))
			//{
			//	ERREXIT(status, 1)
			//}
		}
		if (isc_commit_transaction(status, &trans1))
		{
			printf("commit failed\n");
			isc_print_status(status);
		}
	    free( sqlda);
	}

    if (isc_detach_database(status, &DB))
    {
		printf("detach failed\n");
		isc_print_status(status);
    }
	fb_shutdown(0,fb_shutrsn_app_stopped);
	return 0;
}
