#ifndef FB_INTERFACE_14_08_04_17_03_47
#define FB_INTERFACE_14_08_04_17_03_47


// Forward declaration - used to identify client and provider of upgraded interface
class IPluginModule;


// Versioned interface - base for all FB interfaces

// Std cpp lines for root interface
#define FB_IFACE_VERSION(S) (sizeof(S::VTable) / sizeof(void*))

#if defined(WIN32) || defined(_WIN32) || defined(__WIN32__)
#	define FB_CARG __cdecl
#else
#	define FB_CARG
#endif

class IVersioned
{
protected:
	void* IDL_vt;

	struct VTable
	{
		int (FB_CARG *getVersion)(IVersioned*);
		IPluginModule* (FB_CARG *getModule)(IVersioned*);
	};

public:
	int getVersion() { return static_cast<VTable*>(IDL_vt)->getVersion(this); }
	IPluginModule* getModule() { return static_cast<VTable*>(IDL_vt)->getModule(this); }
};


// Reference counted interface - base for refCounted FB interfaces

class IRefCounted : public IVersioned
{
protected:
	struct VTable : public IVersioned::VTable
	{
		void (FB_CARG *addRef)(IRefCounted*);
		int (FB_CARG *release)(IRefCounted*);
		void (FB_CARG *addRefCaller)(IRefCounted*);
	};

public:
	void addRef() { static_cast<VTable*>(IDL_vt)->addRef(this); }
	int release() { return static_cast<VTable*>(IDL_vt)->release(this); }
	void addRefCaller() { static_cast<VTable*>(IDL_vt)->addRefCaller(this); }
};


template <typename Name, typename Base>
class IVersionedImpl : public Base
{
public:
	IVersionedImpl()
	{
		static bool first = true;
		static typename Base::VTable vTable;

		if (first)
		{
			vTable.getVersion = &Name::FgetVersion;
			vTable.getModule = &Name::FgetModule;

			first = false;
		}

		this->IDL_vt = &vTable;
	}

protected:
	static int FB_CARG FgetVersion(IVersioned* me) throw()
	{
		return static_cast<Name*>(me)->getVersion_();
	}

	static IPluginModule* FB_CARG FgetModule(IVersioned* me) throw()
	{
		return static_cast<Name*>(me)->getModule_();
	}
};


template <typename Name, typename Base>
class IRefCountedImpl : public Base
{
public:
	IRefCountedImpl()
	{
		static bool first = true;
		static typename Base::VTable vTable;

		if (first)
		{
			vTable.getVersion = &Name::FgetVersion;
			vTable.getModule = &Name::FgetModule;
			vTable.addRef = &Name::FaddRef;
			vTable.release = &Name::Frelease;
			vTable.addRefCaller = &Name::FaddRefCaller;

			first = false;
		}

		this->IDL_vt = &vTable;
	}

protected:
	static void FB_CARG FaddRef(IRefCounted* me) throw()
	{
		static_cast<Name*>(me)->addRef_();
	}

	static int FB_CARG Frelease(IRefCounted* me) throw()
	{
		return static_cast<Name*>(me)->release_();
	}

	static void FB_CARG FaddRefCaller(IRefCounted* me) throw()
	{
		static_cast<Name*>(me)->addRefCaller_();
	}
};


#endif //FB_INTERFACE_14_08_04_17_03_47
