#include <stdio.h>
#include "Interface.h"


class RefCounted : public IRefCountedImpl<RefCounted, IVersionedImpl<RefCounted, IRefCounted> >
{
public:
	RefCounted()
		: n(0)
	{
	}

	int getVersion_();
	IPluginModule* getModule_();
	void addRef_();
	int release_();
	void addRefCaller_();

private:
	int n;		// should be atomic var
};

int RefCounted::getVersion_()
{
	return FB_IFACE_VERSION(IRefCounted);
}

IPluginModule* RefCounted::getModule_()
{
	return NULL;	// That's just the sample :)
}

// If I miss this method, no compile/link error, but runtime crash. 
void RefCounted::addRef_()
{
	++n;
}

int RefCounted::release_()
{
	int m = --n;
	if (!m)
	{
		printf("Release RefCounted object\n");
		delete this;
	}
	return m;
}

void RefCounted::addRefCaller_()
{
	addRef();
}


class RefCounted2 : public IRefCountedImpl<RefCounted2, RefCounted>
{
public:
	void addRef_()
	{
		printf("RefCounted2::addRef\n");
		RefCounted::addRef_();
	}

	int release_()
	{
		printf("RefCounted2::release\n");
		return RefCounted::release_();	//// FIXME: leak, should reimplement release_
	}
};


IRefCounted* getRefCounted()
{
	IRefCounted* rc = new RefCounted();
	rc->addRef();
	return rc;
}

IRefCounted* getRefCounted2()
{
	IRefCounted* rc = new RefCounted2();
	rc->addRef();
	return rc;
}
