#include <stdio.h>
#include "Interface.h"


class RefCounted : public IRefCountedImpl<RefCounted>
{
public:
	RefCounted()
		: n(0)
	{
	}

	int getVersion();
	IPluginModule* getModule();
	void addRef();
	int release();
	void addRefCaller();

private:
	int n;		// should be atomic var
};

int RefCounted::getVersion()
{
	return FB_IFACE_VERSION(IRefCounted);
}

IPluginModule* RefCounted::getModule()
{
	return NULL;	// That's just the sample :)
}

// If I miss this method, no compile/link error, but runtime crash. 
void RefCounted::addRef()
{
	++n;
}

int RefCounted::release()
{
	int m = --n;
	if (!m)
	{
		printf("Release RefCounted object\n");
		delete this;
	}
	return m;
}

void RefCounted::addRefCaller()
{
	IRefCounted::addRef();
}


class RefCounted2 : public IRefCountedImpl<RefCounted2, RefCounted>
{
public:
	void addRef()
	{
		printf("RefCounted2::addRef\n");
		RefCounted::addRef();
	}

	int release()
	{
		printf("RefCounted2::release\n");
		return RefCounted::release();	//// FIXME: leak, should reimplement release_
	}
};


IRefCounted* getRefCounted()
{
	IRefCounted* rc = new RefCounted();
	rc->addRef();
	return rc;
}

IRefCounted* getRefCounted2()
{
	IRefCounted* rc = new RefCounted2();
	rc->addRef();
	return rc;
}
