#ifndef FB_INTERFACE_14_08_04_17_03_47
#define FB_INTERFACE_14_08_04_17_03_47


#include <stdint.h>


// Forward declaration - used to identify client and provider of upgraded interface
class IPluginModule;


// Versioned interface - base for all FB interfaces

// Std cpp lines for root interface
#define FB_IFACE_VERSION(S) (sizeof(S::VTable) / sizeof(void*))

#if defined(WIN32) || defined(_WIN32) || defined(__WIN32__)
#	define FB_CARG __cdecl
#else
#	define FB_CARG
#endif


class IInterface
{
protected:
	struct VTable
	{
		uintptr_t version;
	};

	template <typename T>
	inline void checkVersion()
	{
		if (T::VERSION < IDL_vt->version)
		{
			// throw
		}
	}

	VTable* IDL_vt;

public:
	static const int VERSION = sizeof(VTable) / sizeof(void*);
};


class IVersioned : public IInterface
{
protected:
	struct VTable : public IInterface::VTable
	{
		int (FB_CARG *getVersion)(IVersioned*);
		IPluginModule* (FB_CARG *getModule)(IVersioned*);
	};

public:
	static const int VERSION = sizeof(VTable) / sizeof(void*);

public:
	//// TODO: Add conversion from IStatus to C++ exception.
	int getVersion() { checkVersion<IVersioned>(); return static_cast<VTable*>(IDL_vt)->getVersion(this); }
	IPluginModule* getModule() { checkVersion<IVersioned>(); return static_cast<VTable*>(IDL_vt)->getModule(this); }
};


// Reference counted interface - base for refCounted FB interfaces

class IRefCounted : public IVersioned
{
protected:
	struct VTable : public IVersioned::VTable
	{
		void (FB_CARG *addRef)(IRefCounted*);
		int (FB_CARG *release)(IRefCounted*);
		void (FB_CARG *addRefCaller)(IRefCounted*);
	};

public:
	static const int VERSION = sizeof(VTable) / sizeof(void*);

public:
	//// TODO: Add conversion from IStatus to C++ exception.
	void addRef() { checkVersion<IRefCounted>(); static_cast<VTable*>(IDL_vt)->addRef(this); }
	int release() { checkVersion<IRefCounted>(); return static_cast<VTable*>(IDL_vt)->release(this); }
	void addRefCaller() { checkVersion<IRefCounted>(); static_cast<VTable*>(IDL_vt)->addRefCaller(this); }
};


template <typename Name, typename Base>
class IVersionedImpl : public Base
{
public:
	IVersionedImpl()
	{
		static bool first = true;
		static typename Base::VTable vTable;

		if (first)
		{
			vTable.version = Base::VERSION;
			vTable.getVersion = &Name::getVersionDispatcher;
			vTable.getModule = &Name::getModuleDispatcher;

			first = false;
		}

		this->IDL_vt = &vTable;
	}

	// No need to check version in the implementation.
	//// TODO: Add conversion from IStatus to C++ exception.
	int getVersion() { return static_cast<typename Base::VTable*>(this->IDL_vt)->getVersion(this); }
	IPluginModule* getModule() { return static_cast<typename Base::VTable*>(this->IDL_vt)->getModule(this); }

protected:
	//// TODO: Add conversion from C++ exception to IStatus.

	static int FB_CARG getVersionDispatcher(IVersioned* me) throw()
	{
		return static_cast<Name*>(me)->getVersionImpl();
	}

	static IPluginModule* FB_CARG getModuleDispatcher(IVersioned* me) throw()
	{
		return static_cast<Name*>(me)->getModuleImpl();
	}
};


template <typename Name, typename Base = IVersionedImpl<Name, IRefCounted> >
class IRefCountedImpl : public Base
{
public:
	IRefCountedImpl()
	{
		static bool first = true;
		static typename Base::VTable vTable;

		if (first)
		{
			vTable.version = Base::VERSION;
			vTable.getVersion = &Name::getVersionDispatcher;
			vTable.getModule = &Name::getModuleDispatcher;
			vTable.addRef = &Name::addRefDispatcher;
			vTable.release = &Name::releaseDispatcher;
			vTable.addRefCaller = &Name::addRefCallerDispatcher;

			first = false;
		}

		this->IDL_vt = &vTable;
	}

	// No need to check version in the implementation.
	//// TODO: Add conversion from IStatus to C++ exception.
	void addRef() { static_cast<typename Base::VTable*>(this->IDL_vt)->addRef(this); }
	int release() { return static_cast<typename Base::VTable*>(this->IDL_vt)->release(this); }
	void addRefCaller() { static_cast<typename Base::VTable*>(this->IDL_vt)->addRefCaller(this); }

protected:
	//// TODO: Add conversion from C++ exception to IStatus.

	static void FB_CARG addRefDispatcher(IRefCounted* me) throw()
	{
		static_cast<Name*>(me)->addRefImpl();
	}

	static int FB_CARG releaseDispatcher(IRefCounted* me) throw()
	{
		return static_cast<Name*>(me)->releaseImpl();
	}

	static void FB_CARG addRefCallerDispatcher(IRefCounted* me) throw()
	{
		static_cast<Name*>(me)->addRefCallerImpl();
	}
};


#endif //FB_INTERFACE_14_08_04_17_03_47
