#include <stdio.h>
#include "Interface.h"


class PluginModule : public IPluginModuleImpl<PluginModule>
{
public:
};


class RefCounted : public IRefCountedImpl<RefCounted>
{
public:
	RefCounted()
		: n(0)
	{
	}

	int getVersionImpl();
	IPluginModule* getModuleImpl();
	void addRefImpl();
	int releaseImpl();
	void addRefCallerImpl();

private:
	int n;		// should be atomic var
};

int RefCounted::getVersionImpl()
{
	///return VERSION;
	return IDL_vt->version;
}

IPluginModule* RefCounted::getModuleImpl()
{
	return new PluginModule();
}

// If I miss this method, no compile/link error, but runtime crash. 
void RefCounted::addRefImpl()
{
	++n;
}

int RefCounted::releaseImpl()
{
	int m = --n;
	if (!m)
	{
		printf("Release RefCounted object\n");
		delete this;
	}
	return m;
}

void RefCounted::addRefCallerImpl()
{
	addRef();
}


class RefCounted2 : public IRefCountedImpl<RefCounted2, RefCounted>
{
public:
	void addRefImpl()
	{
		printf("RefCounted2::addRef\n");
		RefCounted::addRefImpl();
	}

	int releaseImpl()
	{
		printf("RefCounted2::release\n");
		return RefCounted::releaseImpl();	//// FIXME: leak, should reimplement releaseImpl
	}
};


IRefCounted* getRefCounted()
{
	IRefCounted* rc = new RefCounted();
	rc->addRef();
	return rc;
}

IRefCounted* getRefCounted2()
{
	IRefCounted* rc = new RefCounted2();
	rc->addRef();
	return rc;
}
