set term ^;

execute block returns(usr varchar(31), passwd varchar(36))
as
declare variable frst varchar(32);
declare variable mddl varchar(32);
declare variable lst varchar(32);
declare variable attr varchar(4096);
declare variable sql varchar(4096);
declare variable uid int;
declare variable gid int;

begin
for select RDB$USER_NAME, RDB$FIRST_NAME, RDB$MIDDLE_NAME, RDB$LAST_NAME, RDB$UID, RDB$GID,
	uuid_to_char(gen_uuid()) from RDB$USERS
	where RDB$USER_NAME is not null and upper(RDB$USER_NAME) != 'SYSDBA'
into :usr, :frst, :mddl, :lst, :uid, :gid, :passwd
do begin
	-- basic fields
	sql = 'create or alter user ' || usr || ' password ''' || passwd || '''';
	if (frst is not null) then sql = sql || ' firstname ''' || frst || '''';
	if (mddl is not null) then sql = sql || ' middlename ''' || mddl || '''';
	if (lst is not null) then sql = sql || ' lastname ''' || lst || '''';
	sql = sql || ' active';

	-- attributes
	attr = '';
	if (uid is not null) then attr = 'uid=''' || uid || '''';
	if (gid is not null) then begin
		if (char_length(attr) > 0) then attr = attr || ', ';
		attr = attr || 'gid=''' || gid || '''';
	end
	if (char_length(attr) > 0) then begin
		sql = sql || ' tags (' || attr || ')';
	end

	-- create it
	execute statement sql;
	-- and show password to admin
	suspend;
end

end^

commit^

exit^
