/* This file was autogenerated by cloop - Cross Language Object Oriented Programming */

#ifndef FIREBIRD_C_API_H
#define FIREBIRD_C_API_H

#include <stdint.h>

#ifndef CLOOP_EXTERN_C
#ifdef __cplusplus
#define CLOOP_EXTERN_C extern "C"
#else
#define CLOOP_EXTERN_C
#endif
#endif


struct FIREBIRD_IVersioned;
struct FIREBIRD_IReferenceCounted;
struct FIREBIRD_IDisposable;
struct FIREBIRD_IStatus;
struct FIREBIRD_IMaster;
struct FIREBIRD_IPluginBase;
struct FIREBIRD_IPluginSet;
struct FIREBIRD_IConfigEntry;
struct FIREBIRD_IConfig;
struct FIREBIRD_IFirebirdConf;
struct FIREBIRD_IPluginConfig;
struct FIREBIRD_IPluginFactory;
struct FIREBIRD_IPluginModule;
struct FIREBIRD_IPluginManager;
struct FIREBIRD_ICryptKey;
struct FIREBIRD_IConfigManager;
struct FIREBIRD_IEventCallback;
struct FIREBIRD_IBlob;
struct FIREBIRD_ITransaction;
struct FIREBIRD_IMessageMetadata;
struct FIREBIRD_IMetadataBuilder;
struct FIREBIRD_IResultSet;
struct FIREBIRD_IStatement;
struct FIREBIRD_IBatch;
struct FIREBIRD_IBatchCompletionState;
struct FIREBIRD_IReplicator;
struct FIREBIRD_IRequest;
struct FIREBIRD_IEvents;
struct FIREBIRD_IAttachment;
struct FIREBIRD_IService;
struct FIREBIRD_IProvider;
struct FIREBIRD_IDtcStart;
struct FIREBIRD_IDtc;
struct FIREBIRD_IAuth;
struct FIREBIRD_IWriter;
struct FIREBIRD_IServerBlock;
struct FIREBIRD_IClientBlock;
struct FIREBIRD_IServer;
struct FIREBIRD_IClient;
struct FIREBIRD_IUserField;
struct FIREBIRD_ICharUserField;
struct FIREBIRD_IIntUserField;
struct FIREBIRD_IUser;
struct FIREBIRD_IListUsers;
struct FIREBIRD_ILogonInfo;
struct FIREBIRD_IManagement;
struct FIREBIRD_IAuthBlock;
struct FIREBIRD_IWireCryptPlugin;
struct FIREBIRD_ICryptKeyCallback;
struct FIREBIRD_IKeyHolderPlugin;
struct FIREBIRD_IDbCryptInfo;
struct FIREBIRD_IDbCryptPlugin;
struct FIREBIRD_IExternalContext;
struct FIREBIRD_IExternalResultSet;
struct FIREBIRD_IExternalFunction;
struct FIREBIRD_IExternalProcedure;
struct FIREBIRD_IExternalTrigger;
struct FIREBIRD_IRoutineMetadata;
struct FIREBIRD_IExternalEngine;
struct FIREBIRD_ITimer;
struct FIREBIRD_ITimerControl;
struct FIREBIRD_IVersionCallback;
struct FIREBIRD_IUtil;
struct FIREBIRD_IOffsetsCallback;
struct FIREBIRD_IXpbBuilder;
struct FIREBIRD_ITraceConnection;
struct FIREBIRD_ITraceDatabaseConnection;
struct FIREBIRD_ITraceTransaction;
struct FIREBIRD_ITraceParams;
struct FIREBIRD_ITraceStatement;
struct FIREBIRD_ITraceSQLStatement;
struct FIREBIRD_ITraceBLRStatement;
struct FIREBIRD_ITraceDYNRequest;
struct FIREBIRD_ITraceContextVariable;
struct FIREBIRD_ITraceProcedure;
struct FIREBIRD_ITraceFunction;
struct FIREBIRD_ITraceTrigger;
struct FIREBIRD_ITraceServiceConnection;
struct FIREBIRD_ITraceStatusVector;
struct FIREBIRD_ITraceSweepInfo;
struct FIREBIRD_ITraceLogWriter;
struct FIREBIRD_ITraceInitInfo;
struct FIREBIRD_ITracePlugin;
struct FIREBIRD_ITraceFactory;
struct FIREBIRD_IUdrFunctionFactory;
struct FIREBIRD_IUdrProcedureFactory;
struct FIREBIRD_IUdrTriggerFactory;
struct FIREBIRD_IUdrPlugin;
struct FIREBIRD_IDecFloat16;
struct FIREBIRD_IDecFloat34;
struct FIREBIRD_IInt128;
struct FIREBIRD_IReplicatedField;
struct FIREBIRD_IReplicatedRecord;
struct FIREBIRD_IReplicatedTransaction;
struct FIREBIRD_IReplicatedSession;


#define FIREBIRD_IVersioned_VERSION 1

struct FIREBIRD_IVersioned;

struct FIREBIRD_IVersionedVTable
{
	void* cloopDummy[1];
	uintptr_t version;
};

struct FIREBIRD_IVersioned
{
	void* cloopDummy[1];
	struct FIREBIRD_IVersionedVTable* vtable;
};


#define FIREBIRD_IReferenceCounted_VERSION 2

struct FIREBIRD_IReferenceCounted;

struct FIREBIRD_IReferenceCountedVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IReferenceCounted* self);
	int (*release)(struct FIREBIRD_IReferenceCounted* self);
};

struct FIREBIRD_IReferenceCounted
{
	void* cloopDummy[1];
	struct FIREBIRD_IReferenceCountedVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IReferenceCounted_addRef(struct FIREBIRD_IReferenceCounted* self);
CLOOP_EXTERN_C int FIREBIRD_IReferenceCounted_release(struct FIREBIRD_IReferenceCounted* self);

#define FIREBIRD_IDisposable_VERSION 2

struct FIREBIRD_IDisposable;

struct FIREBIRD_IDisposableVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*dispose)(struct FIREBIRD_IDisposable* self);
};

struct FIREBIRD_IDisposable
{
	void* cloopDummy[1];
	struct FIREBIRD_IDisposableVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IDisposable_dispose(struct FIREBIRD_IDisposable* self);

#define FIREBIRD_IStatus_VERSION 3

#define FIREBIRD_IStatus_STATE_WARNINGS ((unsigned) (0x1))
#define FIREBIRD_IStatus_STATE_ERRORS ((unsigned) (0x2))
#define FIREBIRD_IStatus_RESULT_ERROR ((int) (-1))
#define FIREBIRD_IStatus_RESULT_OK ((int) (0))
#define FIREBIRD_IStatus_RESULT_NO_DATA ((int) (1))
#define FIREBIRD_IStatus_RESULT_SEGMENT ((int) (2))

struct FIREBIRD_IStatus;

struct FIREBIRD_IStatusVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*dispose)(struct FIREBIRD_IStatus* self);
	void (*init)(struct FIREBIRD_IStatus* self);
	unsigned (*getState)(const struct FIREBIRD_IStatus* self);
	void (*setErrors2)(struct FIREBIRD_IStatus* self, unsigned length, const intptr_t* value);
	void (*setWarnings2)(struct FIREBIRD_IStatus* self, unsigned length, const intptr_t* value);
	void (*setErrors)(struct FIREBIRD_IStatus* self, const intptr_t* value);
	void (*setWarnings)(struct FIREBIRD_IStatus* self, const intptr_t* value);
	const intptr_t* (*getErrors)(const struct FIREBIRD_IStatus* self);
	const intptr_t* (*getWarnings)(const struct FIREBIRD_IStatus* self);
	struct FIREBIRD_IStatus* (*clone)(const struct FIREBIRD_IStatus* self);
};

struct FIREBIRD_IStatus
{
	void* cloopDummy[1];
	struct FIREBIRD_IStatusVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IStatus_dispose(struct FIREBIRD_IStatus* self);
CLOOP_EXTERN_C void FIREBIRD_IStatus_init(struct FIREBIRD_IStatus* self);
CLOOP_EXTERN_C unsigned FIREBIRD_IStatus_getState(const struct FIREBIRD_IStatus* self);
CLOOP_EXTERN_C void FIREBIRD_IStatus_setErrors2(struct FIREBIRD_IStatus* self, unsigned length, const intptr_t* value);
CLOOP_EXTERN_C void FIREBIRD_IStatus_setWarnings2(struct FIREBIRD_IStatus* self, unsigned length, const intptr_t* value);
CLOOP_EXTERN_C void FIREBIRD_IStatus_setErrors(struct FIREBIRD_IStatus* self, const intptr_t* value);
CLOOP_EXTERN_C void FIREBIRD_IStatus_setWarnings(struct FIREBIRD_IStatus* self, const intptr_t* value);
CLOOP_EXTERN_C const intptr_t* FIREBIRD_IStatus_getErrors(const struct FIREBIRD_IStatus* self);
CLOOP_EXTERN_C const intptr_t* FIREBIRD_IStatus_getWarnings(const struct FIREBIRD_IStatus* self);
CLOOP_EXTERN_C struct FIREBIRD_IStatus* FIREBIRD_IStatus_clone(const struct FIREBIRD_IStatus* self);

#define FIREBIRD_IMaster_VERSION 2

struct FIREBIRD_IMaster;

struct FIREBIRD_IMasterVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	struct FIREBIRD_IStatus* (*getStatus)(struct FIREBIRD_IMaster* self);
	struct FIREBIRD_IProvider* (*getDispatcher)(struct FIREBIRD_IMaster* self);
	struct FIREBIRD_IPluginManager* (*getPluginManager)(struct FIREBIRD_IMaster* self);
	struct FIREBIRD_ITimerControl* (*getTimerControl)(struct FIREBIRD_IMaster* self);
	struct FIREBIRD_IDtc* (*getDtc)(struct FIREBIRD_IMaster* self);
	struct FIREBIRD_IAttachment* (*registerAttachment)(struct FIREBIRD_IMaster* self, struct FIREBIRD_IProvider* provider, struct FIREBIRD_IAttachment* attachment);
	struct FIREBIRD_ITransaction* (*registerTransaction)(struct FIREBIRD_IMaster* self, struct FIREBIRD_IAttachment* attachment, struct FIREBIRD_ITransaction* transaction);
	struct FIREBIRD_IMetadataBuilder* (*getMetadataBuilder)(struct FIREBIRD_IMaster* self, struct FIREBIRD_IStatus* status, unsigned fieldCount);
	int (*serverMode)(struct FIREBIRD_IMaster* self, int mode);
	struct FIREBIRD_IUtil* (*getUtilInterface)(struct FIREBIRD_IMaster* self);
	struct FIREBIRD_IConfigManager* (*getConfigManager)(struct FIREBIRD_IMaster* self);
	FB_BOOLEAN (*getProcessExiting)(struct FIREBIRD_IMaster* self);
};

struct FIREBIRD_IMaster
{
	void* cloopDummy[1];
	struct FIREBIRD_IMasterVTable* vtable;
};

CLOOP_EXTERN_C struct FIREBIRD_IStatus* FIREBIRD_IMaster_getStatus(struct FIREBIRD_IMaster* self);
CLOOP_EXTERN_C struct FIREBIRD_IProvider* FIREBIRD_IMaster_getDispatcher(struct FIREBIRD_IMaster* self);
CLOOP_EXTERN_C struct FIREBIRD_IPluginManager* FIREBIRD_IMaster_getPluginManager(struct FIREBIRD_IMaster* self);
CLOOP_EXTERN_C struct FIREBIRD_ITimerControl* FIREBIRD_IMaster_getTimerControl(struct FIREBIRD_IMaster* self);
CLOOP_EXTERN_C struct FIREBIRD_IDtc* FIREBIRD_IMaster_getDtc(struct FIREBIRD_IMaster* self);
CLOOP_EXTERN_C struct FIREBIRD_IAttachment* FIREBIRD_IMaster_registerAttachment(struct FIREBIRD_IMaster* self, struct FIREBIRD_IProvider* provider, struct FIREBIRD_IAttachment* attachment);
CLOOP_EXTERN_C struct FIREBIRD_ITransaction* FIREBIRD_IMaster_registerTransaction(struct FIREBIRD_IMaster* self, struct FIREBIRD_IAttachment* attachment, struct FIREBIRD_ITransaction* transaction);
CLOOP_EXTERN_C struct FIREBIRD_IMetadataBuilder* FIREBIRD_IMaster_getMetadataBuilder(struct FIREBIRD_IMaster* self, struct FIREBIRD_IStatus* status, unsigned fieldCount);
CLOOP_EXTERN_C int FIREBIRD_IMaster_serverMode(struct FIREBIRD_IMaster* self, int mode);
CLOOP_EXTERN_C struct FIREBIRD_IUtil* FIREBIRD_IMaster_getUtilInterface(struct FIREBIRD_IMaster* self);
CLOOP_EXTERN_C struct FIREBIRD_IConfigManager* FIREBIRD_IMaster_getConfigManager(struct FIREBIRD_IMaster* self);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_IMaster_getProcessExiting(struct FIREBIRD_IMaster* self);

#define FIREBIRD_IPluginBase_VERSION 3

struct FIREBIRD_IPluginBase;

struct FIREBIRD_IPluginBaseVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IPluginBase* self);
	int (*release)(struct FIREBIRD_IPluginBase* self);
	void (*setOwner)(struct FIREBIRD_IPluginBase* self, struct FIREBIRD_IReferenceCounted* r);
	struct FIREBIRD_IReferenceCounted* (*getOwner)(struct FIREBIRD_IPluginBase* self);
};

struct FIREBIRD_IPluginBase
{
	void* cloopDummy[1];
	struct FIREBIRD_IPluginBaseVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IPluginBase_addRef(struct FIREBIRD_IPluginBase* self);
CLOOP_EXTERN_C int FIREBIRD_IPluginBase_release(struct FIREBIRD_IPluginBase* self);
CLOOP_EXTERN_C void FIREBIRD_IPluginBase_setOwner(struct FIREBIRD_IPluginBase* self, struct FIREBIRD_IReferenceCounted* r);
CLOOP_EXTERN_C struct FIREBIRD_IReferenceCounted* FIREBIRD_IPluginBase_getOwner(struct FIREBIRD_IPluginBase* self);

#define FIREBIRD_IPluginSet_VERSION 3

struct FIREBIRD_IPluginSet;

struct FIREBIRD_IPluginSetVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IPluginSet* self);
	int (*release)(struct FIREBIRD_IPluginSet* self);
	const char* (*getName)(const struct FIREBIRD_IPluginSet* self);
	const char* (*getModuleName)(const struct FIREBIRD_IPluginSet* self);
	struct FIREBIRD_IPluginBase* (*getPlugin)(struct FIREBIRD_IPluginSet* self, struct FIREBIRD_IStatus* status);
	void (*next)(struct FIREBIRD_IPluginSet* self, struct FIREBIRD_IStatus* status);
	void (*set)(struct FIREBIRD_IPluginSet* self, struct FIREBIRD_IStatus* status, const char* s);
};

struct FIREBIRD_IPluginSet
{
	void* cloopDummy[1];
	struct FIREBIRD_IPluginSetVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IPluginSet_addRef(struct FIREBIRD_IPluginSet* self);
CLOOP_EXTERN_C int FIREBIRD_IPluginSet_release(struct FIREBIRD_IPluginSet* self);
CLOOP_EXTERN_C const char* FIREBIRD_IPluginSet_getName(const struct FIREBIRD_IPluginSet* self);
CLOOP_EXTERN_C const char* FIREBIRD_IPluginSet_getModuleName(const struct FIREBIRD_IPluginSet* self);
CLOOP_EXTERN_C struct FIREBIRD_IPluginBase* FIREBIRD_IPluginSet_getPlugin(struct FIREBIRD_IPluginSet* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IPluginSet_next(struct FIREBIRD_IPluginSet* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IPluginSet_set(struct FIREBIRD_IPluginSet* self, struct FIREBIRD_IStatus* status, const char* s);

#define FIREBIRD_IConfigEntry_VERSION 3

struct FIREBIRD_IConfigEntry;

struct FIREBIRD_IConfigEntryVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IConfigEntry* self);
	int (*release)(struct FIREBIRD_IConfigEntry* self);
	const char* (*getName)(struct FIREBIRD_IConfigEntry* self);
	const char* (*getValue)(struct FIREBIRD_IConfigEntry* self);
	ISC_INT64 (*getIntValue)(struct FIREBIRD_IConfigEntry* self);
	FB_BOOLEAN (*getBoolValue)(struct FIREBIRD_IConfigEntry* self);
	struct FIREBIRD_IConfig* (*getSubConfig)(struct FIREBIRD_IConfigEntry* self, struct FIREBIRD_IStatus* status);
};

struct FIREBIRD_IConfigEntry
{
	void* cloopDummy[1];
	struct FIREBIRD_IConfigEntryVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IConfigEntry_addRef(struct FIREBIRD_IConfigEntry* self);
CLOOP_EXTERN_C int FIREBIRD_IConfigEntry_release(struct FIREBIRD_IConfigEntry* self);
CLOOP_EXTERN_C const char* FIREBIRD_IConfigEntry_getName(struct FIREBIRD_IConfigEntry* self);
CLOOP_EXTERN_C const char* FIREBIRD_IConfigEntry_getValue(struct FIREBIRD_IConfigEntry* self);
CLOOP_EXTERN_C ISC_INT64 FIREBIRD_IConfigEntry_getIntValue(struct FIREBIRD_IConfigEntry* self);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_IConfigEntry_getBoolValue(struct FIREBIRD_IConfigEntry* self);
CLOOP_EXTERN_C struct FIREBIRD_IConfig* FIREBIRD_IConfigEntry_getSubConfig(struct FIREBIRD_IConfigEntry* self, struct FIREBIRD_IStatus* status);

#define FIREBIRD_IConfig_VERSION 3

struct FIREBIRD_IConfig;

struct FIREBIRD_IConfigVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IConfig* self);
	int (*release)(struct FIREBIRD_IConfig* self);
	struct FIREBIRD_IConfigEntry* (*find)(struct FIREBIRD_IConfig* self, struct FIREBIRD_IStatus* status, const char* name);
	struct FIREBIRD_IConfigEntry* (*findValue)(struct FIREBIRD_IConfig* self, struct FIREBIRD_IStatus* status, const char* name, const char* value);
	struct FIREBIRD_IConfigEntry* (*findPos)(struct FIREBIRD_IConfig* self, struct FIREBIRD_IStatus* status, const char* name, unsigned pos);
};

struct FIREBIRD_IConfig
{
	void* cloopDummy[1];
	struct FIREBIRD_IConfigVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IConfig_addRef(struct FIREBIRD_IConfig* self);
CLOOP_EXTERN_C int FIREBIRD_IConfig_release(struct FIREBIRD_IConfig* self);
CLOOP_EXTERN_C struct FIREBIRD_IConfigEntry* FIREBIRD_IConfig_find(struct FIREBIRD_IConfig* self, struct FIREBIRD_IStatus* status, const char* name);
CLOOP_EXTERN_C struct FIREBIRD_IConfigEntry* FIREBIRD_IConfig_findValue(struct FIREBIRD_IConfig* self, struct FIREBIRD_IStatus* status, const char* name, const char* value);
CLOOP_EXTERN_C struct FIREBIRD_IConfigEntry* FIREBIRD_IConfig_findPos(struct FIREBIRD_IConfig* self, struct FIREBIRD_IStatus* status, const char* name, unsigned pos);

#define FIREBIRD_IFirebirdConf_VERSION 4

struct FIREBIRD_IFirebirdConf;

struct FIREBIRD_IFirebirdConfVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IFirebirdConf* self);
	int (*release)(struct FIREBIRD_IFirebirdConf* self);
	unsigned (*getKey)(struct FIREBIRD_IFirebirdConf* self, const char* name);
	ISC_INT64 (*asInteger)(struct FIREBIRD_IFirebirdConf* self, unsigned key);
	const char* (*asString)(struct FIREBIRD_IFirebirdConf* self, unsigned key);
	FB_BOOLEAN (*asBoolean)(struct FIREBIRD_IFirebirdConf* self, unsigned key);
	unsigned (*getVersion)(struct FIREBIRD_IFirebirdConf* self, struct FIREBIRD_IStatus* status);
};

struct FIREBIRD_IFirebirdConf
{
	void* cloopDummy[1];
	struct FIREBIRD_IFirebirdConfVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IFirebirdConf_addRef(struct FIREBIRD_IFirebirdConf* self);
CLOOP_EXTERN_C int FIREBIRD_IFirebirdConf_release(struct FIREBIRD_IFirebirdConf* self);
CLOOP_EXTERN_C unsigned FIREBIRD_IFirebirdConf_getKey(struct FIREBIRD_IFirebirdConf* self, const char* name);
CLOOP_EXTERN_C ISC_INT64 FIREBIRD_IFirebirdConf_asInteger(struct FIREBIRD_IFirebirdConf* self, unsigned key);
CLOOP_EXTERN_C const char* FIREBIRD_IFirebirdConf_asString(struct FIREBIRD_IFirebirdConf* self, unsigned key);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_IFirebirdConf_asBoolean(struct FIREBIRD_IFirebirdConf* self, unsigned key);
CLOOP_EXTERN_C unsigned FIREBIRD_IFirebirdConf_getVersion(struct FIREBIRD_IFirebirdConf* self, struct FIREBIRD_IStatus* status);

#define FIREBIRD_IPluginConfig_VERSION 3

struct FIREBIRD_IPluginConfig;

struct FIREBIRD_IPluginConfigVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IPluginConfig* self);
	int (*release)(struct FIREBIRD_IPluginConfig* self);
	const char* (*getConfigFileName)(struct FIREBIRD_IPluginConfig* self);
	struct FIREBIRD_IConfig* (*getDefaultConfig)(struct FIREBIRD_IPluginConfig* self, struct FIREBIRD_IStatus* status);
	struct FIREBIRD_IFirebirdConf* (*getFirebirdConf)(struct FIREBIRD_IPluginConfig* self, struct FIREBIRD_IStatus* status);
	void (*setReleaseDelay)(struct FIREBIRD_IPluginConfig* self, struct FIREBIRD_IStatus* status, ISC_UINT64 microSeconds);
};

struct FIREBIRD_IPluginConfig
{
	void* cloopDummy[1];
	struct FIREBIRD_IPluginConfigVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IPluginConfig_addRef(struct FIREBIRD_IPluginConfig* self);
CLOOP_EXTERN_C int FIREBIRD_IPluginConfig_release(struct FIREBIRD_IPluginConfig* self);
CLOOP_EXTERN_C const char* FIREBIRD_IPluginConfig_getConfigFileName(struct FIREBIRD_IPluginConfig* self);
CLOOP_EXTERN_C struct FIREBIRD_IConfig* FIREBIRD_IPluginConfig_getDefaultConfig(struct FIREBIRD_IPluginConfig* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C struct FIREBIRD_IFirebirdConf* FIREBIRD_IPluginConfig_getFirebirdConf(struct FIREBIRD_IPluginConfig* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IPluginConfig_setReleaseDelay(struct FIREBIRD_IPluginConfig* self, struct FIREBIRD_IStatus* status, ISC_UINT64 microSeconds);

#define FIREBIRD_IPluginFactory_VERSION 2

struct FIREBIRD_IPluginFactory;

struct FIREBIRD_IPluginFactoryVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	struct FIREBIRD_IPluginBase* (*createPlugin)(struct FIREBIRD_IPluginFactory* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IPluginConfig* factoryParameter);
};

struct FIREBIRD_IPluginFactory
{
	void* cloopDummy[1];
	struct FIREBIRD_IPluginFactoryVTable* vtable;
};

CLOOP_EXTERN_C struct FIREBIRD_IPluginBase* FIREBIRD_IPluginFactory_createPlugin(struct FIREBIRD_IPluginFactory* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IPluginConfig* factoryParameter);

#define FIREBIRD_IPluginModule_VERSION 3

struct FIREBIRD_IPluginModule;

struct FIREBIRD_IPluginModuleVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*doClean)(struct FIREBIRD_IPluginModule* self);
	void (*threadDetach)(struct FIREBIRD_IPluginModule* self);
};

struct FIREBIRD_IPluginModule
{
	void* cloopDummy[1];
	struct FIREBIRD_IPluginModuleVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IPluginModule_doClean(struct FIREBIRD_IPluginModule* self);
CLOOP_EXTERN_C void FIREBIRD_IPluginModule_threadDetach(struct FIREBIRD_IPluginModule* self);

#define FIREBIRD_IPluginManager_VERSION 2

#define FIREBIRD_IPluginManager_TYPE_PROVIDER ((unsigned) (1))
#define FIREBIRD_IPluginManager_TYPE_FIRST_NON_LIB ((unsigned) (2))
#define FIREBIRD_IPluginManager_TYPE_AUTH_SERVER ((unsigned) (3))
#define FIREBIRD_IPluginManager_TYPE_AUTH_CLIENT ((unsigned) (4))
#define FIREBIRD_IPluginManager_TYPE_AUTH_USER_MANAGEMENT ((unsigned) (5))
#define FIREBIRD_IPluginManager_TYPE_EXTERNAL_ENGINE ((unsigned) (6))
#define FIREBIRD_IPluginManager_TYPE_TRACE ((unsigned) (7))
#define FIREBIRD_IPluginManager_TYPE_WIRE_CRYPT ((unsigned) (8))
#define FIREBIRD_IPluginManager_TYPE_DB_CRYPT ((unsigned) (9))
#define FIREBIRD_IPluginManager_TYPE_KEY_HOLDER ((unsigned) (10))
#define FIREBIRD_IPluginManager_TYPE_REPLICATOR ((unsigned) (11))
#define FIREBIRD_IPluginManager_TYPE_COUNT ((unsigned) (12))

struct FIREBIRD_IPluginManager;

struct FIREBIRD_IPluginManagerVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*registerPluginFactory)(struct FIREBIRD_IPluginManager* self, unsigned pluginType, const char* defaultName, struct FIREBIRD_IPluginFactory* factory);
	void (*registerModule)(struct FIREBIRD_IPluginManager* self, struct FIREBIRD_IPluginModule* cleanup);
	void (*unregisterModule)(struct FIREBIRD_IPluginManager* self, struct FIREBIRD_IPluginModule* cleanup);
	struct FIREBIRD_IPluginSet* (*getPlugins)(struct FIREBIRD_IPluginManager* self, struct FIREBIRD_IStatus* status, unsigned pluginType, const char* namesList, struct FIREBIRD_IFirebirdConf* firebirdConf);
	struct FIREBIRD_IConfig* (*getConfig)(struct FIREBIRD_IPluginManager* self, struct FIREBIRD_IStatus* status, const char* filename);
	void (*releasePlugin)(struct FIREBIRD_IPluginManager* self, struct FIREBIRD_IPluginBase* plugin);
};

struct FIREBIRD_IPluginManager
{
	void* cloopDummy[1];
	struct FIREBIRD_IPluginManagerVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IPluginManager_registerPluginFactory(struct FIREBIRD_IPluginManager* self, unsigned pluginType, const char* defaultName, struct FIREBIRD_IPluginFactory* factory);
CLOOP_EXTERN_C void FIREBIRD_IPluginManager_registerModule(struct FIREBIRD_IPluginManager* self, struct FIREBIRD_IPluginModule* cleanup);
CLOOP_EXTERN_C void FIREBIRD_IPluginManager_unregisterModule(struct FIREBIRD_IPluginManager* self, struct FIREBIRD_IPluginModule* cleanup);
CLOOP_EXTERN_C struct FIREBIRD_IPluginSet* FIREBIRD_IPluginManager_getPlugins(struct FIREBIRD_IPluginManager* self, struct FIREBIRD_IStatus* status, unsigned pluginType, const char* namesList, struct FIREBIRD_IFirebirdConf* firebirdConf);
CLOOP_EXTERN_C struct FIREBIRD_IConfig* FIREBIRD_IPluginManager_getConfig(struct FIREBIRD_IPluginManager* self, struct FIREBIRD_IStatus* status, const char* filename);
CLOOP_EXTERN_C void FIREBIRD_IPluginManager_releasePlugin(struct FIREBIRD_IPluginManager* self, struct FIREBIRD_IPluginBase* plugin);

#define FIREBIRD_ICryptKey_VERSION 2

struct FIREBIRD_ICryptKey;

struct FIREBIRD_ICryptKeyVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*setSymmetric)(struct FIREBIRD_ICryptKey* self, struct FIREBIRD_IStatus* status, const char* type, unsigned keyLength, const void* key);
	void (*setAsymmetric)(struct FIREBIRD_ICryptKey* self, struct FIREBIRD_IStatus* status, const char* type, unsigned encryptKeyLength, const void* encryptKey, unsigned decryptKeyLength, const void* decryptKey);
	const void* (*getEncryptKey)(struct FIREBIRD_ICryptKey* self, unsigned* length);
	const void* (*getDecryptKey)(struct FIREBIRD_ICryptKey* self, unsigned* length);
};

struct FIREBIRD_ICryptKey
{
	void* cloopDummy[1];
	struct FIREBIRD_ICryptKeyVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_ICryptKey_setSymmetric(struct FIREBIRD_ICryptKey* self, struct FIREBIRD_IStatus* status, const char* type, unsigned keyLength, const void* key);
CLOOP_EXTERN_C void FIREBIRD_ICryptKey_setAsymmetric(struct FIREBIRD_ICryptKey* self, struct FIREBIRD_IStatus* status, const char* type, unsigned encryptKeyLength, const void* encryptKey, unsigned decryptKeyLength, const void* decryptKey);
CLOOP_EXTERN_C const void* FIREBIRD_ICryptKey_getEncryptKey(struct FIREBIRD_ICryptKey* self, unsigned* length);
CLOOP_EXTERN_C const void* FIREBIRD_ICryptKey_getDecryptKey(struct FIREBIRD_ICryptKey* self, unsigned* length);

#define FIREBIRD_IConfigManager_VERSION 3

#define FIREBIRD_IConfigManager_DIR_BIN ((unsigned) (0))
#define FIREBIRD_IConfigManager_DIR_SBIN ((unsigned) (1))
#define FIREBIRD_IConfigManager_DIR_CONF ((unsigned) (2))
#define FIREBIRD_IConfigManager_DIR_LIB ((unsigned) (3))
#define FIREBIRD_IConfigManager_DIR_INC ((unsigned) (4))
#define FIREBIRD_IConfigManager_DIR_DOC ((unsigned) (5))
#define FIREBIRD_IConfigManager_DIR_UDF ((unsigned) (6))
#define FIREBIRD_IConfigManager_DIR_SAMPLE ((unsigned) (7))
#define FIREBIRD_IConfigManager_DIR_SAMPLEDB ((unsigned) (8))
#define FIREBIRD_IConfigManager_DIR_HELP ((unsigned) (9))
#define FIREBIRD_IConfigManager_DIR_INTL ((unsigned) (10))
#define FIREBIRD_IConfigManager_DIR_MISC ((unsigned) (11))
#define FIREBIRD_IConfigManager_DIR_SECDB ((unsigned) (12))
#define FIREBIRD_IConfigManager_DIR_MSG ((unsigned) (13))
#define FIREBIRD_IConfigManager_DIR_LOG ((unsigned) (14))
#define FIREBIRD_IConfigManager_DIR_GUARD ((unsigned) (15))
#define FIREBIRD_IConfigManager_DIR_PLUGINS ((unsigned) (16))
#define FIREBIRD_IConfigManager_DIR_TZDATA ((unsigned) (17))
#define FIREBIRD_IConfigManager_DIR_COUNT ((unsigned) (18))

struct FIREBIRD_IConfigManager;

struct FIREBIRD_IConfigManagerVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	const char* (*getDirectory)(struct FIREBIRD_IConfigManager* self, unsigned code);
	struct FIREBIRD_IFirebirdConf* (*getFirebirdConf)(struct FIREBIRD_IConfigManager* self);
	struct FIREBIRD_IFirebirdConf* (*getDatabaseConf)(struct FIREBIRD_IConfigManager* self, const char* dbName);
	struct FIREBIRD_IConfig* (*getPluginConfig)(struct FIREBIRD_IConfigManager* self, const char* configuredPlugin);
	const char* (*getInstallDirectory)(struct FIREBIRD_IConfigManager* self);
	const char* (*getRootDirectory)(struct FIREBIRD_IConfigManager* self);
	const char* (*getDefaultSecurityDb)(struct FIREBIRD_IConfigManager* self);
};

struct FIREBIRD_IConfigManager
{
	void* cloopDummy[1];
	struct FIREBIRD_IConfigManagerVTable* vtable;
};

CLOOP_EXTERN_C const char* FIREBIRD_IConfigManager_getDirectory(struct FIREBIRD_IConfigManager* self, unsigned code);
CLOOP_EXTERN_C struct FIREBIRD_IFirebirdConf* FIREBIRD_IConfigManager_getFirebirdConf(struct FIREBIRD_IConfigManager* self);
CLOOP_EXTERN_C struct FIREBIRD_IFirebirdConf* FIREBIRD_IConfigManager_getDatabaseConf(struct FIREBIRD_IConfigManager* self, const char* dbName);
CLOOP_EXTERN_C struct FIREBIRD_IConfig* FIREBIRD_IConfigManager_getPluginConfig(struct FIREBIRD_IConfigManager* self, const char* configuredPlugin);
CLOOP_EXTERN_C const char* FIREBIRD_IConfigManager_getInstallDirectory(struct FIREBIRD_IConfigManager* self);
CLOOP_EXTERN_C const char* FIREBIRD_IConfigManager_getRootDirectory(struct FIREBIRD_IConfigManager* self);
CLOOP_EXTERN_C const char* FIREBIRD_IConfigManager_getDefaultSecurityDb(struct FIREBIRD_IConfigManager* self);

#define FIREBIRD_IEventCallback_VERSION 3

struct FIREBIRD_IEventCallback;

struct FIREBIRD_IEventCallbackVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IEventCallback* self);
	int (*release)(struct FIREBIRD_IEventCallback* self);
	void (*eventCallbackFunction)(struct FIREBIRD_IEventCallback* self, unsigned length, const unsigned char* events);
};

struct FIREBIRD_IEventCallback
{
	void* cloopDummy[1];
	struct FIREBIRD_IEventCallbackVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IEventCallback_addRef(struct FIREBIRD_IEventCallback* self);
CLOOP_EXTERN_C int FIREBIRD_IEventCallback_release(struct FIREBIRD_IEventCallback* self);
CLOOP_EXTERN_C void FIREBIRD_IEventCallback_eventCallbackFunction(struct FIREBIRD_IEventCallback* self, unsigned length, const unsigned char* events);

#define FIREBIRD_IBlob_VERSION 4

struct FIREBIRD_IBlob;

struct FIREBIRD_IBlobVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IBlob* self);
	int (*release)(struct FIREBIRD_IBlob* self);
	void (*getInfo)(struct FIREBIRD_IBlob* self, struct FIREBIRD_IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer);
	int (*getSegment)(struct FIREBIRD_IBlob* self, struct FIREBIRD_IStatus* status, unsigned bufferLength, void* buffer, unsigned* segmentLength);
	void (*putSegment)(struct FIREBIRD_IBlob* self, struct FIREBIRD_IStatus* status, unsigned length, const void* buffer);
	void (*deprecatedCancel)(struct FIREBIRD_IBlob* self, struct FIREBIRD_IStatus* status);
	void (*deprecatedClose)(struct FIREBIRD_IBlob* self, struct FIREBIRD_IStatus* status);
	int (*seek)(struct FIREBIRD_IBlob* self, struct FIREBIRD_IStatus* status, int mode, int offset);
	void (*cancel)(struct FIREBIRD_IBlob* self, struct FIREBIRD_IStatus* status);
	void (*close)(struct FIREBIRD_IBlob* self, struct FIREBIRD_IStatus* status);
};

struct FIREBIRD_IBlob
{
	void* cloopDummy[1];
	struct FIREBIRD_IBlobVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IBlob_addRef(struct FIREBIRD_IBlob* self);
CLOOP_EXTERN_C int FIREBIRD_IBlob_release(struct FIREBIRD_IBlob* self);
CLOOP_EXTERN_C void FIREBIRD_IBlob_getInfo(struct FIREBIRD_IBlob* self, struct FIREBIRD_IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer);
CLOOP_EXTERN_C int FIREBIRD_IBlob_getSegment(struct FIREBIRD_IBlob* self, struct FIREBIRD_IStatus* status, unsigned bufferLength, void* buffer, unsigned* segmentLength);
CLOOP_EXTERN_C void FIREBIRD_IBlob_putSegment(struct FIREBIRD_IBlob* self, struct FIREBIRD_IStatus* status, unsigned length, const void* buffer);
CLOOP_EXTERN_C void FIREBIRD_IBlob_deprecatedCancel(struct FIREBIRD_IBlob* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IBlob_deprecatedClose(struct FIREBIRD_IBlob* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C int FIREBIRD_IBlob_seek(struct FIREBIRD_IBlob* self, struct FIREBIRD_IStatus* status, int mode, int offset);
CLOOP_EXTERN_C void FIREBIRD_IBlob_cancel(struct FIREBIRD_IBlob* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IBlob_close(struct FIREBIRD_IBlob* self, struct FIREBIRD_IStatus* status);

#define FIREBIRD_ITransaction_VERSION 4

struct FIREBIRD_ITransaction;

struct FIREBIRD_ITransactionVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_ITransaction* self);
	int (*release)(struct FIREBIRD_ITransaction* self);
	void (*getInfo)(struct FIREBIRD_ITransaction* self, struct FIREBIRD_IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer);
	void (*prepare)(struct FIREBIRD_ITransaction* self, struct FIREBIRD_IStatus* status, unsigned msgLength, const unsigned char* message);
	void (*deprecatedCommit)(struct FIREBIRD_ITransaction* self, struct FIREBIRD_IStatus* status);
	void (*commitRetaining)(struct FIREBIRD_ITransaction* self, struct FIREBIRD_IStatus* status);
	void (*deprecatedRollback)(struct FIREBIRD_ITransaction* self, struct FIREBIRD_IStatus* status);
	void (*rollbackRetaining)(struct FIREBIRD_ITransaction* self, struct FIREBIRD_IStatus* status);
	void (*deprecatedDisconnect)(struct FIREBIRD_ITransaction* self, struct FIREBIRD_IStatus* status);
	struct FIREBIRD_ITransaction* (*join)(struct FIREBIRD_ITransaction* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction);
	struct FIREBIRD_ITransaction* (*validate)(struct FIREBIRD_ITransaction* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IAttachment* attachment);
	struct FIREBIRD_ITransaction* (*enterDtc)(struct FIREBIRD_ITransaction* self, struct FIREBIRD_IStatus* status);
	void (*commit)(struct FIREBIRD_ITransaction* self, struct FIREBIRD_IStatus* status);
	void (*rollback)(struct FIREBIRD_ITransaction* self, struct FIREBIRD_IStatus* status);
	void (*disconnect)(struct FIREBIRD_ITransaction* self, struct FIREBIRD_IStatus* status);
};

struct FIREBIRD_ITransaction
{
	void* cloopDummy[1];
	struct FIREBIRD_ITransactionVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_ITransaction_addRef(struct FIREBIRD_ITransaction* self);
CLOOP_EXTERN_C int FIREBIRD_ITransaction_release(struct FIREBIRD_ITransaction* self);
CLOOP_EXTERN_C void FIREBIRD_ITransaction_getInfo(struct FIREBIRD_ITransaction* self, struct FIREBIRD_IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer);
CLOOP_EXTERN_C void FIREBIRD_ITransaction_prepare(struct FIREBIRD_ITransaction* self, struct FIREBIRD_IStatus* status, unsigned msgLength, const unsigned char* message);
CLOOP_EXTERN_C void FIREBIRD_ITransaction_deprecatedCommit(struct FIREBIRD_ITransaction* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_ITransaction_commitRetaining(struct FIREBIRD_ITransaction* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_ITransaction_deprecatedRollback(struct FIREBIRD_ITransaction* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_ITransaction_rollbackRetaining(struct FIREBIRD_ITransaction* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_ITransaction_deprecatedDisconnect(struct FIREBIRD_ITransaction* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C struct FIREBIRD_ITransaction* FIREBIRD_ITransaction_join(struct FIREBIRD_ITransaction* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction);
CLOOP_EXTERN_C struct FIREBIRD_ITransaction* FIREBIRD_ITransaction_validate(struct FIREBIRD_ITransaction* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IAttachment* attachment);
CLOOP_EXTERN_C struct FIREBIRD_ITransaction* FIREBIRD_ITransaction_enterDtc(struct FIREBIRD_ITransaction* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_ITransaction_commit(struct FIREBIRD_ITransaction* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_ITransaction_rollback(struct FIREBIRD_ITransaction* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_ITransaction_disconnect(struct FIREBIRD_ITransaction* self, struct FIREBIRD_IStatus* status);

#define FIREBIRD_IMessageMetadata_VERSION 4

struct FIREBIRD_IMessageMetadata;

struct FIREBIRD_IMessageMetadataVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IMessageMetadata* self);
	int (*release)(struct FIREBIRD_IMessageMetadata* self);
	unsigned (*getCount)(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status);
	const char* (*getField)(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status, unsigned index);
	const char* (*getRelation)(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status, unsigned index);
	const char* (*getOwner)(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status, unsigned index);
	const char* (*getAlias)(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status, unsigned index);
	unsigned (*getType)(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status, unsigned index);
	FB_BOOLEAN (*isNullable)(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status, unsigned index);
	int (*getSubType)(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status, unsigned index);
	unsigned (*getLength)(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status, unsigned index);
	int (*getScale)(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status, unsigned index);
	unsigned (*getCharSet)(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status, unsigned index);
	unsigned (*getOffset)(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status, unsigned index);
	unsigned (*getNullOffset)(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status, unsigned index);
	struct FIREBIRD_IMetadataBuilder* (*getBuilder)(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status);
	unsigned (*getMessageLength)(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status);
	unsigned (*getAlignment)(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status);
	unsigned (*getAlignedLength)(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status);
};

struct FIREBIRD_IMessageMetadata
{
	void* cloopDummy[1];
	struct FIREBIRD_IMessageMetadataVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IMessageMetadata_addRef(struct FIREBIRD_IMessageMetadata* self);
CLOOP_EXTERN_C int FIREBIRD_IMessageMetadata_release(struct FIREBIRD_IMessageMetadata* self);
CLOOP_EXTERN_C unsigned FIREBIRD_IMessageMetadata_getCount(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C const char* FIREBIRD_IMessageMetadata_getField(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status, unsigned index);
CLOOP_EXTERN_C const char* FIREBIRD_IMessageMetadata_getRelation(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status, unsigned index);
CLOOP_EXTERN_C const char* FIREBIRD_IMessageMetadata_getOwner(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status, unsigned index);
CLOOP_EXTERN_C const char* FIREBIRD_IMessageMetadata_getAlias(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status, unsigned index);
CLOOP_EXTERN_C unsigned FIREBIRD_IMessageMetadata_getType(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status, unsigned index);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_IMessageMetadata_isNullable(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status, unsigned index);
CLOOP_EXTERN_C int FIREBIRD_IMessageMetadata_getSubType(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status, unsigned index);
CLOOP_EXTERN_C unsigned FIREBIRD_IMessageMetadata_getLength(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status, unsigned index);
CLOOP_EXTERN_C int FIREBIRD_IMessageMetadata_getScale(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status, unsigned index);
CLOOP_EXTERN_C unsigned FIREBIRD_IMessageMetadata_getCharSet(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status, unsigned index);
CLOOP_EXTERN_C unsigned FIREBIRD_IMessageMetadata_getOffset(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status, unsigned index);
CLOOP_EXTERN_C unsigned FIREBIRD_IMessageMetadata_getNullOffset(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status, unsigned index);
CLOOP_EXTERN_C struct FIREBIRD_IMetadataBuilder* FIREBIRD_IMessageMetadata_getBuilder(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C unsigned FIREBIRD_IMessageMetadata_getMessageLength(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C unsigned FIREBIRD_IMessageMetadata_getAlignment(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C unsigned FIREBIRD_IMessageMetadata_getAlignedLength(struct FIREBIRD_IMessageMetadata* self, struct FIREBIRD_IStatus* status);

#define FIREBIRD_IMetadataBuilder_VERSION 4

struct FIREBIRD_IMetadataBuilder;

struct FIREBIRD_IMetadataBuilderVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IMetadataBuilder* self);
	int (*release)(struct FIREBIRD_IMetadataBuilder* self);
	void (*setType)(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status, unsigned index, unsigned type);
	void (*setSubType)(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status, unsigned index, int subType);
	void (*setLength)(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status, unsigned index, unsigned length);
	void (*setCharSet)(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status, unsigned index, unsigned charSet);
	void (*setScale)(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status, unsigned index, int scale);
	void (*truncate)(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status, unsigned count);
	void (*moveNameToIndex)(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status, const char* name, unsigned index);
	void (*remove)(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status, unsigned index);
	unsigned (*addField)(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status);
	struct FIREBIRD_IMessageMetadata* (*getMetadata)(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status);
	void (*setField)(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status, unsigned index, const char* field);
	void (*setRelation)(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status, unsigned index, const char* relation);
	void (*setOwner)(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status, unsigned index, const char* owner);
	void (*setAlias)(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status, unsigned index, const char* alias);
};

struct FIREBIRD_IMetadataBuilder
{
	void* cloopDummy[1];
	struct FIREBIRD_IMetadataBuilderVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IMetadataBuilder_addRef(struct FIREBIRD_IMetadataBuilder* self);
CLOOP_EXTERN_C int FIREBIRD_IMetadataBuilder_release(struct FIREBIRD_IMetadataBuilder* self);
CLOOP_EXTERN_C void FIREBIRD_IMetadataBuilder_setType(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status, unsigned index, unsigned type);
CLOOP_EXTERN_C void FIREBIRD_IMetadataBuilder_setSubType(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status, unsigned index, int subType);
CLOOP_EXTERN_C void FIREBIRD_IMetadataBuilder_setLength(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status, unsigned index, unsigned length);
CLOOP_EXTERN_C void FIREBIRD_IMetadataBuilder_setCharSet(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status, unsigned index, unsigned charSet);
CLOOP_EXTERN_C void FIREBIRD_IMetadataBuilder_setScale(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status, unsigned index, int scale);
CLOOP_EXTERN_C void FIREBIRD_IMetadataBuilder_truncate(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status, unsigned count);
CLOOP_EXTERN_C void FIREBIRD_IMetadataBuilder_moveNameToIndex(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status, const char* name, unsigned index);
CLOOP_EXTERN_C void FIREBIRD_IMetadataBuilder_remove(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status, unsigned index);
CLOOP_EXTERN_C unsigned FIREBIRD_IMetadataBuilder_addField(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C struct FIREBIRD_IMessageMetadata* FIREBIRD_IMetadataBuilder_getMetadata(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IMetadataBuilder_setField(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status, unsigned index, const char* field);
CLOOP_EXTERN_C void FIREBIRD_IMetadataBuilder_setRelation(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status, unsigned index, const char* relation);
CLOOP_EXTERN_C void FIREBIRD_IMetadataBuilder_setOwner(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status, unsigned index, const char* owner);
CLOOP_EXTERN_C void FIREBIRD_IMetadataBuilder_setAlias(struct FIREBIRD_IMetadataBuilder* self, struct FIREBIRD_IStatus* status, unsigned index, const char* alias);

#define FIREBIRD_IResultSet_VERSION 4

struct FIREBIRD_IResultSet;

struct FIREBIRD_IResultSetVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IResultSet* self);
	int (*release)(struct FIREBIRD_IResultSet* self);
	int (*fetchNext)(struct FIREBIRD_IResultSet* self, struct FIREBIRD_IStatus* status, void* message);
	int (*fetchPrior)(struct FIREBIRD_IResultSet* self, struct FIREBIRD_IStatus* status, void* message);
	int (*fetchFirst)(struct FIREBIRD_IResultSet* self, struct FIREBIRD_IStatus* status, void* message);
	int (*fetchLast)(struct FIREBIRD_IResultSet* self, struct FIREBIRD_IStatus* status, void* message);
	int (*fetchAbsolute)(struct FIREBIRD_IResultSet* self, struct FIREBIRD_IStatus* status, int position, void* message);
	int (*fetchRelative)(struct FIREBIRD_IResultSet* self, struct FIREBIRD_IStatus* status, int offset, void* message);
	FB_BOOLEAN (*isEof)(struct FIREBIRD_IResultSet* self, struct FIREBIRD_IStatus* status);
	FB_BOOLEAN (*isBof)(struct FIREBIRD_IResultSet* self, struct FIREBIRD_IStatus* status);
	struct FIREBIRD_IMessageMetadata* (*getMetadata)(struct FIREBIRD_IResultSet* self, struct FIREBIRD_IStatus* status);
	void (*deprecatedClose)(struct FIREBIRD_IResultSet* self, struct FIREBIRD_IStatus* status);
	void (*setDelayedOutputFormat)(struct FIREBIRD_IResultSet* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IMessageMetadata* format);
	void (*close)(struct FIREBIRD_IResultSet* self, struct FIREBIRD_IStatus* status);
};

struct FIREBIRD_IResultSet
{
	void* cloopDummy[1];
	struct FIREBIRD_IResultSetVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IResultSet_addRef(struct FIREBIRD_IResultSet* self);
CLOOP_EXTERN_C int FIREBIRD_IResultSet_release(struct FIREBIRD_IResultSet* self);
CLOOP_EXTERN_C int FIREBIRD_IResultSet_fetchNext(struct FIREBIRD_IResultSet* self, struct FIREBIRD_IStatus* status, void* message);
CLOOP_EXTERN_C int FIREBIRD_IResultSet_fetchPrior(struct FIREBIRD_IResultSet* self, struct FIREBIRD_IStatus* status, void* message);
CLOOP_EXTERN_C int FIREBIRD_IResultSet_fetchFirst(struct FIREBIRD_IResultSet* self, struct FIREBIRD_IStatus* status, void* message);
CLOOP_EXTERN_C int FIREBIRD_IResultSet_fetchLast(struct FIREBIRD_IResultSet* self, struct FIREBIRD_IStatus* status, void* message);
CLOOP_EXTERN_C int FIREBIRD_IResultSet_fetchAbsolute(struct FIREBIRD_IResultSet* self, struct FIREBIRD_IStatus* status, int position, void* message);
CLOOP_EXTERN_C int FIREBIRD_IResultSet_fetchRelative(struct FIREBIRD_IResultSet* self, struct FIREBIRD_IStatus* status, int offset, void* message);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_IResultSet_isEof(struct FIREBIRD_IResultSet* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_IResultSet_isBof(struct FIREBIRD_IResultSet* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C struct FIREBIRD_IMessageMetadata* FIREBIRD_IResultSet_getMetadata(struct FIREBIRD_IResultSet* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IResultSet_deprecatedClose(struct FIREBIRD_IResultSet* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IResultSet_setDelayedOutputFormat(struct FIREBIRD_IResultSet* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IMessageMetadata* format);
CLOOP_EXTERN_C void FIREBIRD_IResultSet_close(struct FIREBIRD_IResultSet* self, struct FIREBIRD_IStatus* status);

#define FIREBIRD_IStatement_VERSION 5

#define FIREBIRD_IStatement_PREPARE_PREFETCH_NONE ((unsigned) (0x0))
#define FIREBIRD_IStatement_PREPARE_PREFETCH_TYPE ((unsigned) (0x1))
#define FIREBIRD_IStatement_PREPARE_PREFETCH_INPUT_PARAMETERS ((unsigned) (0x2))
#define FIREBIRD_IStatement_PREPARE_PREFETCH_OUTPUT_PARAMETERS ((unsigned) (0x4))
#define FIREBIRD_IStatement_PREPARE_PREFETCH_LEGACY_PLAN ((unsigned) (0x8))
#define FIREBIRD_IStatement_PREPARE_PREFETCH_DETAILED_PLAN ((unsigned) (0x10))
#define FIREBIRD_IStatement_PREPARE_PREFETCH_AFFECTED_RECORDS ((unsigned) (0x20))
#define FIREBIRD_IStatement_PREPARE_PREFETCH_FLAGS ((unsigned) (0x40))
#define FIREBIRD_IStatement_PREPARE_PREFETCH_METADATA ((unsigned) (FIREBIRD_IStatement_PREPARE_PREFETCH_TYPE | FIREBIRD_IStatement_PREPARE_PREFETCH_FLAGS | FIREBIRD_IStatement_PREPARE_PREFETCH_INPUT_PARAMETERS | FIREBIRD_IStatement_PREPARE_PREFETCH_OUTPUT_PARAMETERS))
#define FIREBIRD_IStatement_PREPARE_PREFETCH_ALL ((unsigned) (FIREBIRD_IStatement_PREPARE_PREFETCH_METADATA | FIREBIRD_IStatement_PREPARE_PREFETCH_LEGACY_PLAN | FIREBIRD_IStatement_PREPARE_PREFETCH_DETAILED_PLAN | FIREBIRD_IStatement_PREPARE_PREFETCH_AFFECTED_RECORDS))
#define FIREBIRD_IStatement_FLAG_HAS_CURSOR ((unsigned) (0x1))
#define FIREBIRD_IStatement_FLAG_REPEAT_EXECUTE ((unsigned) (0x2))
#define FIREBIRD_IStatement_CURSOR_TYPE_SCROLLABLE ((unsigned) (0x1))

struct FIREBIRD_IStatement;

struct FIREBIRD_IStatementVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IStatement* self);
	int (*release)(struct FIREBIRD_IStatement* self);
	void (*getInfo)(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer);
	unsigned (*getType)(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status);
	const char* (*getPlan)(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status, FB_BOOLEAN detailed);
	ISC_UINT64 (*getAffectedRecords)(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status);
	struct FIREBIRD_IMessageMetadata* (*getInputMetadata)(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status);
	struct FIREBIRD_IMessageMetadata* (*getOutputMetadata)(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status);
	struct FIREBIRD_ITransaction* (*execute)(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction, struct FIREBIRD_IMessageMetadata* inMetadata, void* inBuffer, struct FIREBIRD_IMessageMetadata* outMetadata, void* outBuffer);
	struct FIREBIRD_IResultSet* (*openCursor)(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction, struct FIREBIRD_IMessageMetadata* inMetadata, void* inBuffer, struct FIREBIRD_IMessageMetadata* outMetadata, unsigned flags);
	void (*setCursorName)(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status, const char* name);
	void (*deprecatedFree)(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status);
	unsigned (*getFlags)(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status);
	unsigned (*getTimeout)(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status);
	void (*setTimeout)(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status, unsigned timeOut);
	struct FIREBIRD_IBatch* (*createBatch)(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IMessageMetadata* inMetadata, unsigned parLength, const unsigned char* par);
	void (*free)(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status);
};

struct FIREBIRD_IStatement
{
	void* cloopDummy[1];
	struct FIREBIRD_IStatementVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IStatement_addRef(struct FIREBIRD_IStatement* self);
CLOOP_EXTERN_C int FIREBIRD_IStatement_release(struct FIREBIRD_IStatement* self);
CLOOP_EXTERN_C void FIREBIRD_IStatement_getInfo(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer);
CLOOP_EXTERN_C unsigned FIREBIRD_IStatement_getType(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C const char* FIREBIRD_IStatement_getPlan(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status, FB_BOOLEAN detailed);
CLOOP_EXTERN_C ISC_UINT64 FIREBIRD_IStatement_getAffectedRecords(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C struct FIREBIRD_IMessageMetadata* FIREBIRD_IStatement_getInputMetadata(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C struct FIREBIRD_IMessageMetadata* FIREBIRD_IStatement_getOutputMetadata(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C struct FIREBIRD_ITransaction* FIREBIRD_IStatement_execute(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction, struct FIREBIRD_IMessageMetadata* inMetadata, void* inBuffer, struct FIREBIRD_IMessageMetadata* outMetadata, void* outBuffer);
CLOOP_EXTERN_C struct FIREBIRD_IResultSet* FIREBIRD_IStatement_openCursor(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction, struct FIREBIRD_IMessageMetadata* inMetadata, void* inBuffer, struct FIREBIRD_IMessageMetadata* outMetadata, unsigned flags);
CLOOP_EXTERN_C void FIREBIRD_IStatement_setCursorName(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status, const char* name);
CLOOP_EXTERN_C void FIREBIRD_IStatement_deprecatedFree(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C unsigned FIREBIRD_IStatement_getFlags(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C unsigned FIREBIRD_IStatement_getTimeout(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IStatement_setTimeout(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status, unsigned timeOut);
CLOOP_EXTERN_C struct FIREBIRD_IBatch* FIREBIRD_IStatement_createBatch(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IMessageMetadata* inMetadata, unsigned parLength, const unsigned char* par);
CLOOP_EXTERN_C void FIREBIRD_IStatement_free(struct FIREBIRD_IStatement* self, struct FIREBIRD_IStatus* status);

#define FIREBIRD_IBatch_VERSION 4

#define FIREBIRD_IBatch_VERSION1 ((unsigned char) (1))
#define FIREBIRD_IBatch_CURRENT_VERSION ((unsigned char) (FIREBIRD_IBatch_VERSION1))
#define FIREBIRD_IBatch_TAG_MULTIERROR ((unsigned char) (1))
#define FIREBIRD_IBatch_TAG_RECORD_COUNTS ((unsigned char) (2))
#define FIREBIRD_IBatch_TAG_BUFFER_BYTES_SIZE ((unsigned char) (3))
#define FIREBIRD_IBatch_TAG_BLOB_POLICY ((unsigned char) (4))
#define FIREBIRD_IBatch_TAG_DETAILED_ERRORS ((unsigned char) (5))
#define FIREBIRD_IBatch_INF_BUFFER_BYTES_SIZE ((unsigned char) (10))
#define FIREBIRD_IBatch_INF_DATA_BYTES_SIZE ((unsigned char) (11))
#define FIREBIRD_IBatch_INF_BLOBS_BYTES_SIZE ((unsigned char) (12))
#define FIREBIRD_IBatch_INF_BLOB_ALIGNMENT ((unsigned char) (13))
#define FIREBIRD_IBatch_INF_BLOB_HEADER ((unsigned char) (14))
#define FIREBIRD_IBatch_BLOB_NONE ((unsigned char) (0))
#define FIREBIRD_IBatch_BLOB_ID_ENGINE ((unsigned char) (1))
#define FIREBIRD_IBatch_BLOB_ID_USER ((unsigned char) (2))
#define FIREBIRD_IBatch_BLOB_STREAM ((unsigned char) (3))
#define FIREBIRD_IBatch_BLOB_SEGHDR_ALIGN ((unsigned) (2))

struct FIREBIRD_IBatch;

struct FIREBIRD_IBatchVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IBatch* self);
	int (*release)(struct FIREBIRD_IBatch* self);
	void (*add)(struct FIREBIRD_IBatch* self, struct FIREBIRD_IStatus* status, unsigned count, const void* inBuffer);
	void (*addBlob)(struct FIREBIRD_IBatch* self, struct FIREBIRD_IStatus* status, unsigned length, const void* inBuffer, ISC_QUAD* blobId, unsigned parLength, const unsigned char* par);
	void (*appendBlobData)(struct FIREBIRD_IBatch* self, struct FIREBIRD_IStatus* status, unsigned length, const void* inBuffer);
	void (*addBlobStream)(struct FIREBIRD_IBatch* self, struct FIREBIRD_IStatus* status, unsigned length, const void* inBuffer);
	void (*registerBlob)(struct FIREBIRD_IBatch* self, struct FIREBIRD_IStatus* status, const ISC_QUAD* existingBlob, ISC_QUAD* blobId);
	struct FIREBIRD_IBatchCompletionState* (*execute)(struct FIREBIRD_IBatch* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction);
	void (*cancel)(struct FIREBIRD_IBatch* self, struct FIREBIRD_IStatus* status);
	unsigned (*getBlobAlignment)(struct FIREBIRD_IBatch* self, struct FIREBIRD_IStatus* status);
	struct FIREBIRD_IMessageMetadata* (*getMetadata)(struct FIREBIRD_IBatch* self, struct FIREBIRD_IStatus* status);
	void (*setDefaultBpb)(struct FIREBIRD_IBatch* self, struct FIREBIRD_IStatus* status, unsigned parLength, const unsigned char* par);
	void (*deprecatedClose)(struct FIREBIRD_IBatch* self, struct FIREBIRD_IStatus* status);
	void (*close)(struct FIREBIRD_IBatch* self, struct FIREBIRD_IStatus* status);
	void (*getInfo)(struct FIREBIRD_IBatch* self, struct FIREBIRD_IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer);
};

struct FIREBIRD_IBatch
{
	void* cloopDummy[1];
	struct FIREBIRD_IBatchVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IBatch_addRef(struct FIREBIRD_IBatch* self);
CLOOP_EXTERN_C int FIREBIRD_IBatch_release(struct FIREBIRD_IBatch* self);
CLOOP_EXTERN_C void FIREBIRD_IBatch_add(struct FIREBIRD_IBatch* self, struct FIREBIRD_IStatus* status, unsigned count, const void* inBuffer);
CLOOP_EXTERN_C void FIREBIRD_IBatch_addBlob(struct FIREBIRD_IBatch* self, struct FIREBIRD_IStatus* status, unsigned length, const void* inBuffer, ISC_QUAD* blobId, unsigned parLength, const unsigned char* par);
CLOOP_EXTERN_C void FIREBIRD_IBatch_appendBlobData(struct FIREBIRD_IBatch* self, struct FIREBIRD_IStatus* status, unsigned length, const void* inBuffer);
CLOOP_EXTERN_C void FIREBIRD_IBatch_addBlobStream(struct FIREBIRD_IBatch* self, struct FIREBIRD_IStatus* status, unsigned length, const void* inBuffer);
CLOOP_EXTERN_C void FIREBIRD_IBatch_registerBlob(struct FIREBIRD_IBatch* self, struct FIREBIRD_IStatus* status, const ISC_QUAD* existingBlob, ISC_QUAD* blobId);
CLOOP_EXTERN_C struct FIREBIRD_IBatchCompletionState* FIREBIRD_IBatch_execute(struct FIREBIRD_IBatch* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction);
CLOOP_EXTERN_C void FIREBIRD_IBatch_cancel(struct FIREBIRD_IBatch* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C unsigned FIREBIRD_IBatch_getBlobAlignment(struct FIREBIRD_IBatch* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C struct FIREBIRD_IMessageMetadata* FIREBIRD_IBatch_getMetadata(struct FIREBIRD_IBatch* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IBatch_setDefaultBpb(struct FIREBIRD_IBatch* self, struct FIREBIRD_IStatus* status, unsigned parLength, const unsigned char* par);
CLOOP_EXTERN_C void FIREBIRD_IBatch_deprecatedClose(struct FIREBIRD_IBatch* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IBatch_close(struct FIREBIRD_IBatch* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IBatch_getInfo(struct FIREBIRD_IBatch* self, struct FIREBIRD_IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer);

#define FIREBIRD_IBatchCompletionState_VERSION 3

#define FIREBIRD_IBatchCompletionState_EXECUTE_FAILED ((int) (-1))
#define FIREBIRD_IBatchCompletionState_SUCCESS_NO_INFO ((int) (-2))
#define FIREBIRD_IBatchCompletionState_NO_MORE_ERRORS ((unsigned) (0xffffffff))

struct FIREBIRD_IBatchCompletionState;

struct FIREBIRD_IBatchCompletionStateVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*dispose)(struct FIREBIRD_IBatchCompletionState* self);
	unsigned (*getSize)(struct FIREBIRD_IBatchCompletionState* self, struct FIREBIRD_IStatus* status);
	int (*getState)(struct FIREBIRD_IBatchCompletionState* self, struct FIREBIRD_IStatus* status, unsigned pos);
	unsigned (*findError)(struct FIREBIRD_IBatchCompletionState* self, struct FIREBIRD_IStatus* status, unsigned pos);
	void (*getStatus)(struct FIREBIRD_IBatchCompletionState* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IStatus* to, unsigned pos);
};

struct FIREBIRD_IBatchCompletionState
{
	void* cloopDummy[1];
	struct FIREBIRD_IBatchCompletionStateVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IBatchCompletionState_dispose(struct FIREBIRD_IBatchCompletionState* self);
CLOOP_EXTERN_C unsigned FIREBIRD_IBatchCompletionState_getSize(struct FIREBIRD_IBatchCompletionState* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C int FIREBIRD_IBatchCompletionState_getState(struct FIREBIRD_IBatchCompletionState* self, struct FIREBIRD_IStatus* status, unsigned pos);
CLOOP_EXTERN_C unsigned FIREBIRD_IBatchCompletionState_findError(struct FIREBIRD_IBatchCompletionState* self, struct FIREBIRD_IStatus* status, unsigned pos);
CLOOP_EXTERN_C void FIREBIRD_IBatchCompletionState_getStatus(struct FIREBIRD_IBatchCompletionState* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IStatus* to, unsigned pos);

#define FIREBIRD_IReplicator_VERSION 4

struct FIREBIRD_IReplicator;

struct FIREBIRD_IReplicatorVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IReplicator* self);
	int (*release)(struct FIREBIRD_IReplicator* self);
	void (*process)(struct FIREBIRD_IReplicator* self, struct FIREBIRD_IStatus* status, unsigned length, const unsigned char* data);
	void (*deprecatedClose)(struct FIREBIRD_IReplicator* self, struct FIREBIRD_IStatus* status);
	void (*close)(struct FIREBIRD_IReplicator* self, struct FIREBIRD_IStatus* status);
};

struct FIREBIRD_IReplicator
{
	void* cloopDummy[1];
	struct FIREBIRD_IReplicatorVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IReplicator_addRef(struct FIREBIRD_IReplicator* self);
CLOOP_EXTERN_C int FIREBIRD_IReplicator_release(struct FIREBIRD_IReplicator* self);
CLOOP_EXTERN_C void FIREBIRD_IReplicator_process(struct FIREBIRD_IReplicator* self, struct FIREBIRD_IStatus* status, unsigned length, const unsigned char* data);
CLOOP_EXTERN_C void FIREBIRD_IReplicator_deprecatedClose(struct FIREBIRD_IReplicator* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IReplicator_close(struct FIREBIRD_IReplicator* self, struct FIREBIRD_IStatus* status);

#define FIREBIRD_IRequest_VERSION 4

struct FIREBIRD_IRequest;

struct FIREBIRD_IRequestVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IRequest* self);
	int (*release)(struct FIREBIRD_IRequest* self);
	void (*receive)(struct FIREBIRD_IRequest* self, struct FIREBIRD_IStatus* status, int level, unsigned msgType, unsigned length, void* message);
	void (*send)(struct FIREBIRD_IRequest* self, struct FIREBIRD_IStatus* status, int level, unsigned msgType, unsigned length, const void* message);
	void (*getInfo)(struct FIREBIRD_IRequest* self, struct FIREBIRD_IStatus* status, int level, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer);
	void (*start)(struct FIREBIRD_IRequest* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* tra, int level);
	void (*startAndSend)(struct FIREBIRD_IRequest* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* tra, int level, unsigned msgType, unsigned length, const void* message);
	void (*unwind)(struct FIREBIRD_IRequest* self, struct FIREBIRD_IStatus* status, int level);
	void (*deprecatedFree)(struct FIREBIRD_IRequest* self, struct FIREBIRD_IStatus* status);
	void (*free)(struct FIREBIRD_IRequest* self, struct FIREBIRD_IStatus* status);
};

struct FIREBIRD_IRequest
{
	void* cloopDummy[1];
	struct FIREBIRD_IRequestVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IRequest_addRef(struct FIREBIRD_IRequest* self);
CLOOP_EXTERN_C int FIREBIRD_IRequest_release(struct FIREBIRD_IRequest* self);
CLOOP_EXTERN_C void FIREBIRD_IRequest_receive(struct FIREBIRD_IRequest* self, struct FIREBIRD_IStatus* status, int level, unsigned msgType, unsigned length, void* message);
CLOOP_EXTERN_C void FIREBIRD_IRequest_send(struct FIREBIRD_IRequest* self, struct FIREBIRD_IStatus* status, int level, unsigned msgType, unsigned length, const void* message);
CLOOP_EXTERN_C void FIREBIRD_IRequest_getInfo(struct FIREBIRD_IRequest* self, struct FIREBIRD_IStatus* status, int level, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer);
CLOOP_EXTERN_C void FIREBIRD_IRequest_start(struct FIREBIRD_IRequest* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* tra, int level);
CLOOP_EXTERN_C void FIREBIRD_IRequest_startAndSend(struct FIREBIRD_IRequest* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* tra, int level, unsigned msgType, unsigned length, const void* message);
CLOOP_EXTERN_C void FIREBIRD_IRequest_unwind(struct FIREBIRD_IRequest* self, struct FIREBIRD_IStatus* status, int level);
CLOOP_EXTERN_C void FIREBIRD_IRequest_deprecatedFree(struct FIREBIRD_IRequest* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IRequest_free(struct FIREBIRD_IRequest* self, struct FIREBIRD_IStatus* status);

#define FIREBIRD_IEvents_VERSION 4

struct FIREBIRD_IEvents;

struct FIREBIRD_IEventsVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IEvents* self);
	int (*release)(struct FIREBIRD_IEvents* self);
	void (*deprecatedCancel)(struct FIREBIRD_IEvents* self, struct FIREBIRD_IStatus* status);
	void (*cancel)(struct FIREBIRD_IEvents* self, struct FIREBIRD_IStatus* status);
};

struct FIREBIRD_IEvents
{
	void* cloopDummy[1];
	struct FIREBIRD_IEventsVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IEvents_addRef(struct FIREBIRD_IEvents* self);
CLOOP_EXTERN_C int FIREBIRD_IEvents_release(struct FIREBIRD_IEvents* self);
CLOOP_EXTERN_C void FIREBIRD_IEvents_deprecatedCancel(struct FIREBIRD_IEvents* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IEvents_cancel(struct FIREBIRD_IEvents* self, struct FIREBIRD_IStatus* status);

#define FIREBIRD_IAttachment_VERSION 5

struct FIREBIRD_IAttachment;

struct FIREBIRD_IAttachmentVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IAttachment* self);
	int (*release)(struct FIREBIRD_IAttachment* self);
	void (*getInfo)(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer);
	struct FIREBIRD_ITransaction* (*startTransaction)(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, unsigned tpbLength, const unsigned char* tpb);
	struct FIREBIRD_ITransaction* (*reconnectTransaction)(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, unsigned length, const unsigned char* id);
	struct FIREBIRD_IRequest* (*compileRequest)(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, unsigned blrLength, const unsigned char* blr);
	void (*transactRequest)(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction, unsigned blrLength, const unsigned char* blr, unsigned inMsgLength, const unsigned char* inMsg, unsigned outMsgLength, unsigned char* outMsg);
	struct FIREBIRD_IBlob* (*createBlob)(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction, ISC_QUAD* id, unsigned bpbLength, const unsigned char* bpb);
	struct FIREBIRD_IBlob* (*openBlob)(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction, ISC_QUAD* id, unsigned bpbLength, const unsigned char* bpb);
	int (*getSlice)(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction, ISC_QUAD* id, unsigned sdlLength, const unsigned char* sdl, unsigned paramLength, const unsigned char* param, int sliceLength, unsigned char* slice);
	void (*putSlice)(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction, ISC_QUAD* id, unsigned sdlLength, const unsigned char* sdl, unsigned paramLength, const unsigned char* param, int sliceLength, unsigned char* slice);
	void (*executeDyn)(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction, unsigned length, const unsigned char* dyn);
	struct FIREBIRD_IStatement* (*prepare)(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* tra, unsigned stmtLength, const char* sqlStmt, unsigned dialect, unsigned flags);
	struct FIREBIRD_ITransaction* (*execute)(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction, unsigned stmtLength, const char* sqlStmt, unsigned dialect, struct FIREBIRD_IMessageMetadata* inMetadata, void* inBuffer, struct FIREBIRD_IMessageMetadata* outMetadata, void* outBuffer);
	struct FIREBIRD_IResultSet* (*openCursor)(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction, unsigned stmtLength, const char* sqlStmt, unsigned dialect, struct FIREBIRD_IMessageMetadata* inMetadata, void* inBuffer, struct FIREBIRD_IMessageMetadata* outMetadata, const char* cursorName, unsigned cursorFlags);
	struct FIREBIRD_IEvents* (*queEvents)(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IEventCallback* callback, unsigned length, const unsigned char* events);
	void (*cancelOperation)(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, int option);
	void (*ping)(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status);
	void (*deprecatedDetach)(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status);
	void (*deprecatedDropDatabase)(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status);
	unsigned (*getIdleTimeout)(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status);
	void (*setIdleTimeout)(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, unsigned timeOut);
	unsigned (*getStatementTimeout)(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status);
	void (*setStatementTimeout)(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, unsigned timeOut);
	struct FIREBIRD_IBatch* (*createBatch)(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction, unsigned stmtLength, const char* sqlStmt, unsigned dialect, struct FIREBIRD_IMessageMetadata* inMetadata, unsigned parLength, const unsigned char* par);
	struct FIREBIRD_IReplicator* (*createReplicator)(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status);
	void (*detach)(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status);
	void (*dropDatabase)(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status);
};

struct FIREBIRD_IAttachment
{
	void* cloopDummy[1];
	struct FIREBIRD_IAttachmentVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IAttachment_addRef(struct FIREBIRD_IAttachment* self);
CLOOP_EXTERN_C int FIREBIRD_IAttachment_release(struct FIREBIRD_IAttachment* self);
CLOOP_EXTERN_C void FIREBIRD_IAttachment_getInfo(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer);
CLOOP_EXTERN_C struct FIREBIRD_ITransaction* FIREBIRD_IAttachment_startTransaction(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, unsigned tpbLength, const unsigned char* tpb);
CLOOP_EXTERN_C struct FIREBIRD_ITransaction* FIREBIRD_IAttachment_reconnectTransaction(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, unsigned length, const unsigned char* id);
CLOOP_EXTERN_C struct FIREBIRD_IRequest* FIREBIRD_IAttachment_compileRequest(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, unsigned blrLength, const unsigned char* blr);
CLOOP_EXTERN_C void FIREBIRD_IAttachment_transactRequest(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction, unsigned blrLength, const unsigned char* blr, unsigned inMsgLength, const unsigned char* inMsg, unsigned outMsgLength, unsigned char* outMsg);
CLOOP_EXTERN_C struct FIREBIRD_IBlob* FIREBIRD_IAttachment_createBlob(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction, ISC_QUAD* id, unsigned bpbLength, const unsigned char* bpb);
CLOOP_EXTERN_C struct FIREBIRD_IBlob* FIREBIRD_IAttachment_openBlob(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction, ISC_QUAD* id, unsigned bpbLength, const unsigned char* bpb);
CLOOP_EXTERN_C int FIREBIRD_IAttachment_getSlice(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction, ISC_QUAD* id, unsigned sdlLength, const unsigned char* sdl, unsigned paramLength, const unsigned char* param, int sliceLength, unsigned char* slice);
CLOOP_EXTERN_C void FIREBIRD_IAttachment_putSlice(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction, ISC_QUAD* id, unsigned sdlLength, const unsigned char* sdl, unsigned paramLength, const unsigned char* param, int sliceLength, unsigned char* slice);
CLOOP_EXTERN_C void FIREBIRD_IAttachment_executeDyn(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction, unsigned length, const unsigned char* dyn);
CLOOP_EXTERN_C struct FIREBIRD_IStatement* FIREBIRD_IAttachment_prepare(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* tra, unsigned stmtLength, const char* sqlStmt, unsigned dialect, unsigned flags);
CLOOP_EXTERN_C struct FIREBIRD_ITransaction* FIREBIRD_IAttachment_execute(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction, unsigned stmtLength, const char* sqlStmt, unsigned dialect, struct FIREBIRD_IMessageMetadata* inMetadata, void* inBuffer, struct FIREBIRD_IMessageMetadata* outMetadata, void* outBuffer);
CLOOP_EXTERN_C struct FIREBIRD_IResultSet* FIREBIRD_IAttachment_openCursor(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction, unsigned stmtLength, const char* sqlStmt, unsigned dialect, struct FIREBIRD_IMessageMetadata* inMetadata, void* inBuffer, struct FIREBIRD_IMessageMetadata* outMetadata, const char* cursorName, unsigned cursorFlags);
CLOOP_EXTERN_C struct FIREBIRD_IEvents* FIREBIRD_IAttachment_queEvents(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IEventCallback* callback, unsigned length, const unsigned char* events);
CLOOP_EXTERN_C void FIREBIRD_IAttachment_cancelOperation(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, int option);
CLOOP_EXTERN_C void FIREBIRD_IAttachment_ping(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IAttachment_deprecatedDetach(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IAttachment_deprecatedDropDatabase(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C unsigned FIREBIRD_IAttachment_getIdleTimeout(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IAttachment_setIdleTimeout(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, unsigned timeOut);
CLOOP_EXTERN_C unsigned FIREBIRD_IAttachment_getStatementTimeout(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IAttachment_setStatementTimeout(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, unsigned timeOut);
CLOOP_EXTERN_C struct FIREBIRD_IBatch* FIREBIRD_IAttachment_createBatch(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction, unsigned stmtLength, const char* sqlStmt, unsigned dialect, struct FIREBIRD_IMessageMetadata* inMetadata, unsigned parLength, const unsigned char* par);
CLOOP_EXTERN_C struct FIREBIRD_IReplicator* FIREBIRD_IAttachment_createReplicator(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IAttachment_detach(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IAttachment_dropDatabase(struct FIREBIRD_IAttachment* self, struct FIREBIRD_IStatus* status);

#define FIREBIRD_IService_VERSION 4

struct FIREBIRD_IService;

struct FIREBIRD_IServiceVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IService* self);
	int (*release)(struct FIREBIRD_IService* self);
	void (*deprecatedDetach)(struct FIREBIRD_IService* self, struct FIREBIRD_IStatus* status);
	void (*query)(struct FIREBIRD_IService* self, struct FIREBIRD_IStatus* status, unsigned sendLength, const unsigned char* sendItems, unsigned receiveLength, const unsigned char* receiveItems, unsigned bufferLength, unsigned char* buffer);
	void (*start)(struct FIREBIRD_IService* self, struct FIREBIRD_IStatus* status, unsigned spbLength, const unsigned char* spb);
	void (*detach)(struct FIREBIRD_IService* self, struct FIREBIRD_IStatus* status);
};

struct FIREBIRD_IService
{
	void* cloopDummy[1];
	struct FIREBIRD_IServiceVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IService_addRef(struct FIREBIRD_IService* self);
CLOOP_EXTERN_C int FIREBIRD_IService_release(struct FIREBIRD_IService* self);
CLOOP_EXTERN_C void FIREBIRD_IService_deprecatedDetach(struct FIREBIRD_IService* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IService_query(struct FIREBIRD_IService* self, struct FIREBIRD_IStatus* status, unsigned sendLength, const unsigned char* sendItems, unsigned receiveLength, const unsigned char* receiveItems, unsigned bufferLength, unsigned char* buffer);
CLOOP_EXTERN_C void FIREBIRD_IService_start(struct FIREBIRD_IService* self, struct FIREBIRD_IStatus* status, unsigned spbLength, const unsigned char* spb);
CLOOP_EXTERN_C void FIREBIRD_IService_detach(struct FIREBIRD_IService* self, struct FIREBIRD_IStatus* status);

#define FIREBIRD_IProvider_VERSION 4

struct FIREBIRD_IProvider;

struct FIREBIRD_IProviderVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IProvider* self);
	int (*release)(struct FIREBIRD_IProvider* self);
	void (*setOwner)(struct FIREBIRD_IProvider* self, struct FIREBIRD_IReferenceCounted* r);
	struct FIREBIRD_IReferenceCounted* (*getOwner)(struct FIREBIRD_IProvider* self);
	struct FIREBIRD_IAttachment* (*attachDatabase)(struct FIREBIRD_IProvider* self, struct FIREBIRD_IStatus* status, const char* fileName, unsigned dpbLength, const unsigned char* dpb);
	struct FIREBIRD_IAttachment* (*createDatabase)(struct FIREBIRD_IProvider* self, struct FIREBIRD_IStatus* status, const char* fileName, unsigned dpbLength, const unsigned char* dpb);
	struct FIREBIRD_IService* (*attachServiceManager)(struct FIREBIRD_IProvider* self, struct FIREBIRD_IStatus* status, const char* service, unsigned spbLength, const unsigned char* spb);
	void (*shutdown)(struct FIREBIRD_IProvider* self, struct FIREBIRD_IStatus* status, unsigned timeout, const int reason);
	void (*setDbCryptCallback)(struct FIREBIRD_IProvider* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ICryptKeyCallback* cryptCallback);
};

struct FIREBIRD_IProvider
{
	void* cloopDummy[1];
	struct FIREBIRD_IProviderVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IProvider_addRef(struct FIREBIRD_IProvider* self);
CLOOP_EXTERN_C int FIREBIRD_IProvider_release(struct FIREBIRD_IProvider* self);
CLOOP_EXTERN_C void FIREBIRD_IProvider_setOwner(struct FIREBIRD_IProvider* self, struct FIREBIRD_IReferenceCounted* r);
CLOOP_EXTERN_C struct FIREBIRD_IReferenceCounted* FIREBIRD_IProvider_getOwner(struct FIREBIRD_IProvider* self);
CLOOP_EXTERN_C struct FIREBIRD_IAttachment* FIREBIRD_IProvider_attachDatabase(struct FIREBIRD_IProvider* self, struct FIREBIRD_IStatus* status, const char* fileName, unsigned dpbLength, const unsigned char* dpb);
CLOOP_EXTERN_C struct FIREBIRD_IAttachment* FIREBIRD_IProvider_createDatabase(struct FIREBIRD_IProvider* self, struct FIREBIRD_IStatus* status, const char* fileName, unsigned dpbLength, const unsigned char* dpb);
CLOOP_EXTERN_C struct FIREBIRD_IService* FIREBIRD_IProvider_attachServiceManager(struct FIREBIRD_IProvider* self, struct FIREBIRD_IStatus* status, const char* service, unsigned spbLength, const unsigned char* spb);
CLOOP_EXTERN_C void FIREBIRD_IProvider_shutdown(struct FIREBIRD_IProvider* self, struct FIREBIRD_IStatus* status, unsigned timeout, const int reason);
CLOOP_EXTERN_C void FIREBIRD_IProvider_setDbCryptCallback(struct FIREBIRD_IProvider* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ICryptKeyCallback* cryptCallback);

#define FIREBIRD_IDtcStart_VERSION 3

struct FIREBIRD_IDtcStart;

struct FIREBIRD_IDtcStartVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*dispose)(struct FIREBIRD_IDtcStart* self);
	void (*addAttachment)(struct FIREBIRD_IDtcStart* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IAttachment* att);
	void (*addWithTpb)(struct FIREBIRD_IDtcStart* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IAttachment* att, unsigned length, const unsigned char* tpb);
	struct FIREBIRD_ITransaction* (*start)(struct FIREBIRD_IDtcStart* self, struct FIREBIRD_IStatus* status);
};

struct FIREBIRD_IDtcStart
{
	void* cloopDummy[1];
	struct FIREBIRD_IDtcStartVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IDtcStart_dispose(struct FIREBIRD_IDtcStart* self);
CLOOP_EXTERN_C void FIREBIRD_IDtcStart_addAttachment(struct FIREBIRD_IDtcStart* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IAttachment* att);
CLOOP_EXTERN_C void FIREBIRD_IDtcStart_addWithTpb(struct FIREBIRD_IDtcStart* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IAttachment* att, unsigned length, const unsigned char* tpb);
CLOOP_EXTERN_C struct FIREBIRD_ITransaction* FIREBIRD_IDtcStart_start(struct FIREBIRD_IDtcStart* self, struct FIREBIRD_IStatus* status);

#define FIREBIRD_IDtc_VERSION 2

struct FIREBIRD_IDtc;

struct FIREBIRD_IDtcVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	struct FIREBIRD_ITransaction* (*join)(struct FIREBIRD_IDtc* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* one, struct FIREBIRD_ITransaction* two);
	struct FIREBIRD_IDtcStart* (*startBuilder)(struct FIREBIRD_IDtc* self, struct FIREBIRD_IStatus* status);
};

struct FIREBIRD_IDtc
{
	void* cloopDummy[1];
	struct FIREBIRD_IDtcVTable* vtable;
};

CLOOP_EXTERN_C struct FIREBIRD_ITransaction* FIREBIRD_IDtc_join(struct FIREBIRD_IDtc* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* one, struct FIREBIRD_ITransaction* two);
CLOOP_EXTERN_C struct FIREBIRD_IDtcStart* FIREBIRD_IDtc_startBuilder(struct FIREBIRD_IDtc* self, struct FIREBIRD_IStatus* status);

#define FIREBIRD_IAuth_VERSION 4

#define FIREBIRD_IAuth_AUTH_FAILED ((int) (-1))
#define FIREBIRD_IAuth_AUTH_SUCCESS ((int) (0))
#define FIREBIRD_IAuth_AUTH_MORE_DATA ((int) (1))
#define FIREBIRD_IAuth_AUTH_CONTINUE ((int) (2))

struct FIREBIRD_IAuth;

struct FIREBIRD_IAuthVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IAuth* self);
	int (*release)(struct FIREBIRD_IAuth* self);
	void (*setOwner)(struct FIREBIRD_IAuth* self, struct FIREBIRD_IReferenceCounted* r);
	struct FIREBIRD_IReferenceCounted* (*getOwner)(struct FIREBIRD_IAuth* self);
};

struct FIREBIRD_IAuth
{
	void* cloopDummy[1];
	struct FIREBIRD_IAuthVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IAuth_addRef(struct FIREBIRD_IAuth* self);
CLOOP_EXTERN_C int FIREBIRD_IAuth_release(struct FIREBIRD_IAuth* self);
CLOOP_EXTERN_C void FIREBIRD_IAuth_setOwner(struct FIREBIRD_IAuth* self, struct FIREBIRD_IReferenceCounted* r);
CLOOP_EXTERN_C struct FIREBIRD_IReferenceCounted* FIREBIRD_IAuth_getOwner(struct FIREBIRD_IAuth* self);

#define FIREBIRD_IWriter_VERSION 2

struct FIREBIRD_IWriter;

struct FIREBIRD_IWriterVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*reset)(struct FIREBIRD_IWriter* self);
	void (*add)(struct FIREBIRD_IWriter* self, struct FIREBIRD_IStatus* status, const char* name);
	void (*setType)(struct FIREBIRD_IWriter* self, struct FIREBIRD_IStatus* status, const char* value);
	void (*setDb)(struct FIREBIRD_IWriter* self, struct FIREBIRD_IStatus* status, const char* value);
};

struct FIREBIRD_IWriter
{
	void* cloopDummy[1];
	struct FIREBIRD_IWriterVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IWriter_reset(struct FIREBIRD_IWriter* self);
CLOOP_EXTERN_C void FIREBIRD_IWriter_add(struct FIREBIRD_IWriter* self, struct FIREBIRD_IStatus* status, const char* name);
CLOOP_EXTERN_C void FIREBIRD_IWriter_setType(struct FIREBIRD_IWriter* self, struct FIREBIRD_IStatus* status, const char* value);
CLOOP_EXTERN_C void FIREBIRD_IWriter_setDb(struct FIREBIRD_IWriter* self, struct FIREBIRD_IStatus* status, const char* value);

#define FIREBIRD_IServerBlock_VERSION 2

struct FIREBIRD_IServerBlock;

struct FIREBIRD_IServerBlockVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	const char* (*getLogin)(struct FIREBIRD_IServerBlock* self);
	const unsigned char* (*getData)(struct FIREBIRD_IServerBlock* self, unsigned* length);
	void (*putData)(struct FIREBIRD_IServerBlock* self, struct FIREBIRD_IStatus* status, unsigned length, const void* data);
	struct FIREBIRD_ICryptKey* (*newKey)(struct FIREBIRD_IServerBlock* self, struct FIREBIRD_IStatus* status);
};

struct FIREBIRD_IServerBlock
{
	void* cloopDummy[1];
	struct FIREBIRD_IServerBlockVTable* vtable;
};

CLOOP_EXTERN_C const char* FIREBIRD_IServerBlock_getLogin(struct FIREBIRD_IServerBlock* self);
CLOOP_EXTERN_C const unsigned char* FIREBIRD_IServerBlock_getData(struct FIREBIRD_IServerBlock* self, unsigned* length);
CLOOP_EXTERN_C void FIREBIRD_IServerBlock_putData(struct FIREBIRD_IServerBlock* self, struct FIREBIRD_IStatus* status, unsigned length, const void* data);
CLOOP_EXTERN_C struct FIREBIRD_ICryptKey* FIREBIRD_IServerBlock_newKey(struct FIREBIRD_IServerBlock* self, struct FIREBIRD_IStatus* status);

#define FIREBIRD_IClientBlock_VERSION 4

struct FIREBIRD_IClientBlock;

struct FIREBIRD_IClientBlockVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IClientBlock* self);
	int (*release)(struct FIREBIRD_IClientBlock* self);
	const char* (*getLogin)(struct FIREBIRD_IClientBlock* self);
	const char* (*getPassword)(struct FIREBIRD_IClientBlock* self);
	const unsigned char* (*getData)(struct FIREBIRD_IClientBlock* self, unsigned* length);
	void (*putData)(struct FIREBIRD_IClientBlock* self, struct FIREBIRD_IStatus* status, unsigned length, const void* data);
	struct FIREBIRD_ICryptKey* (*newKey)(struct FIREBIRD_IClientBlock* self, struct FIREBIRD_IStatus* status);
	struct FIREBIRD_IAuthBlock* (*getAuthBlock)(struct FIREBIRD_IClientBlock* self, struct FIREBIRD_IStatus* status);
};

struct FIREBIRD_IClientBlock
{
	void* cloopDummy[1];
	struct FIREBIRD_IClientBlockVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IClientBlock_addRef(struct FIREBIRD_IClientBlock* self);
CLOOP_EXTERN_C int FIREBIRD_IClientBlock_release(struct FIREBIRD_IClientBlock* self);
CLOOP_EXTERN_C const char* FIREBIRD_IClientBlock_getLogin(struct FIREBIRD_IClientBlock* self);
CLOOP_EXTERN_C const char* FIREBIRD_IClientBlock_getPassword(struct FIREBIRD_IClientBlock* self);
CLOOP_EXTERN_C const unsigned char* FIREBIRD_IClientBlock_getData(struct FIREBIRD_IClientBlock* self, unsigned* length);
CLOOP_EXTERN_C void FIREBIRD_IClientBlock_putData(struct FIREBIRD_IClientBlock* self, struct FIREBIRD_IStatus* status, unsigned length, const void* data);
CLOOP_EXTERN_C struct FIREBIRD_ICryptKey* FIREBIRD_IClientBlock_newKey(struct FIREBIRD_IClientBlock* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C struct FIREBIRD_IAuthBlock* FIREBIRD_IClientBlock_getAuthBlock(struct FIREBIRD_IClientBlock* self, struct FIREBIRD_IStatus* status);

#define FIREBIRD_IServer_VERSION 6

struct FIREBIRD_IServer;

struct FIREBIRD_IServerVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IServer* self);
	int (*release)(struct FIREBIRD_IServer* self);
	void (*setOwner)(struct FIREBIRD_IServer* self, struct FIREBIRD_IReferenceCounted* r);
	struct FIREBIRD_IReferenceCounted* (*getOwner)(struct FIREBIRD_IServer* self);
	int (*authenticate)(struct FIREBIRD_IServer* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IServerBlock* sBlock, struct FIREBIRD_IWriter* writerInterface);
	void (*setDbCryptCallback)(struct FIREBIRD_IServer* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ICryptKeyCallback* cryptCallback);
};

struct FIREBIRD_IServer
{
	void* cloopDummy[1];
	struct FIREBIRD_IServerVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IServer_addRef(struct FIREBIRD_IServer* self);
CLOOP_EXTERN_C int FIREBIRD_IServer_release(struct FIREBIRD_IServer* self);
CLOOP_EXTERN_C void FIREBIRD_IServer_setOwner(struct FIREBIRD_IServer* self, struct FIREBIRD_IReferenceCounted* r);
CLOOP_EXTERN_C struct FIREBIRD_IReferenceCounted* FIREBIRD_IServer_getOwner(struct FIREBIRD_IServer* self);
CLOOP_EXTERN_C int FIREBIRD_IServer_authenticate(struct FIREBIRD_IServer* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IServerBlock* sBlock, struct FIREBIRD_IWriter* writerInterface);
CLOOP_EXTERN_C void FIREBIRD_IServer_setDbCryptCallback(struct FIREBIRD_IServer* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ICryptKeyCallback* cryptCallback);

#define FIREBIRD_IClient_VERSION 5

struct FIREBIRD_IClient;

struct FIREBIRD_IClientVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IClient* self);
	int (*release)(struct FIREBIRD_IClient* self);
	void (*setOwner)(struct FIREBIRD_IClient* self, struct FIREBIRD_IReferenceCounted* r);
	struct FIREBIRD_IReferenceCounted* (*getOwner)(struct FIREBIRD_IClient* self);
	int (*authenticate)(struct FIREBIRD_IClient* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IClientBlock* cBlock);
};

struct FIREBIRD_IClient
{
	void* cloopDummy[1];
	struct FIREBIRD_IClientVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IClient_addRef(struct FIREBIRD_IClient* self);
CLOOP_EXTERN_C int FIREBIRD_IClient_release(struct FIREBIRD_IClient* self);
CLOOP_EXTERN_C void FIREBIRD_IClient_setOwner(struct FIREBIRD_IClient* self, struct FIREBIRD_IReferenceCounted* r);
CLOOP_EXTERN_C struct FIREBIRD_IReferenceCounted* FIREBIRD_IClient_getOwner(struct FIREBIRD_IClient* self);
CLOOP_EXTERN_C int FIREBIRD_IClient_authenticate(struct FIREBIRD_IClient* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IClientBlock* cBlock);

#define FIREBIRD_IUserField_VERSION 2

struct FIREBIRD_IUserField;

struct FIREBIRD_IUserFieldVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	int (*entered)(struct FIREBIRD_IUserField* self);
	int (*specified)(struct FIREBIRD_IUserField* self);
	void (*setEntered)(struct FIREBIRD_IUserField* self, struct FIREBIRD_IStatus* status, int newValue);
};

struct FIREBIRD_IUserField
{
	void* cloopDummy[1];
	struct FIREBIRD_IUserFieldVTable* vtable;
};

CLOOP_EXTERN_C int FIREBIRD_IUserField_entered(struct FIREBIRD_IUserField* self);
CLOOP_EXTERN_C int FIREBIRD_IUserField_specified(struct FIREBIRD_IUserField* self);
CLOOP_EXTERN_C void FIREBIRD_IUserField_setEntered(struct FIREBIRD_IUserField* self, struct FIREBIRD_IStatus* status, int newValue);

#define FIREBIRD_ICharUserField_VERSION 3

struct FIREBIRD_ICharUserField;

struct FIREBIRD_ICharUserFieldVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	int (*entered)(struct FIREBIRD_ICharUserField* self);
	int (*specified)(struct FIREBIRD_ICharUserField* self);
	void (*setEntered)(struct FIREBIRD_ICharUserField* self, struct FIREBIRD_IStatus* status, int newValue);
	const char* (*get)(struct FIREBIRD_ICharUserField* self);
	void (*set)(struct FIREBIRD_ICharUserField* self, struct FIREBIRD_IStatus* status, const char* newValue);
};

struct FIREBIRD_ICharUserField
{
	void* cloopDummy[1];
	struct FIREBIRD_ICharUserFieldVTable* vtable;
};

CLOOP_EXTERN_C int FIREBIRD_ICharUserField_entered(struct FIREBIRD_ICharUserField* self);
CLOOP_EXTERN_C int FIREBIRD_ICharUserField_specified(struct FIREBIRD_ICharUserField* self);
CLOOP_EXTERN_C void FIREBIRD_ICharUserField_setEntered(struct FIREBIRD_ICharUserField* self, struct FIREBIRD_IStatus* status, int newValue);
CLOOP_EXTERN_C const char* FIREBIRD_ICharUserField_get(struct FIREBIRD_ICharUserField* self);
CLOOP_EXTERN_C void FIREBIRD_ICharUserField_set(struct FIREBIRD_ICharUserField* self, struct FIREBIRD_IStatus* status, const char* newValue);

#define FIREBIRD_IIntUserField_VERSION 3

struct FIREBIRD_IIntUserField;

struct FIREBIRD_IIntUserFieldVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	int (*entered)(struct FIREBIRD_IIntUserField* self);
	int (*specified)(struct FIREBIRD_IIntUserField* self);
	void (*setEntered)(struct FIREBIRD_IIntUserField* self, struct FIREBIRD_IStatus* status, int newValue);
	int (*get)(struct FIREBIRD_IIntUserField* self);
	void (*set)(struct FIREBIRD_IIntUserField* self, struct FIREBIRD_IStatus* status, int newValue);
};

struct FIREBIRD_IIntUserField
{
	void* cloopDummy[1];
	struct FIREBIRD_IIntUserFieldVTable* vtable;
};

CLOOP_EXTERN_C int FIREBIRD_IIntUserField_entered(struct FIREBIRD_IIntUserField* self);
CLOOP_EXTERN_C int FIREBIRD_IIntUserField_specified(struct FIREBIRD_IIntUserField* self);
CLOOP_EXTERN_C void FIREBIRD_IIntUserField_setEntered(struct FIREBIRD_IIntUserField* self, struct FIREBIRD_IStatus* status, int newValue);
CLOOP_EXTERN_C int FIREBIRD_IIntUserField_get(struct FIREBIRD_IIntUserField* self);
CLOOP_EXTERN_C void FIREBIRD_IIntUserField_set(struct FIREBIRD_IIntUserField* self, struct FIREBIRD_IStatus* status, int newValue);

#define FIREBIRD_IUser_VERSION 2

#define FIREBIRD_IUser_OP_USER_ADD ((unsigned) (1))
#define FIREBIRD_IUser_OP_USER_MODIFY ((unsigned) (2))
#define FIREBIRD_IUser_OP_USER_DELETE ((unsigned) (3))
#define FIREBIRD_IUser_OP_USER_DISPLAY ((unsigned) (4))
#define FIREBIRD_IUser_OP_USER_SET_MAP ((unsigned) (5))
#define FIREBIRD_IUser_OP_USER_DROP_MAP ((unsigned) (6))

struct FIREBIRD_IUser;

struct FIREBIRD_IUserVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	unsigned (*operation)(struct FIREBIRD_IUser* self);
	struct FIREBIRD_ICharUserField* (*userName)(struct FIREBIRD_IUser* self);
	struct FIREBIRD_ICharUserField* (*password)(struct FIREBIRD_IUser* self);
	struct FIREBIRD_ICharUserField* (*firstName)(struct FIREBIRD_IUser* self);
	struct FIREBIRD_ICharUserField* (*lastName)(struct FIREBIRD_IUser* self);
	struct FIREBIRD_ICharUserField* (*middleName)(struct FIREBIRD_IUser* self);
	struct FIREBIRD_ICharUserField* (*comment)(struct FIREBIRD_IUser* self);
	struct FIREBIRD_ICharUserField* (*attributes)(struct FIREBIRD_IUser* self);
	struct FIREBIRD_IIntUserField* (*active)(struct FIREBIRD_IUser* self);
	struct FIREBIRD_IIntUserField* (*admin)(struct FIREBIRD_IUser* self);
	void (*clear)(struct FIREBIRD_IUser* self, struct FIREBIRD_IStatus* status);
};

struct FIREBIRD_IUser
{
	void* cloopDummy[1];
	struct FIREBIRD_IUserVTable* vtable;
};

CLOOP_EXTERN_C unsigned FIREBIRD_IUser_operation(struct FIREBIRD_IUser* self);
CLOOP_EXTERN_C struct FIREBIRD_ICharUserField* FIREBIRD_IUser_userName(struct FIREBIRD_IUser* self);
CLOOP_EXTERN_C struct FIREBIRD_ICharUserField* FIREBIRD_IUser_password(struct FIREBIRD_IUser* self);
CLOOP_EXTERN_C struct FIREBIRD_ICharUserField* FIREBIRD_IUser_firstName(struct FIREBIRD_IUser* self);
CLOOP_EXTERN_C struct FIREBIRD_ICharUserField* FIREBIRD_IUser_lastName(struct FIREBIRD_IUser* self);
CLOOP_EXTERN_C struct FIREBIRD_ICharUserField* FIREBIRD_IUser_middleName(struct FIREBIRD_IUser* self);
CLOOP_EXTERN_C struct FIREBIRD_ICharUserField* FIREBIRD_IUser_comment(struct FIREBIRD_IUser* self);
CLOOP_EXTERN_C struct FIREBIRD_ICharUserField* FIREBIRD_IUser_attributes(struct FIREBIRD_IUser* self);
CLOOP_EXTERN_C struct FIREBIRD_IIntUserField* FIREBIRD_IUser_active(struct FIREBIRD_IUser* self);
CLOOP_EXTERN_C struct FIREBIRD_IIntUserField* FIREBIRD_IUser_admin(struct FIREBIRD_IUser* self);
CLOOP_EXTERN_C void FIREBIRD_IUser_clear(struct FIREBIRD_IUser* self, struct FIREBIRD_IStatus* status);

#define FIREBIRD_IListUsers_VERSION 2

struct FIREBIRD_IListUsers;

struct FIREBIRD_IListUsersVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*list)(struct FIREBIRD_IListUsers* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IUser* user);
};

struct FIREBIRD_IListUsers
{
	void* cloopDummy[1];
	struct FIREBIRD_IListUsersVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IListUsers_list(struct FIREBIRD_IListUsers* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IUser* user);

#define FIREBIRD_ILogonInfo_VERSION 3

struct FIREBIRD_ILogonInfo;

struct FIREBIRD_ILogonInfoVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	const char* (*name)(struct FIREBIRD_ILogonInfo* self);
	const char* (*role)(struct FIREBIRD_ILogonInfo* self);
	const char* (*networkProtocol)(struct FIREBIRD_ILogonInfo* self);
	const char* (*remoteAddress)(struct FIREBIRD_ILogonInfo* self);
	const unsigned char* (*authBlock)(struct FIREBIRD_ILogonInfo* self, unsigned* length);
	struct FIREBIRD_IAttachment* (*attachment)(struct FIREBIRD_ILogonInfo* self, struct FIREBIRD_IStatus* status);
	struct FIREBIRD_ITransaction* (*transaction)(struct FIREBIRD_ILogonInfo* self, struct FIREBIRD_IStatus* status);
};

struct FIREBIRD_ILogonInfo
{
	void* cloopDummy[1];
	struct FIREBIRD_ILogonInfoVTable* vtable;
};

CLOOP_EXTERN_C const char* FIREBIRD_ILogonInfo_name(struct FIREBIRD_ILogonInfo* self);
CLOOP_EXTERN_C const char* FIREBIRD_ILogonInfo_role(struct FIREBIRD_ILogonInfo* self);
CLOOP_EXTERN_C const char* FIREBIRD_ILogonInfo_networkProtocol(struct FIREBIRD_ILogonInfo* self);
CLOOP_EXTERN_C const char* FIREBIRD_ILogonInfo_remoteAddress(struct FIREBIRD_ILogonInfo* self);
CLOOP_EXTERN_C const unsigned char* FIREBIRD_ILogonInfo_authBlock(struct FIREBIRD_ILogonInfo* self, unsigned* length);
CLOOP_EXTERN_C struct FIREBIRD_IAttachment* FIREBIRD_ILogonInfo_attachment(struct FIREBIRD_ILogonInfo* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C struct FIREBIRD_ITransaction* FIREBIRD_ILogonInfo_transaction(struct FIREBIRD_ILogonInfo* self, struct FIREBIRD_IStatus* status);

#define FIREBIRD_IManagement_VERSION 4

struct FIREBIRD_IManagement;

struct FIREBIRD_IManagementVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IManagement* self);
	int (*release)(struct FIREBIRD_IManagement* self);
	void (*setOwner)(struct FIREBIRD_IManagement* self, struct FIREBIRD_IReferenceCounted* r);
	struct FIREBIRD_IReferenceCounted* (*getOwner)(struct FIREBIRD_IManagement* self);
	void (*start)(struct FIREBIRD_IManagement* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ILogonInfo* logonInfo);
	int (*execute)(struct FIREBIRD_IManagement* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IUser* user, struct FIREBIRD_IListUsers* callback);
	void (*commit)(struct FIREBIRD_IManagement* self, struct FIREBIRD_IStatus* status);
	void (*rollback)(struct FIREBIRD_IManagement* self, struct FIREBIRD_IStatus* status);
};

struct FIREBIRD_IManagement
{
	void* cloopDummy[1];
	struct FIREBIRD_IManagementVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IManagement_addRef(struct FIREBIRD_IManagement* self);
CLOOP_EXTERN_C int FIREBIRD_IManagement_release(struct FIREBIRD_IManagement* self);
CLOOP_EXTERN_C void FIREBIRD_IManagement_setOwner(struct FIREBIRD_IManagement* self, struct FIREBIRD_IReferenceCounted* r);
CLOOP_EXTERN_C struct FIREBIRD_IReferenceCounted* FIREBIRD_IManagement_getOwner(struct FIREBIRD_IManagement* self);
CLOOP_EXTERN_C void FIREBIRD_IManagement_start(struct FIREBIRD_IManagement* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ILogonInfo* logonInfo);
CLOOP_EXTERN_C int FIREBIRD_IManagement_execute(struct FIREBIRD_IManagement* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IUser* user, struct FIREBIRD_IListUsers* callback);
CLOOP_EXTERN_C void FIREBIRD_IManagement_commit(struct FIREBIRD_IManagement* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IManagement_rollback(struct FIREBIRD_IManagement* self, struct FIREBIRD_IStatus* status);

#define FIREBIRD_IAuthBlock_VERSION 2

struct FIREBIRD_IAuthBlock;

struct FIREBIRD_IAuthBlockVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	const char* (*getType)(struct FIREBIRD_IAuthBlock* self);
	const char* (*getName)(struct FIREBIRD_IAuthBlock* self);
	const char* (*getPlugin)(struct FIREBIRD_IAuthBlock* self);
	const char* (*getSecurityDb)(struct FIREBIRD_IAuthBlock* self);
	const char* (*getOriginalPlugin)(struct FIREBIRD_IAuthBlock* self);
	FB_BOOLEAN (*next)(struct FIREBIRD_IAuthBlock* self, struct FIREBIRD_IStatus* status);
	FB_BOOLEAN (*first)(struct FIREBIRD_IAuthBlock* self, struct FIREBIRD_IStatus* status);
};

struct FIREBIRD_IAuthBlock
{
	void* cloopDummy[1];
	struct FIREBIRD_IAuthBlockVTable* vtable;
};

CLOOP_EXTERN_C const char* FIREBIRD_IAuthBlock_getType(struct FIREBIRD_IAuthBlock* self);
CLOOP_EXTERN_C const char* FIREBIRD_IAuthBlock_getName(struct FIREBIRD_IAuthBlock* self);
CLOOP_EXTERN_C const char* FIREBIRD_IAuthBlock_getPlugin(struct FIREBIRD_IAuthBlock* self);
CLOOP_EXTERN_C const char* FIREBIRD_IAuthBlock_getSecurityDb(struct FIREBIRD_IAuthBlock* self);
CLOOP_EXTERN_C const char* FIREBIRD_IAuthBlock_getOriginalPlugin(struct FIREBIRD_IAuthBlock* self);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_IAuthBlock_next(struct FIREBIRD_IAuthBlock* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_IAuthBlock_first(struct FIREBIRD_IAuthBlock* self, struct FIREBIRD_IStatus* status);

#define FIREBIRD_IWireCryptPlugin_VERSION 5

struct FIREBIRD_IWireCryptPlugin;

struct FIREBIRD_IWireCryptPluginVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IWireCryptPlugin* self);
	int (*release)(struct FIREBIRD_IWireCryptPlugin* self);
	void (*setOwner)(struct FIREBIRD_IWireCryptPlugin* self, struct FIREBIRD_IReferenceCounted* r);
	struct FIREBIRD_IReferenceCounted* (*getOwner)(struct FIREBIRD_IWireCryptPlugin* self);
	const char* (*getKnownTypes)(struct FIREBIRD_IWireCryptPlugin* self, struct FIREBIRD_IStatus* status);
	void (*setKey)(struct FIREBIRD_IWireCryptPlugin* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ICryptKey* key);
	void (*encrypt)(struct FIREBIRD_IWireCryptPlugin* self, struct FIREBIRD_IStatus* status, unsigned length, const void* from, void* to);
	void (*decrypt)(struct FIREBIRD_IWireCryptPlugin* self, struct FIREBIRD_IStatus* status, unsigned length, const void* from, void* to);
	const unsigned char* (*getSpecificData)(struct FIREBIRD_IWireCryptPlugin* self, struct FIREBIRD_IStatus* status, const char* keyType, unsigned* length);
	void (*setSpecificData)(struct FIREBIRD_IWireCryptPlugin* self, struct FIREBIRD_IStatus* status, const char* keyType, unsigned length, const unsigned char* data);
};

struct FIREBIRD_IWireCryptPlugin
{
	void* cloopDummy[1];
	struct FIREBIRD_IWireCryptPluginVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IWireCryptPlugin_addRef(struct FIREBIRD_IWireCryptPlugin* self);
CLOOP_EXTERN_C int FIREBIRD_IWireCryptPlugin_release(struct FIREBIRD_IWireCryptPlugin* self);
CLOOP_EXTERN_C void FIREBIRD_IWireCryptPlugin_setOwner(struct FIREBIRD_IWireCryptPlugin* self, struct FIREBIRD_IReferenceCounted* r);
CLOOP_EXTERN_C struct FIREBIRD_IReferenceCounted* FIREBIRD_IWireCryptPlugin_getOwner(struct FIREBIRD_IWireCryptPlugin* self);
CLOOP_EXTERN_C const char* FIREBIRD_IWireCryptPlugin_getKnownTypes(struct FIREBIRD_IWireCryptPlugin* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IWireCryptPlugin_setKey(struct FIREBIRD_IWireCryptPlugin* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ICryptKey* key);
CLOOP_EXTERN_C void FIREBIRD_IWireCryptPlugin_encrypt(struct FIREBIRD_IWireCryptPlugin* self, struct FIREBIRD_IStatus* status, unsigned length, const void* from, void* to);
CLOOP_EXTERN_C void FIREBIRD_IWireCryptPlugin_decrypt(struct FIREBIRD_IWireCryptPlugin* self, struct FIREBIRD_IStatus* status, unsigned length, const void* from, void* to);
CLOOP_EXTERN_C const unsigned char* FIREBIRD_IWireCryptPlugin_getSpecificData(struct FIREBIRD_IWireCryptPlugin* self, struct FIREBIRD_IStatus* status, const char* keyType, unsigned* length);
CLOOP_EXTERN_C void FIREBIRD_IWireCryptPlugin_setSpecificData(struct FIREBIRD_IWireCryptPlugin* self, struct FIREBIRD_IStatus* status, const char* keyType, unsigned length, const unsigned char* data);

#define FIREBIRD_ICryptKeyCallback_VERSION 2

struct FIREBIRD_ICryptKeyCallback;

struct FIREBIRD_ICryptKeyCallbackVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	unsigned (*callback)(struct FIREBIRD_ICryptKeyCallback* self, unsigned dataLength, const void* data, unsigned bufferLength, void* buffer);
};

struct FIREBIRD_ICryptKeyCallback
{
	void* cloopDummy[1];
	struct FIREBIRD_ICryptKeyCallbackVTable* vtable;
};

CLOOP_EXTERN_C unsigned FIREBIRD_ICryptKeyCallback_callback(struct FIREBIRD_ICryptKeyCallback* self, unsigned dataLength, const void* data, unsigned bufferLength, void* buffer);

#define FIREBIRD_IKeyHolderPlugin_VERSION 5

struct FIREBIRD_IKeyHolderPlugin;

struct FIREBIRD_IKeyHolderPluginVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IKeyHolderPlugin* self);
	int (*release)(struct FIREBIRD_IKeyHolderPlugin* self);
	void (*setOwner)(struct FIREBIRD_IKeyHolderPlugin* self, struct FIREBIRD_IReferenceCounted* r);
	struct FIREBIRD_IReferenceCounted* (*getOwner)(struct FIREBIRD_IKeyHolderPlugin* self);
	int (*keyCallback)(struct FIREBIRD_IKeyHolderPlugin* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ICryptKeyCallback* callback);
	struct FIREBIRD_ICryptKeyCallback* (*keyHandle)(struct FIREBIRD_IKeyHolderPlugin* self, struct FIREBIRD_IStatus* status, const char* keyName);
	FB_BOOLEAN (*useOnlyOwnKeys)(struct FIREBIRD_IKeyHolderPlugin* self, struct FIREBIRD_IStatus* status);
	struct FIREBIRD_ICryptKeyCallback* (*chainHandle)(struct FIREBIRD_IKeyHolderPlugin* self, struct FIREBIRD_IStatus* status);
};

struct FIREBIRD_IKeyHolderPlugin
{
	void* cloopDummy[1];
	struct FIREBIRD_IKeyHolderPluginVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IKeyHolderPlugin_addRef(struct FIREBIRD_IKeyHolderPlugin* self);
CLOOP_EXTERN_C int FIREBIRD_IKeyHolderPlugin_release(struct FIREBIRD_IKeyHolderPlugin* self);
CLOOP_EXTERN_C void FIREBIRD_IKeyHolderPlugin_setOwner(struct FIREBIRD_IKeyHolderPlugin* self, struct FIREBIRD_IReferenceCounted* r);
CLOOP_EXTERN_C struct FIREBIRD_IReferenceCounted* FIREBIRD_IKeyHolderPlugin_getOwner(struct FIREBIRD_IKeyHolderPlugin* self);
CLOOP_EXTERN_C int FIREBIRD_IKeyHolderPlugin_keyCallback(struct FIREBIRD_IKeyHolderPlugin* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ICryptKeyCallback* callback);
CLOOP_EXTERN_C struct FIREBIRD_ICryptKeyCallback* FIREBIRD_IKeyHolderPlugin_keyHandle(struct FIREBIRD_IKeyHolderPlugin* self, struct FIREBIRD_IStatus* status, const char* keyName);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_IKeyHolderPlugin_useOnlyOwnKeys(struct FIREBIRD_IKeyHolderPlugin* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C struct FIREBIRD_ICryptKeyCallback* FIREBIRD_IKeyHolderPlugin_chainHandle(struct FIREBIRD_IKeyHolderPlugin* self, struct FIREBIRD_IStatus* status);

#define FIREBIRD_IDbCryptInfo_VERSION 3

struct FIREBIRD_IDbCryptInfo;

struct FIREBIRD_IDbCryptInfoVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IDbCryptInfo* self);
	int (*release)(struct FIREBIRD_IDbCryptInfo* self);
	const char* (*getDatabaseFullPath)(struct FIREBIRD_IDbCryptInfo* self, struct FIREBIRD_IStatus* status);
};

struct FIREBIRD_IDbCryptInfo
{
	void* cloopDummy[1];
	struct FIREBIRD_IDbCryptInfoVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IDbCryptInfo_addRef(struct FIREBIRD_IDbCryptInfo* self);
CLOOP_EXTERN_C int FIREBIRD_IDbCryptInfo_release(struct FIREBIRD_IDbCryptInfo* self);
CLOOP_EXTERN_C const char* FIREBIRD_IDbCryptInfo_getDatabaseFullPath(struct FIREBIRD_IDbCryptInfo* self, struct FIREBIRD_IStatus* status);

#define FIREBIRD_IDbCryptPlugin_VERSION 5

struct FIREBIRD_IDbCryptPlugin;

struct FIREBIRD_IDbCryptPluginVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IDbCryptPlugin* self);
	int (*release)(struct FIREBIRD_IDbCryptPlugin* self);
	void (*setOwner)(struct FIREBIRD_IDbCryptPlugin* self, struct FIREBIRD_IReferenceCounted* r);
	struct FIREBIRD_IReferenceCounted* (*getOwner)(struct FIREBIRD_IDbCryptPlugin* self);
	void (*setKey)(struct FIREBIRD_IDbCryptPlugin* self, struct FIREBIRD_IStatus* status, unsigned length, struct FIREBIRD_IKeyHolderPlugin** sources, const char* keyName);
	void (*encrypt)(struct FIREBIRD_IDbCryptPlugin* self, struct FIREBIRD_IStatus* status, unsigned length, const void* from, void* to);
	void (*decrypt)(struct FIREBIRD_IDbCryptPlugin* self, struct FIREBIRD_IStatus* status, unsigned length, const void* from, void* to);
	void (*setInfo)(struct FIREBIRD_IDbCryptPlugin* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IDbCryptInfo* info);
};

struct FIREBIRD_IDbCryptPlugin
{
	void* cloopDummy[1];
	struct FIREBIRD_IDbCryptPluginVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IDbCryptPlugin_addRef(struct FIREBIRD_IDbCryptPlugin* self);
CLOOP_EXTERN_C int FIREBIRD_IDbCryptPlugin_release(struct FIREBIRD_IDbCryptPlugin* self);
CLOOP_EXTERN_C void FIREBIRD_IDbCryptPlugin_setOwner(struct FIREBIRD_IDbCryptPlugin* self, struct FIREBIRD_IReferenceCounted* r);
CLOOP_EXTERN_C struct FIREBIRD_IReferenceCounted* FIREBIRD_IDbCryptPlugin_getOwner(struct FIREBIRD_IDbCryptPlugin* self);
CLOOP_EXTERN_C void FIREBIRD_IDbCryptPlugin_setKey(struct FIREBIRD_IDbCryptPlugin* self, struct FIREBIRD_IStatus* status, unsigned length, struct FIREBIRD_IKeyHolderPlugin** sources, const char* keyName);
CLOOP_EXTERN_C void FIREBIRD_IDbCryptPlugin_encrypt(struct FIREBIRD_IDbCryptPlugin* self, struct FIREBIRD_IStatus* status, unsigned length, const void* from, void* to);
CLOOP_EXTERN_C void FIREBIRD_IDbCryptPlugin_decrypt(struct FIREBIRD_IDbCryptPlugin* self, struct FIREBIRD_IStatus* status, unsigned length, const void* from, void* to);
CLOOP_EXTERN_C void FIREBIRD_IDbCryptPlugin_setInfo(struct FIREBIRD_IDbCryptPlugin* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IDbCryptInfo* info);

#define FIREBIRD_IExternalContext_VERSION 2

struct FIREBIRD_IExternalContext;

struct FIREBIRD_IExternalContextVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	struct FIREBIRD_IMaster* (*getMaster)(struct FIREBIRD_IExternalContext* self);
	struct FIREBIRD_IExternalEngine* (*getEngine)(struct FIREBIRD_IExternalContext* self, struct FIREBIRD_IStatus* status);
	struct FIREBIRD_IAttachment* (*getAttachment)(struct FIREBIRD_IExternalContext* self, struct FIREBIRD_IStatus* status);
	struct FIREBIRD_ITransaction* (*getTransaction)(struct FIREBIRD_IExternalContext* self, struct FIREBIRD_IStatus* status);
	const char* (*getUserName)(struct FIREBIRD_IExternalContext* self);
	const char* (*getDatabaseName)(struct FIREBIRD_IExternalContext* self);
	const char* (*getClientCharSet)(struct FIREBIRD_IExternalContext* self);
	int (*obtainInfoCode)(struct FIREBIRD_IExternalContext* self);
	void* (*getInfo)(struct FIREBIRD_IExternalContext* self, int code);
	void* (*setInfo)(struct FIREBIRD_IExternalContext* self, int code, void* value);
};

struct FIREBIRD_IExternalContext
{
	void* cloopDummy[1];
	struct FIREBIRD_IExternalContextVTable* vtable;
};

CLOOP_EXTERN_C struct FIREBIRD_IMaster* FIREBIRD_IExternalContext_getMaster(struct FIREBIRD_IExternalContext* self);
CLOOP_EXTERN_C struct FIREBIRD_IExternalEngine* FIREBIRD_IExternalContext_getEngine(struct FIREBIRD_IExternalContext* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C struct FIREBIRD_IAttachment* FIREBIRD_IExternalContext_getAttachment(struct FIREBIRD_IExternalContext* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C struct FIREBIRD_ITransaction* FIREBIRD_IExternalContext_getTransaction(struct FIREBIRD_IExternalContext* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C const char* FIREBIRD_IExternalContext_getUserName(struct FIREBIRD_IExternalContext* self);
CLOOP_EXTERN_C const char* FIREBIRD_IExternalContext_getDatabaseName(struct FIREBIRD_IExternalContext* self);
CLOOP_EXTERN_C const char* FIREBIRD_IExternalContext_getClientCharSet(struct FIREBIRD_IExternalContext* self);
CLOOP_EXTERN_C int FIREBIRD_IExternalContext_obtainInfoCode(struct FIREBIRD_IExternalContext* self);
CLOOP_EXTERN_C void* FIREBIRD_IExternalContext_getInfo(struct FIREBIRD_IExternalContext* self, int code);
CLOOP_EXTERN_C void* FIREBIRD_IExternalContext_setInfo(struct FIREBIRD_IExternalContext* self, int code, void* value);

#define FIREBIRD_IExternalResultSet_VERSION 3

struct FIREBIRD_IExternalResultSet;

struct FIREBIRD_IExternalResultSetVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*dispose)(struct FIREBIRD_IExternalResultSet* self);
	FB_BOOLEAN (*fetch)(struct FIREBIRD_IExternalResultSet* self, struct FIREBIRD_IStatus* status);
};

struct FIREBIRD_IExternalResultSet
{
	void* cloopDummy[1];
	struct FIREBIRD_IExternalResultSetVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IExternalResultSet_dispose(struct FIREBIRD_IExternalResultSet* self);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_IExternalResultSet_fetch(struct FIREBIRD_IExternalResultSet* self, struct FIREBIRD_IStatus* status);

#define FIREBIRD_IExternalFunction_VERSION 3

struct FIREBIRD_IExternalFunction;

struct FIREBIRD_IExternalFunctionVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*dispose)(struct FIREBIRD_IExternalFunction* self);
	void (*getCharSet)(struct FIREBIRD_IExternalFunction* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, char* name, unsigned nameSize);
	void (*execute)(struct FIREBIRD_IExternalFunction* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, void* inMsg, void* outMsg);
};

struct FIREBIRD_IExternalFunction
{
	void* cloopDummy[1];
	struct FIREBIRD_IExternalFunctionVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IExternalFunction_dispose(struct FIREBIRD_IExternalFunction* self);
CLOOP_EXTERN_C void FIREBIRD_IExternalFunction_getCharSet(struct FIREBIRD_IExternalFunction* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, char* name, unsigned nameSize);
CLOOP_EXTERN_C void FIREBIRD_IExternalFunction_execute(struct FIREBIRD_IExternalFunction* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, void* inMsg, void* outMsg);

#define FIREBIRD_IExternalProcedure_VERSION 3

struct FIREBIRD_IExternalProcedure;

struct FIREBIRD_IExternalProcedureVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*dispose)(struct FIREBIRD_IExternalProcedure* self);
	void (*getCharSet)(struct FIREBIRD_IExternalProcedure* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, char* name, unsigned nameSize);
	struct FIREBIRD_IExternalResultSet* (*open)(struct FIREBIRD_IExternalProcedure* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, void* inMsg, void* outMsg);
};

struct FIREBIRD_IExternalProcedure
{
	void* cloopDummy[1];
	struct FIREBIRD_IExternalProcedureVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IExternalProcedure_dispose(struct FIREBIRD_IExternalProcedure* self);
CLOOP_EXTERN_C void FIREBIRD_IExternalProcedure_getCharSet(struct FIREBIRD_IExternalProcedure* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, char* name, unsigned nameSize);
CLOOP_EXTERN_C struct FIREBIRD_IExternalResultSet* FIREBIRD_IExternalProcedure_open(struct FIREBIRD_IExternalProcedure* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, void* inMsg, void* outMsg);

#define FIREBIRD_IExternalTrigger_VERSION 3

#define FIREBIRD_IExternalTrigger_TYPE_BEFORE ((unsigned) (1))
#define FIREBIRD_IExternalTrigger_TYPE_AFTER ((unsigned) (2))
#define FIREBIRD_IExternalTrigger_TYPE_DATABASE ((unsigned) (3))
#define FIREBIRD_IExternalTrigger_ACTION_INSERT ((unsigned) (1))
#define FIREBIRD_IExternalTrigger_ACTION_UPDATE ((unsigned) (2))
#define FIREBIRD_IExternalTrigger_ACTION_DELETE ((unsigned) (3))
#define FIREBIRD_IExternalTrigger_ACTION_CONNECT ((unsigned) (4))
#define FIREBIRD_IExternalTrigger_ACTION_DISCONNECT ((unsigned) (5))
#define FIREBIRD_IExternalTrigger_ACTION_TRANS_START ((unsigned) (6))
#define FIREBIRD_IExternalTrigger_ACTION_TRANS_COMMIT ((unsigned) (7))
#define FIREBIRD_IExternalTrigger_ACTION_TRANS_ROLLBACK ((unsigned) (8))
#define FIREBIRD_IExternalTrigger_ACTION_DDL ((unsigned) (9))

struct FIREBIRD_IExternalTrigger;

struct FIREBIRD_IExternalTriggerVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*dispose)(struct FIREBIRD_IExternalTrigger* self);
	void (*getCharSet)(struct FIREBIRD_IExternalTrigger* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, char* name, unsigned nameSize);
	void (*execute)(struct FIREBIRD_IExternalTrigger* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, unsigned action, void* oldMsg, void* newMsg);
};

struct FIREBIRD_IExternalTrigger
{
	void* cloopDummy[1];
	struct FIREBIRD_IExternalTriggerVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IExternalTrigger_dispose(struct FIREBIRD_IExternalTrigger* self);
CLOOP_EXTERN_C void FIREBIRD_IExternalTrigger_getCharSet(struct FIREBIRD_IExternalTrigger* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, char* name, unsigned nameSize);
CLOOP_EXTERN_C void FIREBIRD_IExternalTrigger_execute(struct FIREBIRD_IExternalTrigger* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, unsigned action, void* oldMsg, void* newMsg);

#define FIREBIRD_IRoutineMetadata_VERSION 2

struct FIREBIRD_IRoutineMetadata;

struct FIREBIRD_IRoutineMetadataVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	const char* (*getPackage)(const struct FIREBIRD_IRoutineMetadata* self, struct FIREBIRD_IStatus* status);
	const char* (*getName)(const struct FIREBIRD_IRoutineMetadata* self, struct FIREBIRD_IStatus* status);
	const char* (*getEntryPoint)(const struct FIREBIRD_IRoutineMetadata* self, struct FIREBIRD_IStatus* status);
	const char* (*getBody)(const struct FIREBIRD_IRoutineMetadata* self, struct FIREBIRD_IStatus* status);
	struct FIREBIRD_IMessageMetadata* (*getInputMetadata)(const struct FIREBIRD_IRoutineMetadata* self, struct FIREBIRD_IStatus* status);
	struct FIREBIRD_IMessageMetadata* (*getOutputMetadata)(const struct FIREBIRD_IRoutineMetadata* self, struct FIREBIRD_IStatus* status);
	struct FIREBIRD_IMessageMetadata* (*getTriggerMetadata)(const struct FIREBIRD_IRoutineMetadata* self, struct FIREBIRD_IStatus* status);
	const char* (*getTriggerTable)(const struct FIREBIRD_IRoutineMetadata* self, struct FIREBIRD_IStatus* status);
	unsigned (*getTriggerType)(const struct FIREBIRD_IRoutineMetadata* self, struct FIREBIRD_IStatus* status);
};

struct FIREBIRD_IRoutineMetadata
{
	void* cloopDummy[1];
	struct FIREBIRD_IRoutineMetadataVTable* vtable;
};

CLOOP_EXTERN_C const char* FIREBIRD_IRoutineMetadata_getPackage(const struct FIREBIRD_IRoutineMetadata* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C const char* FIREBIRD_IRoutineMetadata_getName(const struct FIREBIRD_IRoutineMetadata* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C const char* FIREBIRD_IRoutineMetadata_getEntryPoint(const struct FIREBIRD_IRoutineMetadata* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C const char* FIREBIRD_IRoutineMetadata_getBody(const struct FIREBIRD_IRoutineMetadata* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C struct FIREBIRD_IMessageMetadata* FIREBIRD_IRoutineMetadata_getInputMetadata(const struct FIREBIRD_IRoutineMetadata* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C struct FIREBIRD_IMessageMetadata* FIREBIRD_IRoutineMetadata_getOutputMetadata(const struct FIREBIRD_IRoutineMetadata* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C struct FIREBIRD_IMessageMetadata* FIREBIRD_IRoutineMetadata_getTriggerMetadata(const struct FIREBIRD_IRoutineMetadata* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C const char* FIREBIRD_IRoutineMetadata_getTriggerTable(const struct FIREBIRD_IRoutineMetadata* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C unsigned FIREBIRD_IRoutineMetadata_getTriggerType(const struct FIREBIRD_IRoutineMetadata* self, struct FIREBIRD_IStatus* status);

#define FIREBIRD_IExternalEngine_VERSION 4

struct FIREBIRD_IExternalEngine;

struct FIREBIRD_IExternalEngineVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IExternalEngine* self);
	int (*release)(struct FIREBIRD_IExternalEngine* self);
	void (*setOwner)(struct FIREBIRD_IExternalEngine* self, struct FIREBIRD_IReferenceCounted* r);
	struct FIREBIRD_IReferenceCounted* (*getOwner)(struct FIREBIRD_IExternalEngine* self);
	void (*open)(struct FIREBIRD_IExternalEngine* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, char* charSet, unsigned charSetSize);
	void (*openAttachment)(struct FIREBIRD_IExternalEngine* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context);
	void (*closeAttachment)(struct FIREBIRD_IExternalEngine* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context);
	struct FIREBIRD_IExternalFunction* (*makeFunction)(struct FIREBIRD_IExternalEngine* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, struct FIREBIRD_IRoutineMetadata* metadata, struct FIREBIRD_IMetadataBuilder* inBuilder, struct FIREBIRD_IMetadataBuilder* outBuilder);
	struct FIREBIRD_IExternalProcedure* (*makeProcedure)(struct FIREBIRD_IExternalEngine* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, struct FIREBIRD_IRoutineMetadata* metadata, struct FIREBIRD_IMetadataBuilder* inBuilder, struct FIREBIRD_IMetadataBuilder* outBuilder);
	struct FIREBIRD_IExternalTrigger* (*makeTrigger)(struct FIREBIRD_IExternalEngine* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, struct FIREBIRD_IRoutineMetadata* metadata, struct FIREBIRD_IMetadataBuilder* fieldsBuilder);
};

struct FIREBIRD_IExternalEngine
{
	void* cloopDummy[1];
	struct FIREBIRD_IExternalEngineVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IExternalEngine_addRef(struct FIREBIRD_IExternalEngine* self);
CLOOP_EXTERN_C int FIREBIRD_IExternalEngine_release(struct FIREBIRD_IExternalEngine* self);
CLOOP_EXTERN_C void FIREBIRD_IExternalEngine_setOwner(struct FIREBIRD_IExternalEngine* self, struct FIREBIRD_IReferenceCounted* r);
CLOOP_EXTERN_C struct FIREBIRD_IReferenceCounted* FIREBIRD_IExternalEngine_getOwner(struct FIREBIRD_IExternalEngine* self);
CLOOP_EXTERN_C void FIREBIRD_IExternalEngine_open(struct FIREBIRD_IExternalEngine* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, char* charSet, unsigned charSetSize);
CLOOP_EXTERN_C void FIREBIRD_IExternalEngine_openAttachment(struct FIREBIRD_IExternalEngine* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context);
CLOOP_EXTERN_C void FIREBIRD_IExternalEngine_closeAttachment(struct FIREBIRD_IExternalEngine* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context);
CLOOP_EXTERN_C struct FIREBIRD_IExternalFunction* FIREBIRD_IExternalEngine_makeFunction(struct FIREBIRD_IExternalEngine* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, struct FIREBIRD_IRoutineMetadata* metadata, struct FIREBIRD_IMetadataBuilder* inBuilder, struct FIREBIRD_IMetadataBuilder* outBuilder);
CLOOP_EXTERN_C struct FIREBIRD_IExternalProcedure* FIREBIRD_IExternalEngine_makeProcedure(struct FIREBIRD_IExternalEngine* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, struct FIREBIRD_IRoutineMetadata* metadata, struct FIREBIRD_IMetadataBuilder* inBuilder, struct FIREBIRD_IMetadataBuilder* outBuilder);
CLOOP_EXTERN_C struct FIREBIRD_IExternalTrigger* FIREBIRD_IExternalEngine_makeTrigger(struct FIREBIRD_IExternalEngine* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, struct FIREBIRD_IRoutineMetadata* metadata, struct FIREBIRD_IMetadataBuilder* fieldsBuilder);

#define FIREBIRD_ITimer_VERSION 3

struct FIREBIRD_ITimer;

struct FIREBIRD_ITimerVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_ITimer* self);
	int (*release)(struct FIREBIRD_ITimer* self);
	void (*handler)(struct FIREBIRD_ITimer* self);
};

struct FIREBIRD_ITimer
{
	void* cloopDummy[1];
	struct FIREBIRD_ITimerVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_ITimer_addRef(struct FIREBIRD_ITimer* self);
CLOOP_EXTERN_C int FIREBIRD_ITimer_release(struct FIREBIRD_ITimer* self);
CLOOP_EXTERN_C void FIREBIRD_ITimer_handler(struct FIREBIRD_ITimer* self);

#define FIREBIRD_ITimerControl_VERSION 2

struct FIREBIRD_ITimerControl;

struct FIREBIRD_ITimerControlVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*start)(struct FIREBIRD_ITimerControl* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITimer* timer, ISC_UINT64 microSeconds);
	void (*stop)(struct FIREBIRD_ITimerControl* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITimer* timer);
};

struct FIREBIRD_ITimerControl
{
	void* cloopDummy[1];
	struct FIREBIRD_ITimerControlVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_ITimerControl_start(struct FIREBIRD_ITimerControl* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITimer* timer, ISC_UINT64 microSeconds);
CLOOP_EXTERN_C void FIREBIRD_ITimerControl_stop(struct FIREBIRD_ITimerControl* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITimer* timer);

#define FIREBIRD_IVersionCallback_VERSION 2

struct FIREBIRD_IVersionCallback;

struct FIREBIRD_IVersionCallbackVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*callback)(struct FIREBIRD_IVersionCallback* self, struct FIREBIRD_IStatus* status, const char* text);
};

struct FIREBIRD_IVersionCallback
{
	void* cloopDummy[1];
	struct FIREBIRD_IVersionCallbackVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IVersionCallback_callback(struct FIREBIRD_IVersionCallback* self, struct FIREBIRD_IStatus* status, const char* text);

#define FIREBIRD_IUtil_VERSION 4

struct FIREBIRD_IUtil;

struct FIREBIRD_IUtilVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*getFbVersion)(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IAttachment* att, struct FIREBIRD_IVersionCallback* callback);
	void (*loadBlob)(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status, ISC_QUAD* blobId, struct FIREBIRD_IAttachment* att, struct FIREBIRD_ITransaction* tra, const char* file, FB_BOOLEAN txt);
	void (*dumpBlob)(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status, ISC_QUAD* blobId, struct FIREBIRD_IAttachment* att, struct FIREBIRD_ITransaction* tra, const char* file, FB_BOOLEAN txt);
	void (*getPerfCounters)(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IAttachment* att, const char* countersSet, ISC_INT64* counters);
	struct FIREBIRD_IAttachment* (*executeCreateDatabase)(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status, unsigned stmtLength, const char* creatDBstatement, unsigned dialect, FB_BOOLEAN* stmtIsCreateDb);
	void (*decodeDate)(struct FIREBIRD_IUtil* self, ISC_DATE date, unsigned* year, unsigned* month, unsigned* day);
	void (*decodeTime)(struct FIREBIRD_IUtil* self, ISC_TIME time, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions);
	ISC_DATE (*encodeDate)(struct FIREBIRD_IUtil* self, unsigned year, unsigned month, unsigned day);
	ISC_TIME (*encodeTime)(struct FIREBIRD_IUtil* self, unsigned hours, unsigned minutes, unsigned seconds, unsigned fractions);
	unsigned (*formatStatus)(struct FIREBIRD_IUtil* self, char* buffer, unsigned bufferSize, struct FIREBIRD_IStatus* status);
	unsigned (*getClientVersion)(struct FIREBIRD_IUtil* self);
	struct FIREBIRD_IXpbBuilder* (*getXpbBuilder)(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status, unsigned kind, const unsigned char* buf, unsigned len);
	unsigned (*setOffsets)(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IMessageMetadata* metadata, struct FIREBIRD_IOffsetsCallback* callback);
	struct FIREBIRD_IDecFloat16* (*getDecFloat16)(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status);
	struct FIREBIRD_IDecFloat34* (*getDecFloat34)(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status);
	void (*decodeTimeTz)(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status, const ISC_TIME_TZ* timeTz, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer);
	void (*decodeTimeStampTz)(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status, const ISC_TIMESTAMP_TZ* timeStampTz, unsigned* year, unsigned* month, unsigned* day, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer);
	void (*encodeTimeTz)(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status, ISC_TIME_TZ* timeTz, unsigned hours, unsigned minutes, unsigned seconds, unsigned fractions, const char* timeZone);
	void (*encodeTimeStampTz)(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status, ISC_TIMESTAMP_TZ* timeStampTz, unsigned year, unsigned month, unsigned day, unsigned hours, unsigned minutes, unsigned seconds, unsigned fractions, const char* timeZone);
	struct FIREBIRD_IInt128* (*getInt128)(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status);
	void (*decodeTimeTzEx)(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status, const ISC_TIME_TZ_EX* timeTz, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer);
	void (*decodeTimeStampTzEx)(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status, const ISC_TIMESTAMP_TZ_EX* timeStampTz, unsigned* year, unsigned* month, unsigned* day, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer);
};

struct FIREBIRD_IUtil
{
	void* cloopDummy[1];
	struct FIREBIRD_IUtilVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IUtil_getFbVersion(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IAttachment* att, struct FIREBIRD_IVersionCallback* callback);
CLOOP_EXTERN_C void FIREBIRD_IUtil_loadBlob(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status, ISC_QUAD* blobId, struct FIREBIRD_IAttachment* att, struct FIREBIRD_ITransaction* tra, const char* file, FB_BOOLEAN txt);
CLOOP_EXTERN_C void FIREBIRD_IUtil_dumpBlob(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status, ISC_QUAD* blobId, struct FIREBIRD_IAttachment* att, struct FIREBIRD_ITransaction* tra, const char* file, FB_BOOLEAN txt);
CLOOP_EXTERN_C void FIREBIRD_IUtil_getPerfCounters(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IAttachment* att, const char* countersSet, ISC_INT64* counters);
CLOOP_EXTERN_C struct FIREBIRD_IAttachment* FIREBIRD_IUtil_executeCreateDatabase(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status, unsigned stmtLength, const char* creatDBstatement, unsigned dialect, FB_BOOLEAN* stmtIsCreateDb);
CLOOP_EXTERN_C void FIREBIRD_IUtil_decodeDate(struct FIREBIRD_IUtil* self, ISC_DATE date, unsigned* year, unsigned* month, unsigned* day);
CLOOP_EXTERN_C void FIREBIRD_IUtil_decodeTime(struct FIREBIRD_IUtil* self, ISC_TIME time, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions);
CLOOP_EXTERN_C ISC_DATE FIREBIRD_IUtil_encodeDate(struct FIREBIRD_IUtil* self, unsigned year, unsigned month, unsigned day);
CLOOP_EXTERN_C ISC_TIME FIREBIRD_IUtil_encodeTime(struct FIREBIRD_IUtil* self, unsigned hours, unsigned minutes, unsigned seconds, unsigned fractions);
CLOOP_EXTERN_C unsigned FIREBIRD_IUtil_formatStatus(struct FIREBIRD_IUtil* self, char* buffer, unsigned bufferSize, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C unsigned FIREBIRD_IUtil_getClientVersion(struct FIREBIRD_IUtil* self);
CLOOP_EXTERN_C struct FIREBIRD_IXpbBuilder* FIREBIRD_IUtil_getXpbBuilder(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status, unsigned kind, const unsigned char* buf, unsigned len);
CLOOP_EXTERN_C unsigned FIREBIRD_IUtil_setOffsets(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IMessageMetadata* metadata, struct FIREBIRD_IOffsetsCallback* callback);
CLOOP_EXTERN_C struct FIREBIRD_IDecFloat16* FIREBIRD_IUtil_getDecFloat16(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C struct FIREBIRD_IDecFloat34* FIREBIRD_IUtil_getDecFloat34(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IUtil_decodeTimeTz(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status, const ISC_TIME_TZ* timeTz, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer);
CLOOP_EXTERN_C void FIREBIRD_IUtil_decodeTimeStampTz(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status, const ISC_TIMESTAMP_TZ* timeStampTz, unsigned* year, unsigned* month, unsigned* day, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer);
CLOOP_EXTERN_C void FIREBIRD_IUtil_encodeTimeTz(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status, ISC_TIME_TZ* timeTz, unsigned hours, unsigned minutes, unsigned seconds, unsigned fractions, const char* timeZone);
CLOOP_EXTERN_C void FIREBIRD_IUtil_encodeTimeStampTz(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status, ISC_TIMESTAMP_TZ* timeStampTz, unsigned year, unsigned month, unsigned day, unsigned hours, unsigned minutes, unsigned seconds, unsigned fractions, const char* timeZone);
CLOOP_EXTERN_C struct FIREBIRD_IInt128* FIREBIRD_IUtil_getInt128(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IUtil_decodeTimeTzEx(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status, const ISC_TIME_TZ_EX* timeTz, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer);
CLOOP_EXTERN_C void FIREBIRD_IUtil_decodeTimeStampTzEx(struct FIREBIRD_IUtil* self, struct FIREBIRD_IStatus* status, const ISC_TIMESTAMP_TZ_EX* timeStampTz, unsigned* year, unsigned* month, unsigned* day, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer);

#define FIREBIRD_IOffsetsCallback_VERSION 2

struct FIREBIRD_IOffsetsCallback;

struct FIREBIRD_IOffsetsCallbackVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*setOffset)(struct FIREBIRD_IOffsetsCallback* self, struct FIREBIRD_IStatus* status, unsigned index, unsigned offset, unsigned nullOffset);
};

struct FIREBIRD_IOffsetsCallback
{
	void* cloopDummy[1];
	struct FIREBIRD_IOffsetsCallbackVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IOffsetsCallback_setOffset(struct FIREBIRD_IOffsetsCallback* self, struct FIREBIRD_IStatus* status, unsigned index, unsigned offset, unsigned nullOffset);

#define FIREBIRD_IXpbBuilder_VERSION 3

#define FIREBIRD_IXpbBuilder_DPB ((unsigned) (1))
#define FIREBIRD_IXpbBuilder_SPB_ATTACH ((unsigned) (2))
#define FIREBIRD_IXpbBuilder_SPB_START ((unsigned) (3))
#define FIREBIRD_IXpbBuilder_TPB ((unsigned) (4))
#define FIREBIRD_IXpbBuilder_BATCH ((unsigned) (5))
#define FIREBIRD_IXpbBuilder_BPB ((unsigned) (6))
#define FIREBIRD_IXpbBuilder_SPB_SEND ((unsigned) (7))
#define FIREBIRD_IXpbBuilder_SPB_RECEIVE ((unsigned) (8))
#define FIREBIRD_IXpbBuilder_SPB_RESPONSE ((unsigned) (9))
#define FIREBIRD_IXpbBuilder_INFO_SEND ((unsigned) (10))
#define FIREBIRD_IXpbBuilder_INFO_RESPONSE ((unsigned) (11))

struct FIREBIRD_IXpbBuilder;

struct FIREBIRD_IXpbBuilderVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*dispose)(struct FIREBIRD_IXpbBuilder* self);
	void (*clear)(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);
	void (*removeCurrent)(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);
	void (*insertInt)(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status, unsigned char tag, int value);
	void (*insertBigInt)(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status, unsigned char tag, ISC_INT64 value);
	void (*insertBytes)(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status, unsigned char tag, const void* bytes, unsigned length);
	void (*insertString)(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status, unsigned char tag, const char* str);
	void (*insertTag)(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status, unsigned char tag);
	FB_BOOLEAN (*isEof)(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);
	void (*moveNext)(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);
	void (*rewind)(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);
	FB_BOOLEAN (*findFirst)(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status, unsigned char tag);
	FB_BOOLEAN (*findNext)(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);
	unsigned char (*getTag)(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);
	unsigned (*getLength)(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);
	int (*getInt)(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);
	ISC_INT64 (*getBigInt)(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);
	const char* (*getString)(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);
	const unsigned char* (*getBytes)(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);
	unsigned (*getBufferLength)(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);
	const unsigned char* (*getBuffer)(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);
};

struct FIREBIRD_IXpbBuilder
{
	void* cloopDummy[1];
	struct FIREBIRD_IXpbBuilderVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IXpbBuilder_dispose(struct FIREBIRD_IXpbBuilder* self);
CLOOP_EXTERN_C void FIREBIRD_IXpbBuilder_clear(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IXpbBuilder_removeCurrent(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IXpbBuilder_insertInt(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status, unsigned char tag, int value);
CLOOP_EXTERN_C void FIREBIRD_IXpbBuilder_insertBigInt(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status, unsigned char tag, ISC_INT64 value);
CLOOP_EXTERN_C void FIREBIRD_IXpbBuilder_insertBytes(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status, unsigned char tag, const void* bytes, unsigned length);
CLOOP_EXTERN_C void FIREBIRD_IXpbBuilder_insertString(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status, unsigned char tag, const char* str);
CLOOP_EXTERN_C void FIREBIRD_IXpbBuilder_insertTag(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status, unsigned char tag);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_IXpbBuilder_isEof(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IXpbBuilder_moveNext(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IXpbBuilder_rewind(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_IXpbBuilder_findFirst(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status, unsigned char tag);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_IXpbBuilder_findNext(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C unsigned char FIREBIRD_IXpbBuilder_getTag(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C unsigned FIREBIRD_IXpbBuilder_getLength(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C int FIREBIRD_IXpbBuilder_getInt(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C ISC_INT64 FIREBIRD_IXpbBuilder_getBigInt(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C const char* FIREBIRD_IXpbBuilder_getString(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C const unsigned char* FIREBIRD_IXpbBuilder_getBytes(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C unsigned FIREBIRD_IXpbBuilder_getBufferLength(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C const unsigned char* FIREBIRD_IXpbBuilder_getBuffer(struct FIREBIRD_IXpbBuilder* self, struct FIREBIRD_IStatus* status);

#define FIREBIRD_ITraceConnection_VERSION 2

#define FIREBIRD_ITraceConnection_KIND_DATABASE ((unsigned) (1))
#define FIREBIRD_ITraceConnection_KIND_SERVICE ((unsigned) (2))

struct FIREBIRD_ITraceConnection;

struct FIREBIRD_ITraceConnectionVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	unsigned (*getKind)(struct FIREBIRD_ITraceConnection* self);
	int (*getProcessID)(struct FIREBIRD_ITraceConnection* self);
	const char* (*getUserName)(struct FIREBIRD_ITraceConnection* self);
	const char* (*getRoleName)(struct FIREBIRD_ITraceConnection* self);
	const char* (*getCharSet)(struct FIREBIRD_ITraceConnection* self);
	const char* (*getRemoteProtocol)(struct FIREBIRD_ITraceConnection* self);
	const char* (*getRemoteAddress)(struct FIREBIRD_ITraceConnection* self);
	int (*getRemoteProcessID)(struct FIREBIRD_ITraceConnection* self);
	const char* (*getRemoteProcessName)(struct FIREBIRD_ITraceConnection* self);
};

struct FIREBIRD_ITraceConnection
{
	void* cloopDummy[1];
	struct FIREBIRD_ITraceConnectionVTable* vtable;
};

CLOOP_EXTERN_C unsigned FIREBIRD_ITraceConnection_getKind(struct FIREBIRD_ITraceConnection* self);
CLOOP_EXTERN_C int FIREBIRD_ITraceConnection_getProcessID(struct FIREBIRD_ITraceConnection* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceConnection_getUserName(struct FIREBIRD_ITraceConnection* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceConnection_getRoleName(struct FIREBIRD_ITraceConnection* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceConnection_getCharSet(struct FIREBIRD_ITraceConnection* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceConnection_getRemoteProtocol(struct FIREBIRD_ITraceConnection* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceConnection_getRemoteAddress(struct FIREBIRD_ITraceConnection* self);
CLOOP_EXTERN_C int FIREBIRD_ITraceConnection_getRemoteProcessID(struct FIREBIRD_ITraceConnection* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceConnection_getRemoteProcessName(struct FIREBIRD_ITraceConnection* self);

#define FIREBIRD_ITraceDatabaseConnection_VERSION 3

struct FIREBIRD_ITraceDatabaseConnection;

struct FIREBIRD_ITraceDatabaseConnectionVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	unsigned (*getKind)(struct FIREBIRD_ITraceDatabaseConnection* self);
	int (*getProcessID)(struct FIREBIRD_ITraceDatabaseConnection* self);
	const char* (*getUserName)(struct FIREBIRD_ITraceDatabaseConnection* self);
	const char* (*getRoleName)(struct FIREBIRD_ITraceDatabaseConnection* self);
	const char* (*getCharSet)(struct FIREBIRD_ITraceDatabaseConnection* self);
	const char* (*getRemoteProtocol)(struct FIREBIRD_ITraceDatabaseConnection* self);
	const char* (*getRemoteAddress)(struct FIREBIRD_ITraceDatabaseConnection* self);
	int (*getRemoteProcessID)(struct FIREBIRD_ITraceDatabaseConnection* self);
	const char* (*getRemoteProcessName)(struct FIREBIRD_ITraceDatabaseConnection* self);
	ISC_INT64 (*getConnectionID)(struct FIREBIRD_ITraceDatabaseConnection* self);
	const char* (*getDatabaseName)(struct FIREBIRD_ITraceDatabaseConnection* self);
};

struct FIREBIRD_ITraceDatabaseConnection
{
	void* cloopDummy[1];
	struct FIREBIRD_ITraceDatabaseConnectionVTable* vtable;
};

CLOOP_EXTERN_C unsigned FIREBIRD_ITraceDatabaseConnection_getKind(struct FIREBIRD_ITraceDatabaseConnection* self);
CLOOP_EXTERN_C int FIREBIRD_ITraceDatabaseConnection_getProcessID(struct FIREBIRD_ITraceDatabaseConnection* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceDatabaseConnection_getUserName(struct FIREBIRD_ITraceDatabaseConnection* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceDatabaseConnection_getRoleName(struct FIREBIRD_ITraceDatabaseConnection* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceDatabaseConnection_getCharSet(struct FIREBIRD_ITraceDatabaseConnection* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceDatabaseConnection_getRemoteProtocol(struct FIREBIRD_ITraceDatabaseConnection* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceDatabaseConnection_getRemoteAddress(struct FIREBIRD_ITraceDatabaseConnection* self);
CLOOP_EXTERN_C int FIREBIRD_ITraceDatabaseConnection_getRemoteProcessID(struct FIREBIRD_ITraceDatabaseConnection* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceDatabaseConnection_getRemoteProcessName(struct FIREBIRD_ITraceDatabaseConnection* self);
CLOOP_EXTERN_C ISC_INT64 FIREBIRD_ITraceDatabaseConnection_getConnectionID(struct FIREBIRD_ITraceDatabaseConnection* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceDatabaseConnection_getDatabaseName(struct FIREBIRD_ITraceDatabaseConnection* self);

#define FIREBIRD_ITraceTransaction_VERSION 3

#define FIREBIRD_ITraceTransaction_ISOLATION_CONSISTENCY ((unsigned) (1))
#define FIREBIRD_ITraceTransaction_ISOLATION_CONCURRENCY ((unsigned) (2))
#define FIREBIRD_ITraceTransaction_ISOLATION_READ_COMMITTED_RECVER ((unsigned) (3))
#define FIREBIRD_ITraceTransaction_ISOLATION_READ_COMMITTED_NORECVER ((unsigned) (4))
#define FIREBIRD_ITraceTransaction_ISOLATION_READ_COMMITTED_READ_CONSISTENCY ((unsigned) (5))

struct FIREBIRD_ITraceTransaction;

struct FIREBIRD_ITraceTransactionVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	ISC_INT64 (*getTransactionID)(struct FIREBIRD_ITraceTransaction* self);
	FB_BOOLEAN (*getReadOnly)(struct FIREBIRD_ITraceTransaction* self);
	int (*getWait)(struct FIREBIRD_ITraceTransaction* self);
	unsigned (*getIsolation)(struct FIREBIRD_ITraceTransaction* self);
	struct PerformanceInfo* (*getPerf)(struct FIREBIRD_ITraceTransaction* self);
	ISC_INT64 (*getInitialID)(struct FIREBIRD_ITraceTransaction* self);
	ISC_INT64 (*getPreviousID)(struct FIREBIRD_ITraceTransaction* self);
};

struct FIREBIRD_ITraceTransaction
{
	void* cloopDummy[1];
	struct FIREBIRD_ITraceTransactionVTable* vtable;
};

CLOOP_EXTERN_C ISC_INT64 FIREBIRD_ITraceTransaction_getTransactionID(struct FIREBIRD_ITraceTransaction* self);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_ITraceTransaction_getReadOnly(struct FIREBIRD_ITraceTransaction* self);
CLOOP_EXTERN_C int FIREBIRD_ITraceTransaction_getWait(struct FIREBIRD_ITraceTransaction* self);
CLOOP_EXTERN_C unsigned FIREBIRD_ITraceTransaction_getIsolation(struct FIREBIRD_ITraceTransaction* self);
CLOOP_EXTERN_C struct PerformanceInfo* FIREBIRD_ITraceTransaction_getPerf(struct FIREBIRD_ITraceTransaction* self);
CLOOP_EXTERN_C ISC_INT64 FIREBIRD_ITraceTransaction_getInitialID(struct FIREBIRD_ITraceTransaction* self);
CLOOP_EXTERN_C ISC_INT64 FIREBIRD_ITraceTransaction_getPreviousID(struct FIREBIRD_ITraceTransaction* self);

#define FIREBIRD_ITraceParams_VERSION 3

struct FIREBIRD_ITraceParams;

struct FIREBIRD_ITraceParamsVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	unsigned (*getCount)(struct FIREBIRD_ITraceParams* self);
	const struct dsc* (*getParam)(struct FIREBIRD_ITraceParams* self, unsigned idx);
	const char* (*getTextUTF8)(struct FIREBIRD_ITraceParams* self, struct FIREBIRD_IStatus* status, unsigned idx);
};

struct FIREBIRD_ITraceParams
{
	void* cloopDummy[1];
	struct FIREBIRD_ITraceParamsVTable* vtable;
};

CLOOP_EXTERN_C unsigned FIREBIRD_ITraceParams_getCount(struct FIREBIRD_ITraceParams* self);
CLOOP_EXTERN_C const struct dsc* FIREBIRD_ITraceParams_getParam(struct FIREBIRD_ITraceParams* self, unsigned idx);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceParams_getTextUTF8(struct FIREBIRD_ITraceParams* self, struct FIREBIRD_IStatus* status, unsigned idx);

#define FIREBIRD_ITraceStatement_VERSION 2

struct FIREBIRD_ITraceStatement;

struct FIREBIRD_ITraceStatementVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	ISC_INT64 (*getStmtID)(struct FIREBIRD_ITraceStatement* self);
	struct PerformanceInfo* (*getPerf)(struct FIREBIRD_ITraceStatement* self);
};

struct FIREBIRD_ITraceStatement
{
	void* cloopDummy[1];
	struct FIREBIRD_ITraceStatementVTable* vtable;
};

CLOOP_EXTERN_C ISC_INT64 FIREBIRD_ITraceStatement_getStmtID(struct FIREBIRD_ITraceStatement* self);
CLOOP_EXTERN_C struct PerformanceInfo* FIREBIRD_ITraceStatement_getPerf(struct FIREBIRD_ITraceStatement* self);

#define FIREBIRD_ITraceSQLStatement_VERSION 3

struct FIREBIRD_ITraceSQLStatement;

struct FIREBIRD_ITraceSQLStatementVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	ISC_INT64 (*getStmtID)(struct FIREBIRD_ITraceSQLStatement* self);
	struct PerformanceInfo* (*getPerf)(struct FIREBIRD_ITraceSQLStatement* self);
	const char* (*getText)(struct FIREBIRD_ITraceSQLStatement* self);
	const char* (*getPlan)(struct FIREBIRD_ITraceSQLStatement* self);
	struct FIREBIRD_ITraceParams* (*getInputs)(struct FIREBIRD_ITraceSQLStatement* self);
	const char* (*getTextUTF8)(struct FIREBIRD_ITraceSQLStatement* self);
	const char* (*getExplainedPlan)(struct FIREBIRD_ITraceSQLStatement* self);
};

struct FIREBIRD_ITraceSQLStatement
{
	void* cloopDummy[1];
	struct FIREBIRD_ITraceSQLStatementVTable* vtable;
};

CLOOP_EXTERN_C ISC_INT64 FIREBIRD_ITraceSQLStatement_getStmtID(struct FIREBIRD_ITraceSQLStatement* self);
CLOOP_EXTERN_C struct PerformanceInfo* FIREBIRD_ITraceSQLStatement_getPerf(struct FIREBIRD_ITraceSQLStatement* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceSQLStatement_getText(struct FIREBIRD_ITraceSQLStatement* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceSQLStatement_getPlan(struct FIREBIRD_ITraceSQLStatement* self);
CLOOP_EXTERN_C struct FIREBIRD_ITraceParams* FIREBIRD_ITraceSQLStatement_getInputs(struct FIREBIRD_ITraceSQLStatement* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceSQLStatement_getTextUTF8(struct FIREBIRD_ITraceSQLStatement* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceSQLStatement_getExplainedPlan(struct FIREBIRD_ITraceSQLStatement* self);

#define FIREBIRD_ITraceBLRStatement_VERSION 3

struct FIREBIRD_ITraceBLRStatement;

struct FIREBIRD_ITraceBLRStatementVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	ISC_INT64 (*getStmtID)(struct FIREBIRD_ITraceBLRStatement* self);
	struct PerformanceInfo* (*getPerf)(struct FIREBIRD_ITraceBLRStatement* self);
	const unsigned char* (*getData)(struct FIREBIRD_ITraceBLRStatement* self);
	unsigned (*getDataLength)(struct FIREBIRD_ITraceBLRStatement* self);
	const char* (*getText)(struct FIREBIRD_ITraceBLRStatement* self);
};

struct FIREBIRD_ITraceBLRStatement
{
	void* cloopDummy[1];
	struct FIREBIRD_ITraceBLRStatementVTable* vtable;
};

CLOOP_EXTERN_C ISC_INT64 FIREBIRD_ITraceBLRStatement_getStmtID(struct FIREBIRD_ITraceBLRStatement* self);
CLOOP_EXTERN_C struct PerformanceInfo* FIREBIRD_ITraceBLRStatement_getPerf(struct FIREBIRD_ITraceBLRStatement* self);
CLOOP_EXTERN_C const unsigned char* FIREBIRD_ITraceBLRStatement_getData(struct FIREBIRD_ITraceBLRStatement* self);
CLOOP_EXTERN_C unsigned FIREBIRD_ITraceBLRStatement_getDataLength(struct FIREBIRD_ITraceBLRStatement* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceBLRStatement_getText(struct FIREBIRD_ITraceBLRStatement* self);

#define FIREBIRD_ITraceDYNRequest_VERSION 2

struct FIREBIRD_ITraceDYNRequest;

struct FIREBIRD_ITraceDYNRequestVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	const unsigned char* (*getData)(struct FIREBIRD_ITraceDYNRequest* self);
	unsigned (*getDataLength)(struct FIREBIRD_ITraceDYNRequest* self);
	const char* (*getText)(struct FIREBIRD_ITraceDYNRequest* self);
};

struct FIREBIRD_ITraceDYNRequest
{
	void* cloopDummy[1];
	struct FIREBIRD_ITraceDYNRequestVTable* vtable;
};

CLOOP_EXTERN_C const unsigned char* FIREBIRD_ITraceDYNRequest_getData(struct FIREBIRD_ITraceDYNRequest* self);
CLOOP_EXTERN_C unsigned FIREBIRD_ITraceDYNRequest_getDataLength(struct FIREBIRD_ITraceDYNRequest* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceDYNRequest_getText(struct FIREBIRD_ITraceDYNRequest* self);

#define FIREBIRD_ITraceContextVariable_VERSION 2

struct FIREBIRD_ITraceContextVariable;

struct FIREBIRD_ITraceContextVariableVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	const char* (*getNameSpace)(struct FIREBIRD_ITraceContextVariable* self);
	const char* (*getVarName)(struct FIREBIRD_ITraceContextVariable* self);
	const char* (*getVarValue)(struct FIREBIRD_ITraceContextVariable* self);
};

struct FIREBIRD_ITraceContextVariable
{
	void* cloopDummy[1];
	struct FIREBIRD_ITraceContextVariableVTable* vtable;
};

CLOOP_EXTERN_C const char* FIREBIRD_ITraceContextVariable_getNameSpace(struct FIREBIRD_ITraceContextVariable* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceContextVariable_getVarName(struct FIREBIRD_ITraceContextVariable* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceContextVariable_getVarValue(struct FIREBIRD_ITraceContextVariable* self);

#define FIREBIRD_ITraceProcedure_VERSION 2

struct FIREBIRD_ITraceProcedure;

struct FIREBIRD_ITraceProcedureVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	const char* (*getProcName)(struct FIREBIRD_ITraceProcedure* self);
	struct FIREBIRD_ITraceParams* (*getInputs)(struct FIREBIRD_ITraceProcedure* self);
	struct PerformanceInfo* (*getPerf)(struct FIREBIRD_ITraceProcedure* self);
};

struct FIREBIRD_ITraceProcedure
{
	void* cloopDummy[1];
	struct FIREBIRD_ITraceProcedureVTable* vtable;
};

CLOOP_EXTERN_C const char* FIREBIRD_ITraceProcedure_getProcName(struct FIREBIRD_ITraceProcedure* self);
CLOOP_EXTERN_C struct FIREBIRD_ITraceParams* FIREBIRD_ITraceProcedure_getInputs(struct FIREBIRD_ITraceProcedure* self);
CLOOP_EXTERN_C struct PerformanceInfo* FIREBIRD_ITraceProcedure_getPerf(struct FIREBIRD_ITraceProcedure* self);

#define FIREBIRD_ITraceFunction_VERSION 2

struct FIREBIRD_ITraceFunction;

struct FIREBIRD_ITraceFunctionVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	const char* (*getFuncName)(struct FIREBIRD_ITraceFunction* self);
	struct FIREBIRD_ITraceParams* (*getInputs)(struct FIREBIRD_ITraceFunction* self);
	struct FIREBIRD_ITraceParams* (*getResult)(struct FIREBIRD_ITraceFunction* self);
	struct PerformanceInfo* (*getPerf)(struct FIREBIRD_ITraceFunction* self);
};

struct FIREBIRD_ITraceFunction
{
	void* cloopDummy[1];
	struct FIREBIRD_ITraceFunctionVTable* vtable;
};

CLOOP_EXTERN_C const char* FIREBIRD_ITraceFunction_getFuncName(struct FIREBIRD_ITraceFunction* self);
CLOOP_EXTERN_C struct FIREBIRD_ITraceParams* FIREBIRD_ITraceFunction_getInputs(struct FIREBIRD_ITraceFunction* self);
CLOOP_EXTERN_C struct FIREBIRD_ITraceParams* FIREBIRD_ITraceFunction_getResult(struct FIREBIRD_ITraceFunction* self);
CLOOP_EXTERN_C struct PerformanceInfo* FIREBIRD_ITraceFunction_getPerf(struct FIREBIRD_ITraceFunction* self);

#define FIREBIRD_ITraceTrigger_VERSION 2

#define FIREBIRD_ITraceTrigger_TYPE_ALL ((unsigned) (0))
#define FIREBIRD_ITraceTrigger_TYPE_BEFORE ((unsigned) (1))
#define FIREBIRD_ITraceTrigger_TYPE_AFTER ((unsigned) (2))

struct FIREBIRD_ITraceTrigger;

struct FIREBIRD_ITraceTriggerVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	const char* (*getTriggerName)(struct FIREBIRD_ITraceTrigger* self);
	const char* (*getRelationName)(struct FIREBIRD_ITraceTrigger* self);
	int (*getAction)(struct FIREBIRD_ITraceTrigger* self);
	int (*getWhich)(struct FIREBIRD_ITraceTrigger* self);
	struct PerformanceInfo* (*getPerf)(struct FIREBIRD_ITraceTrigger* self);
};

struct FIREBIRD_ITraceTrigger
{
	void* cloopDummy[1];
	struct FIREBIRD_ITraceTriggerVTable* vtable;
};

CLOOP_EXTERN_C const char* FIREBIRD_ITraceTrigger_getTriggerName(struct FIREBIRD_ITraceTrigger* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceTrigger_getRelationName(struct FIREBIRD_ITraceTrigger* self);
CLOOP_EXTERN_C int FIREBIRD_ITraceTrigger_getAction(struct FIREBIRD_ITraceTrigger* self);
CLOOP_EXTERN_C int FIREBIRD_ITraceTrigger_getWhich(struct FIREBIRD_ITraceTrigger* self);
CLOOP_EXTERN_C struct PerformanceInfo* FIREBIRD_ITraceTrigger_getPerf(struct FIREBIRD_ITraceTrigger* self);

#define FIREBIRD_ITraceServiceConnection_VERSION 3

struct FIREBIRD_ITraceServiceConnection;

struct FIREBIRD_ITraceServiceConnectionVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	unsigned (*getKind)(struct FIREBIRD_ITraceServiceConnection* self);
	int (*getProcessID)(struct FIREBIRD_ITraceServiceConnection* self);
	const char* (*getUserName)(struct FIREBIRD_ITraceServiceConnection* self);
	const char* (*getRoleName)(struct FIREBIRD_ITraceServiceConnection* self);
	const char* (*getCharSet)(struct FIREBIRD_ITraceServiceConnection* self);
	const char* (*getRemoteProtocol)(struct FIREBIRD_ITraceServiceConnection* self);
	const char* (*getRemoteAddress)(struct FIREBIRD_ITraceServiceConnection* self);
	int (*getRemoteProcessID)(struct FIREBIRD_ITraceServiceConnection* self);
	const char* (*getRemoteProcessName)(struct FIREBIRD_ITraceServiceConnection* self);
	void* (*getServiceID)(struct FIREBIRD_ITraceServiceConnection* self);
	const char* (*getServiceMgr)(struct FIREBIRD_ITraceServiceConnection* self);
	const char* (*getServiceName)(struct FIREBIRD_ITraceServiceConnection* self);
};

struct FIREBIRD_ITraceServiceConnection
{
	void* cloopDummy[1];
	struct FIREBIRD_ITraceServiceConnectionVTable* vtable;
};

CLOOP_EXTERN_C unsigned FIREBIRD_ITraceServiceConnection_getKind(struct FIREBIRD_ITraceServiceConnection* self);
CLOOP_EXTERN_C int FIREBIRD_ITraceServiceConnection_getProcessID(struct FIREBIRD_ITraceServiceConnection* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceServiceConnection_getUserName(struct FIREBIRD_ITraceServiceConnection* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceServiceConnection_getRoleName(struct FIREBIRD_ITraceServiceConnection* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceServiceConnection_getCharSet(struct FIREBIRD_ITraceServiceConnection* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceServiceConnection_getRemoteProtocol(struct FIREBIRD_ITraceServiceConnection* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceServiceConnection_getRemoteAddress(struct FIREBIRD_ITraceServiceConnection* self);
CLOOP_EXTERN_C int FIREBIRD_ITraceServiceConnection_getRemoteProcessID(struct FIREBIRD_ITraceServiceConnection* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceServiceConnection_getRemoteProcessName(struct FIREBIRD_ITraceServiceConnection* self);
CLOOP_EXTERN_C void* FIREBIRD_ITraceServiceConnection_getServiceID(struct FIREBIRD_ITraceServiceConnection* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceServiceConnection_getServiceMgr(struct FIREBIRD_ITraceServiceConnection* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceServiceConnection_getServiceName(struct FIREBIRD_ITraceServiceConnection* self);

#define FIREBIRD_ITraceStatusVector_VERSION 2

struct FIREBIRD_ITraceStatusVector;

struct FIREBIRD_ITraceStatusVectorVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	FB_BOOLEAN (*hasError)(struct FIREBIRD_ITraceStatusVector* self);
	FB_BOOLEAN (*hasWarning)(struct FIREBIRD_ITraceStatusVector* self);
	struct FIREBIRD_IStatus* (*getStatus)(struct FIREBIRD_ITraceStatusVector* self);
	const char* (*getText)(struct FIREBIRD_ITraceStatusVector* self);
};

struct FIREBIRD_ITraceStatusVector
{
	void* cloopDummy[1];
	struct FIREBIRD_ITraceStatusVectorVTable* vtable;
};

CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_ITraceStatusVector_hasError(struct FIREBIRD_ITraceStatusVector* self);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_ITraceStatusVector_hasWarning(struct FIREBIRD_ITraceStatusVector* self);
CLOOP_EXTERN_C struct FIREBIRD_IStatus* FIREBIRD_ITraceStatusVector_getStatus(struct FIREBIRD_ITraceStatusVector* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceStatusVector_getText(struct FIREBIRD_ITraceStatusVector* self);

#define FIREBIRD_ITraceSweepInfo_VERSION 2

struct FIREBIRD_ITraceSweepInfo;

struct FIREBIRD_ITraceSweepInfoVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	ISC_INT64 (*getOIT)(struct FIREBIRD_ITraceSweepInfo* self);
	ISC_INT64 (*getOST)(struct FIREBIRD_ITraceSweepInfo* self);
	ISC_INT64 (*getOAT)(struct FIREBIRD_ITraceSweepInfo* self);
	ISC_INT64 (*getNext)(struct FIREBIRD_ITraceSweepInfo* self);
	struct PerformanceInfo* (*getPerf)(struct FIREBIRD_ITraceSweepInfo* self);
};

struct FIREBIRD_ITraceSweepInfo
{
	void* cloopDummy[1];
	struct FIREBIRD_ITraceSweepInfoVTable* vtable;
};

CLOOP_EXTERN_C ISC_INT64 FIREBIRD_ITraceSweepInfo_getOIT(struct FIREBIRD_ITraceSweepInfo* self);
CLOOP_EXTERN_C ISC_INT64 FIREBIRD_ITraceSweepInfo_getOST(struct FIREBIRD_ITraceSweepInfo* self);
CLOOP_EXTERN_C ISC_INT64 FIREBIRD_ITraceSweepInfo_getOAT(struct FIREBIRD_ITraceSweepInfo* self);
CLOOP_EXTERN_C ISC_INT64 FIREBIRD_ITraceSweepInfo_getNext(struct FIREBIRD_ITraceSweepInfo* self);
CLOOP_EXTERN_C struct PerformanceInfo* FIREBIRD_ITraceSweepInfo_getPerf(struct FIREBIRD_ITraceSweepInfo* self);

#define FIREBIRD_ITraceLogWriter_VERSION 4

struct FIREBIRD_ITraceLogWriter;

struct FIREBIRD_ITraceLogWriterVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_ITraceLogWriter* self);
	int (*release)(struct FIREBIRD_ITraceLogWriter* self);
	unsigned (*write)(struct FIREBIRD_ITraceLogWriter* self, const void* buf, unsigned size);
	unsigned (*write_s)(struct FIREBIRD_ITraceLogWriter* self, struct FIREBIRD_IStatus* status, const void* buf, unsigned size);
};

struct FIREBIRD_ITraceLogWriter
{
	void* cloopDummy[1];
	struct FIREBIRD_ITraceLogWriterVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_ITraceLogWriter_addRef(struct FIREBIRD_ITraceLogWriter* self);
CLOOP_EXTERN_C int FIREBIRD_ITraceLogWriter_release(struct FIREBIRD_ITraceLogWriter* self);
CLOOP_EXTERN_C unsigned FIREBIRD_ITraceLogWriter_write(struct FIREBIRD_ITraceLogWriter* self, const void* buf, unsigned size);
CLOOP_EXTERN_C unsigned FIREBIRD_ITraceLogWriter_write_s(struct FIREBIRD_ITraceLogWriter* self, struct FIREBIRD_IStatus* status, const void* buf, unsigned size);

#define FIREBIRD_ITraceInitInfo_VERSION 2

struct FIREBIRD_ITraceInitInfo;

struct FIREBIRD_ITraceInitInfoVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	const char* (*getConfigText)(struct FIREBIRD_ITraceInitInfo* self);
	int (*getTraceSessionID)(struct FIREBIRD_ITraceInitInfo* self);
	const char* (*getTraceSessionName)(struct FIREBIRD_ITraceInitInfo* self);
	const char* (*getFirebirdRootDirectory)(struct FIREBIRD_ITraceInitInfo* self);
	const char* (*getDatabaseName)(struct FIREBIRD_ITraceInitInfo* self);
	struct FIREBIRD_ITraceDatabaseConnection* (*getConnection)(struct FIREBIRD_ITraceInitInfo* self);
	struct FIREBIRD_ITraceLogWriter* (*getLogWriter)(struct FIREBIRD_ITraceInitInfo* self);
};

struct FIREBIRD_ITraceInitInfo
{
	void* cloopDummy[1];
	struct FIREBIRD_ITraceInitInfoVTable* vtable;
};

CLOOP_EXTERN_C const char* FIREBIRD_ITraceInitInfo_getConfigText(struct FIREBIRD_ITraceInitInfo* self);
CLOOP_EXTERN_C int FIREBIRD_ITraceInitInfo_getTraceSessionID(struct FIREBIRD_ITraceInitInfo* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceInitInfo_getTraceSessionName(struct FIREBIRD_ITraceInitInfo* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceInitInfo_getFirebirdRootDirectory(struct FIREBIRD_ITraceInitInfo* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITraceInitInfo_getDatabaseName(struct FIREBIRD_ITraceInitInfo* self);
CLOOP_EXTERN_C struct FIREBIRD_ITraceDatabaseConnection* FIREBIRD_ITraceInitInfo_getConnection(struct FIREBIRD_ITraceInitInfo* self);
CLOOP_EXTERN_C struct FIREBIRD_ITraceLogWriter* FIREBIRD_ITraceInitInfo_getLogWriter(struct FIREBIRD_ITraceInitInfo* self);

#define FIREBIRD_ITracePlugin_VERSION 3

#define FIREBIRD_ITracePlugin_RESULT_SUCCESS ((unsigned) (0))
#define FIREBIRD_ITracePlugin_RESULT_FAILED ((unsigned) (1))
#define FIREBIRD_ITracePlugin_RESULT_UNAUTHORIZED ((unsigned) (2))
#define FIREBIRD_ITracePlugin_SWEEP_STATE_STARTED ((unsigned) (1))
#define FIREBIRD_ITracePlugin_SWEEP_STATE_FINISHED ((unsigned) (2))
#define FIREBIRD_ITracePlugin_SWEEP_STATE_FAILED ((unsigned) (3))
#define FIREBIRD_ITracePlugin_SWEEP_STATE_PROGRESS ((unsigned) (4))

struct FIREBIRD_ITracePlugin;

struct FIREBIRD_ITracePluginVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_ITracePlugin* self);
	int (*release)(struct FIREBIRD_ITracePlugin* self);
	const char* (*trace_get_error)(struct FIREBIRD_ITracePlugin* self);
	FB_BOOLEAN (*trace_attach)(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, FB_BOOLEAN create_db, unsigned att_result);
	FB_BOOLEAN (*trace_detach)(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, FB_BOOLEAN drop_db);
	FB_BOOLEAN (*trace_transaction_start)(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, struct FIREBIRD_ITraceTransaction* transaction, unsigned tpb_length, const unsigned char* tpb, unsigned tra_result);
	FB_BOOLEAN (*trace_transaction_end)(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, struct FIREBIRD_ITraceTransaction* transaction, FB_BOOLEAN commit, FB_BOOLEAN retain_context, unsigned tra_result);
	FB_BOOLEAN (*trace_proc_execute)(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, struct FIREBIRD_ITraceTransaction* transaction, struct FIREBIRD_ITraceProcedure* procedure, FB_BOOLEAN started, unsigned proc_result);
	FB_BOOLEAN (*trace_trigger_execute)(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, struct FIREBIRD_ITraceTransaction* transaction, struct FIREBIRD_ITraceTrigger* trigger, FB_BOOLEAN started, unsigned trig_result);
	FB_BOOLEAN (*trace_set_context)(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, struct FIREBIRD_ITraceTransaction* transaction, struct FIREBIRD_ITraceContextVariable* variable);
	FB_BOOLEAN (*trace_dsql_prepare)(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, struct FIREBIRD_ITraceTransaction* transaction, struct FIREBIRD_ITraceSQLStatement* statement, ISC_INT64 time_millis, unsigned req_result);
	FB_BOOLEAN (*trace_dsql_free)(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, struct FIREBIRD_ITraceSQLStatement* statement, unsigned option);
	FB_BOOLEAN (*trace_dsql_execute)(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, struct FIREBIRD_ITraceTransaction* transaction, struct FIREBIRD_ITraceSQLStatement* statement, FB_BOOLEAN started, unsigned req_result);
	FB_BOOLEAN (*trace_blr_compile)(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, struct FIREBIRD_ITraceTransaction* transaction, struct FIREBIRD_ITraceBLRStatement* statement, ISC_INT64 time_millis, unsigned req_result);
	FB_BOOLEAN (*trace_blr_execute)(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, struct FIREBIRD_ITraceTransaction* transaction, struct FIREBIRD_ITraceBLRStatement* statement, unsigned req_result);
	FB_BOOLEAN (*trace_dyn_execute)(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, struct FIREBIRD_ITraceTransaction* transaction, struct FIREBIRD_ITraceDYNRequest* request, ISC_INT64 time_millis, unsigned req_result);
	FB_BOOLEAN (*trace_service_attach)(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceServiceConnection* service, unsigned att_result);
	FB_BOOLEAN (*trace_service_start)(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceServiceConnection* service, unsigned switches_length, const char* switches, unsigned start_result);
	FB_BOOLEAN (*trace_service_query)(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceServiceConnection* service, unsigned send_item_length, const unsigned char* send_items, unsigned recv_item_length, const unsigned char* recv_items, unsigned query_result);
	FB_BOOLEAN (*trace_service_detach)(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceServiceConnection* service, unsigned detach_result);
	FB_BOOLEAN (*trace_event_error)(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceConnection* connection, struct FIREBIRD_ITraceStatusVector* status, const char* function);
	FB_BOOLEAN (*trace_event_sweep)(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, struct FIREBIRD_ITraceSweepInfo* sweep, unsigned sweep_state);
	FB_BOOLEAN (*trace_func_execute)(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, struct FIREBIRD_ITraceTransaction* transaction, struct FIREBIRD_ITraceFunction* function, FB_BOOLEAN started, unsigned func_result);
};

struct FIREBIRD_ITracePlugin
{
	void* cloopDummy[1];
	struct FIREBIRD_ITracePluginVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_ITracePlugin_addRef(struct FIREBIRD_ITracePlugin* self);
CLOOP_EXTERN_C int FIREBIRD_ITracePlugin_release(struct FIREBIRD_ITracePlugin* self);
CLOOP_EXTERN_C const char* FIREBIRD_ITracePlugin_trace_get_error(struct FIREBIRD_ITracePlugin* self);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_ITracePlugin_trace_attach(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, FB_BOOLEAN create_db, unsigned att_result);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_ITracePlugin_trace_detach(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, FB_BOOLEAN drop_db);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_ITracePlugin_trace_transaction_start(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, struct FIREBIRD_ITraceTransaction* transaction, unsigned tpb_length, const unsigned char* tpb, unsigned tra_result);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_ITracePlugin_trace_transaction_end(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, struct FIREBIRD_ITraceTransaction* transaction, FB_BOOLEAN commit, FB_BOOLEAN retain_context, unsigned tra_result);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_ITracePlugin_trace_proc_execute(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, struct FIREBIRD_ITraceTransaction* transaction, struct FIREBIRD_ITraceProcedure* procedure, FB_BOOLEAN started, unsigned proc_result);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_ITracePlugin_trace_trigger_execute(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, struct FIREBIRD_ITraceTransaction* transaction, struct FIREBIRD_ITraceTrigger* trigger, FB_BOOLEAN started, unsigned trig_result);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_ITracePlugin_trace_set_context(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, struct FIREBIRD_ITraceTransaction* transaction, struct FIREBIRD_ITraceContextVariable* variable);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_ITracePlugin_trace_dsql_prepare(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, struct FIREBIRD_ITraceTransaction* transaction, struct FIREBIRD_ITraceSQLStatement* statement, ISC_INT64 time_millis, unsigned req_result);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_ITracePlugin_trace_dsql_free(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, struct FIREBIRD_ITraceSQLStatement* statement, unsigned option);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_ITracePlugin_trace_dsql_execute(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, struct FIREBIRD_ITraceTransaction* transaction, struct FIREBIRD_ITraceSQLStatement* statement, FB_BOOLEAN started, unsigned req_result);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_ITracePlugin_trace_blr_compile(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, struct FIREBIRD_ITraceTransaction* transaction, struct FIREBIRD_ITraceBLRStatement* statement, ISC_INT64 time_millis, unsigned req_result);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_ITracePlugin_trace_blr_execute(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, struct FIREBIRD_ITraceTransaction* transaction, struct FIREBIRD_ITraceBLRStatement* statement, unsigned req_result);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_ITracePlugin_trace_dyn_execute(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, struct FIREBIRD_ITraceTransaction* transaction, struct FIREBIRD_ITraceDYNRequest* request, ISC_INT64 time_millis, unsigned req_result);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_ITracePlugin_trace_service_attach(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceServiceConnection* service, unsigned att_result);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_ITracePlugin_trace_service_start(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceServiceConnection* service, unsigned switches_length, const char* switches, unsigned start_result);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_ITracePlugin_trace_service_query(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceServiceConnection* service, unsigned send_item_length, const unsigned char* send_items, unsigned recv_item_length, const unsigned char* recv_items, unsigned query_result);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_ITracePlugin_trace_service_detach(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceServiceConnection* service, unsigned detach_result);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_ITracePlugin_trace_event_error(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceConnection* connection, struct FIREBIRD_ITraceStatusVector* status, const char* function);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_ITracePlugin_trace_event_sweep(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, struct FIREBIRD_ITraceSweepInfo* sweep, unsigned sweep_state);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_ITracePlugin_trace_func_execute(struct FIREBIRD_ITracePlugin* self, struct FIREBIRD_ITraceDatabaseConnection* connection, struct FIREBIRD_ITraceTransaction* transaction, struct FIREBIRD_ITraceFunction* function, FB_BOOLEAN started, unsigned func_result);

#define FIREBIRD_ITraceFactory_VERSION 4

#define FIREBIRD_ITraceFactory_TRACE_EVENT_ATTACH ((unsigned) (0))
#define FIREBIRD_ITraceFactory_TRACE_EVENT_DETACH ((unsigned) (1))
#define FIREBIRD_ITraceFactory_TRACE_EVENT_TRANSACTION_START ((unsigned) (2))
#define FIREBIRD_ITraceFactory_TRACE_EVENT_TRANSACTION_END ((unsigned) (3))
#define FIREBIRD_ITraceFactory_TRACE_EVENT_SET_CONTEXT ((unsigned) (4))
#define FIREBIRD_ITraceFactory_TRACE_EVENT_PROC_EXECUTE ((unsigned) (5))
#define FIREBIRD_ITraceFactory_TRACE_EVENT_TRIGGER_EXECUTE ((unsigned) (6))
#define FIREBIRD_ITraceFactory_TRACE_EVENT_DSQL_PREPARE ((unsigned) (7))
#define FIREBIRD_ITraceFactory_TRACE_EVENT_DSQL_FREE ((unsigned) (8))
#define FIREBIRD_ITraceFactory_TRACE_EVENT_DSQL_EXECUTE ((unsigned) (9))
#define FIREBIRD_ITraceFactory_TRACE_EVENT_BLR_COMPILE ((unsigned) (10))
#define FIREBIRD_ITraceFactory_TRACE_EVENT_BLR_EXECUTE ((unsigned) (11))
#define FIREBIRD_ITraceFactory_TRACE_EVENT_DYN_EXECUTE ((unsigned) (12))
#define FIREBIRD_ITraceFactory_TRACE_EVENT_SERVICE_ATTACH ((unsigned) (13))
#define FIREBIRD_ITraceFactory_TRACE_EVENT_SERVICE_START ((unsigned) (14))
#define FIREBIRD_ITraceFactory_TRACE_EVENT_SERVICE_QUERY ((unsigned) (15))
#define FIREBIRD_ITraceFactory_TRACE_EVENT_SERVICE_DETACH ((unsigned) (16))
#define FIREBIRD_ITraceFactory_TRACE_EVENT_ERROR ((unsigned) (17))
#define FIREBIRD_ITraceFactory_TRACE_EVENT_SWEEP ((unsigned) (18))
#define FIREBIRD_ITraceFactory_TRACE_EVENT_FUNC_EXECUTE ((unsigned) (19))
#define FIREBIRD_ITraceFactory_TRACE_EVENT_MAX ((unsigned) (20))

struct FIREBIRD_ITraceFactory;

struct FIREBIRD_ITraceFactoryVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_ITraceFactory* self);
	int (*release)(struct FIREBIRD_ITraceFactory* self);
	void (*setOwner)(struct FIREBIRD_ITraceFactory* self, struct FIREBIRD_IReferenceCounted* r);
	struct FIREBIRD_IReferenceCounted* (*getOwner)(struct FIREBIRD_ITraceFactory* self);
	ISC_UINT64 (*trace_needs)(struct FIREBIRD_ITraceFactory* self);
	struct FIREBIRD_ITracePlugin* (*trace_create)(struct FIREBIRD_ITraceFactory* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITraceInitInfo* init_info);
};

struct FIREBIRD_ITraceFactory
{
	void* cloopDummy[1];
	struct FIREBIRD_ITraceFactoryVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_ITraceFactory_addRef(struct FIREBIRD_ITraceFactory* self);
CLOOP_EXTERN_C int FIREBIRD_ITraceFactory_release(struct FIREBIRD_ITraceFactory* self);
CLOOP_EXTERN_C void FIREBIRD_ITraceFactory_setOwner(struct FIREBIRD_ITraceFactory* self, struct FIREBIRD_IReferenceCounted* r);
CLOOP_EXTERN_C struct FIREBIRD_IReferenceCounted* FIREBIRD_ITraceFactory_getOwner(struct FIREBIRD_ITraceFactory* self);
CLOOP_EXTERN_C ISC_UINT64 FIREBIRD_ITraceFactory_trace_needs(struct FIREBIRD_ITraceFactory* self);
CLOOP_EXTERN_C struct FIREBIRD_ITracePlugin* FIREBIRD_ITraceFactory_trace_create(struct FIREBIRD_ITraceFactory* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITraceInitInfo* init_info);

#define FIREBIRD_IUdrFunctionFactory_VERSION 3

struct FIREBIRD_IUdrFunctionFactory;

struct FIREBIRD_IUdrFunctionFactoryVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*dispose)(struct FIREBIRD_IUdrFunctionFactory* self);
	void (*setup)(struct FIREBIRD_IUdrFunctionFactory* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, struct FIREBIRD_IRoutineMetadata* metadata, struct FIREBIRD_IMetadataBuilder* inBuilder, struct FIREBIRD_IMetadataBuilder* outBuilder);
	struct FIREBIRD_IExternalFunction* (*newItem)(struct FIREBIRD_IUdrFunctionFactory* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, struct FIREBIRD_IRoutineMetadata* metadata);
};

struct FIREBIRD_IUdrFunctionFactory
{
	void* cloopDummy[1];
	struct FIREBIRD_IUdrFunctionFactoryVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IUdrFunctionFactory_dispose(struct FIREBIRD_IUdrFunctionFactory* self);
CLOOP_EXTERN_C void FIREBIRD_IUdrFunctionFactory_setup(struct FIREBIRD_IUdrFunctionFactory* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, struct FIREBIRD_IRoutineMetadata* metadata, struct FIREBIRD_IMetadataBuilder* inBuilder, struct FIREBIRD_IMetadataBuilder* outBuilder);
CLOOP_EXTERN_C struct FIREBIRD_IExternalFunction* FIREBIRD_IUdrFunctionFactory_newItem(struct FIREBIRD_IUdrFunctionFactory* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, struct FIREBIRD_IRoutineMetadata* metadata);

#define FIREBIRD_IUdrProcedureFactory_VERSION 3

struct FIREBIRD_IUdrProcedureFactory;

struct FIREBIRD_IUdrProcedureFactoryVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*dispose)(struct FIREBIRD_IUdrProcedureFactory* self);
	void (*setup)(struct FIREBIRD_IUdrProcedureFactory* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, struct FIREBIRD_IRoutineMetadata* metadata, struct FIREBIRD_IMetadataBuilder* inBuilder, struct FIREBIRD_IMetadataBuilder* outBuilder);
	struct FIREBIRD_IExternalProcedure* (*newItem)(struct FIREBIRD_IUdrProcedureFactory* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, struct FIREBIRD_IRoutineMetadata* metadata);
};

struct FIREBIRD_IUdrProcedureFactory
{
	void* cloopDummy[1];
	struct FIREBIRD_IUdrProcedureFactoryVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IUdrProcedureFactory_dispose(struct FIREBIRD_IUdrProcedureFactory* self);
CLOOP_EXTERN_C void FIREBIRD_IUdrProcedureFactory_setup(struct FIREBIRD_IUdrProcedureFactory* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, struct FIREBIRD_IRoutineMetadata* metadata, struct FIREBIRD_IMetadataBuilder* inBuilder, struct FIREBIRD_IMetadataBuilder* outBuilder);
CLOOP_EXTERN_C struct FIREBIRD_IExternalProcedure* FIREBIRD_IUdrProcedureFactory_newItem(struct FIREBIRD_IUdrProcedureFactory* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, struct FIREBIRD_IRoutineMetadata* metadata);

#define FIREBIRD_IUdrTriggerFactory_VERSION 3

struct FIREBIRD_IUdrTriggerFactory;

struct FIREBIRD_IUdrTriggerFactoryVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*dispose)(struct FIREBIRD_IUdrTriggerFactory* self);
	void (*setup)(struct FIREBIRD_IUdrTriggerFactory* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, struct FIREBIRD_IRoutineMetadata* metadata, struct FIREBIRD_IMetadataBuilder* fieldsBuilder);
	struct FIREBIRD_IExternalTrigger* (*newItem)(struct FIREBIRD_IUdrTriggerFactory* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, struct FIREBIRD_IRoutineMetadata* metadata);
};

struct FIREBIRD_IUdrTriggerFactory
{
	void* cloopDummy[1];
	struct FIREBIRD_IUdrTriggerFactoryVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IUdrTriggerFactory_dispose(struct FIREBIRD_IUdrTriggerFactory* self);
CLOOP_EXTERN_C void FIREBIRD_IUdrTriggerFactory_setup(struct FIREBIRD_IUdrTriggerFactory* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, struct FIREBIRD_IRoutineMetadata* metadata, struct FIREBIRD_IMetadataBuilder* fieldsBuilder);
CLOOP_EXTERN_C struct FIREBIRD_IExternalTrigger* FIREBIRD_IUdrTriggerFactory_newItem(struct FIREBIRD_IUdrTriggerFactory* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IExternalContext* context, struct FIREBIRD_IRoutineMetadata* metadata);

#define FIREBIRD_IUdrPlugin_VERSION 2

struct FIREBIRD_IUdrPlugin;

struct FIREBIRD_IUdrPluginVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	struct FIREBIRD_IMaster* (*getMaster)(struct FIREBIRD_IUdrPlugin* self);
	void (*registerFunction)(struct FIREBIRD_IUdrPlugin* self, struct FIREBIRD_IStatus* status, const char* name, struct FIREBIRD_IUdrFunctionFactory* factory);
	void (*registerProcedure)(struct FIREBIRD_IUdrPlugin* self, struct FIREBIRD_IStatus* status, const char* name, struct FIREBIRD_IUdrProcedureFactory* factory);
	void (*registerTrigger)(struct FIREBIRD_IUdrPlugin* self, struct FIREBIRD_IStatus* status, const char* name, struct FIREBIRD_IUdrTriggerFactory* factory);
};

struct FIREBIRD_IUdrPlugin
{
	void* cloopDummy[1];
	struct FIREBIRD_IUdrPluginVTable* vtable;
};

CLOOP_EXTERN_C struct FIREBIRD_IMaster* FIREBIRD_IUdrPlugin_getMaster(struct FIREBIRD_IUdrPlugin* self);
CLOOP_EXTERN_C void FIREBIRD_IUdrPlugin_registerFunction(struct FIREBIRD_IUdrPlugin* self, struct FIREBIRD_IStatus* status, const char* name, struct FIREBIRD_IUdrFunctionFactory* factory);
CLOOP_EXTERN_C void FIREBIRD_IUdrPlugin_registerProcedure(struct FIREBIRD_IUdrPlugin* self, struct FIREBIRD_IStatus* status, const char* name, struct FIREBIRD_IUdrProcedureFactory* factory);
CLOOP_EXTERN_C void FIREBIRD_IUdrPlugin_registerTrigger(struct FIREBIRD_IUdrPlugin* self, struct FIREBIRD_IStatus* status, const char* name, struct FIREBIRD_IUdrTriggerFactory* factory);

#define FIREBIRD_IDecFloat16_VERSION 2

#define FIREBIRD_IDecFloat16_BCD_SIZE ((unsigned) (16))
#define FIREBIRD_IDecFloat16_STRING_SIZE ((unsigned) (24))

struct FIREBIRD_IDecFloat16;

struct FIREBIRD_IDecFloat16VTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*toBcd)(struct FIREBIRD_IDecFloat16* self, const FB_DEC16* from, int* sign, unsigned char* bcd, int* exp);
	void (*toString)(struct FIREBIRD_IDecFloat16* self, struct FIREBIRD_IStatus* status, const FB_DEC16* from, unsigned bufferLength, char* buffer);
	void (*fromBcd)(struct FIREBIRD_IDecFloat16* self, int sign, const unsigned char* bcd, int exp, FB_DEC16* to);
	void (*fromString)(struct FIREBIRD_IDecFloat16* self, struct FIREBIRD_IStatus* status, const char* from, FB_DEC16* to);
};

struct FIREBIRD_IDecFloat16
{
	void* cloopDummy[1];
	struct FIREBIRD_IDecFloat16VTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IDecFloat16_toBcd(struct FIREBIRD_IDecFloat16* self, const FB_DEC16* from, int* sign, unsigned char* bcd, int* exp);
CLOOP_EXTERN_C void FIREBIRD_IDecFloat16_toString(struct FIREBIRD_IDecFloat16* self, struct FIREBIRD_IStatus* status, const FB_DEC16* from, unsigned bufferLength, char* buffer);
CLOOP_EXTERN_C void FIREBIRD_IDecFloat16_fromBcd(struct FIREBIRD_IDecFloat16* self, int sign, const unsigned char* bcd, int exp, FB_DEC16* to);
CLOOP_EXTERN_C void FIREBIRD_IDecFloat16_fromString(struct FIREBIRD_IDecFloat16* self, struct FIREBIRD_IStatus* status, const char* from, FB_DEC16* to);

#define FIREBIRD_IDecFloat34_VERSION 2

#define FIREBIRD_IDecFloat34_BCD_SIZE ((unsigned) (34))
#define FIREBIRD_IDecFloat34_STRING_SIZE ((unsigned) (43))

struct FIREBIRD_IDecFloat34;

struct FIREBIRD_IDecFloat34VTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*toBcd)(struct FIREBIRD_IDecFloat34* self, const FB_DEC34* from, int* sign, unsigned char* bcd, int* exp);
	void (*toString)(struct FIREBIRD_IDecFloat34* self, struct FIREBIRD_IStatus* status, const FB_DEC34* from, unsigned bufferLength, char* buffer);
	void (*fromBcd)(struct FIREBIRD_IDecFloat34* self, int sign, const unsigned char* bcd, int exp, FB_DEC34* to);
	void (*fromString)(struct FIREBIRD_IDecFloat34* self, struct FIREBIRD_IStatus* status, const char* from, FB_DEC34* to);
};

struct FIREBIRD_IDecFloat34
{
	void* cloopDummy[1];
	struct FIREBIRD_IDecFloat34VTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IDecFloat34_toBcd(struct FIREBIRD_IDecFloat34* self, const FB_DEC34* from, int* sign, unsigned char* bcd, int* exp);
CLOOP_EXTERN_C void FIREBIRD_IDecFloat34_toString(struct FIREBIRD_IDecFloat34* self, struct FIREBIRD_IStatus* status, const FB_DEC34* from, unsigned bufferLength, char* buffer);
CLOOP_EXTERN_C void FIREBIRD_IDecFloat34_fromBcd(struct FIREBIRD_IDecFloat34* self, int sign, const unsigned char* bcd, int exp, FB_DEC34* to);
CLOOP_EXTERN_C void FIREBIRD_IDecFloat34_fromString(struct FIREBIRD_IDecFloat34* self, struct FIREBIRD_IStatus* status, const char* from, FB_DEC34* to);

#define FIREBIRD_IInt128_VERSION 2

#define FIREBIRD_IInt128_STRING_SIZE ((unsigned) (46))

struct FIREBIRD_IInt128;

struct FIREBIRD_IInt128VTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*toString)(struct FIREBIRD_IInt128* self, struct FIREBIRD_IStatus* status, const FB_I128* from, int scale, unsigned bufferLength, char* buffer);
	void (*fromString)(struct FIREBIRD_IInt128* self, struct FIREBIRD_IStatus* status, int scale, const char* from, FB_I128* to);
};

struct FIREBIRD_IInt128
{
	void* cloopDummy[1];
	struct FIREBIRD_IInt128VTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IInt128_toString(struct FIREBIRD_IInt128* self, struct FIREBIRD_IStatus* status, const FB_I128* from, int scale, unsigned bufferLength, char* buffer);
CLOOP_EXTERN_C void FIREBIRD_IInt128_fromString(struct FIREBIRD_IInt128* self, struct FIREBIRD_IStatus* status, int scale, const char* from, FB_I128* to);

#define FIREBIRD_IReplicatedField_VERSION 2

struct FIREBIRD_IReplicatedField;

struct FIREBIRD_IReplicatedFieldVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	const char* (*getName)(struct FIREBIRD_IReplicatedField* self);
	unsigned (*getType)(struct FIREBIRD_IReplicatedField* self);
	int (*getSubType)(struct FIREBIRD_IReplicatedField* self);
	int (*getScale)(struct FIREBIRD_IReplicatedField* self);
	unsigned (*getLength)(struct FIREBIRD_IReplicatedField* self);
	unsigned (*getCharSet)(struct FIREBIRD_IReplicatedField* self);
	const void* (*getData)(struct FIREBIRD_IReplicatedField* self);
};

struct FIREBIRD_IReplicatedField
{
	void* cloopDummy[1];
	struct FIREBIRD_IReplicatedFieldVTable* vtable;
};

CLOOP_EXTERN_C const char* FIREBIRD_IReplicatedField_getName(struct FIREBIRD_IReplicatedField* self);
CLOOP_EXTERN_C unsigned FIREBIRD_IReplicatedField_getType(struct FIREBIRD_IReplicatedField* self);
CLOOP_EXTERN_C int FIREBIRD_IReplicatedField_getSubType(struct FIREBIRD_IReplicatedField* self);
CLOOP_EXTERN_C int FIREBIRD_IReplicatedField_getScale(struct FIREBIRD_IReplicatedField* self);
CLOOP_EXTERN_C unsigned FIREBIRD_IReplicatedField_getLength(struct FIREBIRD_IReplicatedField* self);
CLOOP_EXTERN_C unsigned FIREBIRD_IReplicatedField_getCharSet(struct FIREBIRD_IReplicatedField* self);
CLOOP_EXTERN_C const void* FIREBIRD_IReplicatedField_getData(struct FIREBIRD_IReplicatedField* self);

#define FIREBIRD_IReplicatedRecord_VERSION 2

struct FIREBIRD_IReplicatedRecord;

struct FIREBIRD_IReplicatedRecordVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	unsigned (*getCount)(struct FIREBIRD_IReplicatedRecord* self);
	struct FIREBIRD_IReplicatedField* (*getField)(struct FIREBIRD_IReplicatedRecord* self, unsigned index);
	unsigned (*getRawLength)(struct FIREBIRD_IReplicatedRecord* self);
	const unsigned char* (*getRawData)(struct FIREBIRD_IReplicatedRecord* self);
};

struct FIREBIRD_IReplicatedRecord
{
	void* cloopDummy[1];
	struct FIREBIRD_IReplicatedRecordVTable* vtable;
};

CLOOP_EXTERN_C unsigned FIREBIRD_IReplicatedRecord_getCount(struct FIREBIRD_IReplicatedRecord* self);
CLOOP_EXTERN_C struct FIREBIRD_IReplicatedField* FIREBIRD_IReplicatedRecord_getField(struct FIREBIRD_IReplicatedRecord* self, unsigned index);
CLOOP_EXTERN_C unsigned FIREBIRD_IReplicatedRecord_getRawLength(struct FIREBIRD_IReplicatedRecord* self);
CLOOP_EXTERN_C const unsigned char* FIREBIRD_IReplicatedRecord_getRawData(struct FIREBIRD_IReplicatedRecord* self);

#define FIREBIRD_IReplicatedTransaction_VERSION 3

struct FIREBIRD_IReplicatedTransaction;

struct FIREBIRD_IReplicatedTransactionVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*dispose)(struct FIREBIRD_IReplicatedTransaction* self);
	void (*prepare)(struct FIREBIRD_IReplicatedTransaction* self, struct FIREBIRD_IStatus* status);
	void (*commit)(struct FIREBIRD_IReplicatedTransaction* self, struct FIREBIRD_IStatus* status);
	void (*rollback)(struct FIREBIRD_IReplicatedTransaction* self, struct FIREBIRD_IStatus* status);
	void (*startSavepoint)(struct FIREBIRD_IReplicatedTransaction* self, struct FIREBIRD_IStatus* status);
	void (*releaseSavepoint)(struct FIREBIRD_IReplicatedTransaction* self, struct FIREBIRD_IStatus* status);
	void (*rollbackSavepoint)(struct FIREBIRD_IReplicatedTransaction* self, struct FIREBIRD_IStatus* status);
	void (*insertRecord)(struct FIREBIRD_IReplicatedTransaction* self, struct FIREBIRD_IStatus* status, const char* name, struct FIREBIRD_IReplicatedRecord* record);
	void (*updateRecord)(struct FIREBIRD_IReplicatedTransaction* self, struct FIREBIRD_IStatus* status, const char* name, struct FIREBIRD_IReplicatedRecord* orgRecord, struct FIREBIRD_IReplicatedRecord* newRecord);
	void (*deleteRecord)(struct FIREBIRD_IReplicatedTransaction* self, struct FIREBIRD_IStatus* status, const char* name, struct FIREBIRD_IReplicatedRecord* record);
	void (*executeSql)(struct FIREBIRD_IReplicatedTransaction* self, struct FIREBIRD_IStatus* status, const char* sql);
	void (*executeSqlIntl)(struct FIREBIRD_IReplicatedTransaction* self, struct FIREBIRD_IStatus* status, unsigned charset, const char* sql);
};

struct FIREBIRD_IReplicatedTransaction
{
	void* cloopDummy[1];
	struct FIREBIRD_IReplicatedTransactionVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IReplicatedTransaction_dispose(struct FIREBIRD_IReplicatedTransaction* self);
CLOOP_EXTERN_C void FIREBIRD_IReplicatedTransaction_prepare(struct FIREBIRD_IReplicatedTransaction* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IReplicatedTransaction_commit(struct FIREBIRD_IReplicatedTransaction* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IReplicatedTransaction_rollback(struct FIREBIRD_IReplicatedTransaction* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IReplicatedTransaction_startSavepoint(struct FIREBIRD_IReplicatedTransaction* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IReplicatedTransaction_releaseSavepoint(struct FIREBIRD_IReplicatedTransaction* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IReplicatedTransaction_rollbackSavepoint(struct FIREBIRD_IReplicatedTransaction* self, struct FIREBIRD_IStatus* status);
CLOOP_EXTERN_C void FIREBIRD_IReplicatedTransaction_insertRecord(struct FIREBIRD_IReplicatedTransaction* self, struct FIREBIRD_IStatus* status, const char* name, struct FIREBIRD_IReplicatedRecord* record);
CLOOP_EXTERN_C void FIREBIRD_IReplicatedTransaction_updateRecord(struct FIREBIRD_IReplicatedTransaction* self, struct FIREBIRD_IStatus* status, const char* name, struct FIREBIRD_IReplicatedRecord* orgRecord, struct FIREBIRD_IReplicatedRecord* newRecord);
CLOOP_EXTERN_C void FIREBIRD_IReplicatedTransaction_deleteRecord(struct FIREBIRD_IReplicatedTransaction* self, struct FIREBIRD_IStatus* status, const char* name, struct FIREBIRD_IReplicatedRecord* record);
CLOOP_EXTERN_C void FIREBIRD_IReplicatedTransaction_executeSql(struct FIREBIRD_IReplicatedTransaction* self, struct FIREBIRD_IStatus* status, const char* sql);
CLOOP_EXTERN_C void FIREBIRD_IReplicatedTransaction_executeSqlIntl(struct FIREBIRD_IReplicatedTransaction* self, struct FIREBIRD_IStatus* status, unsigned charset, const char* sql);

#define FIREBIRD_IReplicatedSession_VERSION 4

struct FIREBIRD_IReplicatedSession;

struct FIREBIRD_IReplicatedSessionVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct FIREBIRD_IReplicatedSession* self);
	int (*release)(struct FIREBIRD_IReplicatedSession* self);
	void (*setOwner)(struct FIREBIRD_IReplicatedSession* self, struct FIREBIRD_IReferenceCounted* r);
	struct FIREBIRD_IReferenceCounted* (*getOwner)(struct FIREBIRD_IReplicatedSession* self);
	FB_BOOLEAN (*init)(struct FIREBIRD_IReplicatedSession* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IAttachment* attachment);
	struct FIREBIRD_IReplicatedTransaction* (*startTransaction)(struct FIREBIRD_IReplicatedSession* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction, ISC_INT64 number);
	void (*cleanupTransaction)(struct FIREBIRD_IReplicatedSession* self, struct FIREBIRD_IStatus* status, ISC_INT64 number);
	void (*setSequence)(struct FIREBIRD_IReplicatedSession* self, struct FIREBIRD_IStatus* status, const char* name, ISC_INT64 value);
};

struct FIREBIRD_IReplicatedSession
{
	void* cloopDummy[1];
	struct FIREBIRD_IReplicatedSessionVTable* vtable;
};

CLOOP_EXTERN_C void FIREBIRD_IReplicatedSession_addRef(struct FIREBIRD_IReplicatedSession* self);
CLOOP_EXTERN_C int FIREBIRD_IReplicatedSession_release(struct FIREBIRD_IReplicatedSession* self);
CLOOP_EXTERN_C void FIREBIRD_IReplicatedSession_setOwner(struct FIREBIRD_IReplicatedSession* self, struct FIREBIRD_IReferenceCounted* r);
CLOOP_EXTERN_C struct FIREBIRD_IReferenceCounted* FIREBIRD_IReplicatedSession_getOwner(struct FIREBIRD_IReplicatedSession* self);
CLOOP_EXTERN_C FB_BOOLEAN FIREBIRD_IReplicatedSession_init(struct FIREBIRD_IReplicatedSession* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_IAttachment* attachment);
CLOOP_EXTERN_C struct FIREBIRD_IReplicatedTransaction* FIREBIRD_IReplicatedSession_startTransaction(struct FIREBIRD_IReplicatedSession* self, struct FIREBIRD_IStatus* status, struct FIREBIRD_ITransaction* transaction, ISC_INT64 number);
CLOOP_EXTERN_C void FIREBIRD_IReplicatedSession_cleanupTransaction(struct FIREBIRD_IReplicatedSession* self, struct FIREBIRD_IStatus* status, ISC_INT64 number);
CLOOP_EXTERN_C void FIREBIRD_IReplicatedSession_setSequence(struct FIREBIRD_IReplicatedSession* self, struct FIREBIRD_IStatus* status, const char* name, ISC_INT64 value);


#endif	// FIREBIRD_C_API_H
