#ifndef _HITCH_HPP
#define _HITCH_HPP
class SGPropertyNode;
namespace yasim {

class Ground;
class RigidBody;
struct State;

class Hitch {
public:
    Hitch(const char *name);
    ~Hitch();

    // Externally set values
    void setPosition(float* position);
    void setOpen(bool isOpen);
    //void setName(const char *text);

    void setTowLength(float length);
    void setTowElasticConstant(float sc);
    void setTowBreakForce(float bf);
    void setTowWeightPerM(float rw);
    void setWinchMaxSpeed(float mws);
    void setWinchRelSpeed(float rws);
    void setWinchPosition(double *winchPosition); //in global coordinates!
    void setWinchPositionAuto(bool doit);
    void findBestAIObject(bool doit);
    void setWinchInitialTowLength(float length);
    void setWinchPower(float power);
    void setWinchMaxForce(float force);
    void setWinchMaxTowLength(float length);
    void setWinchMinTowLength(float length);
    
    void setGlobalGround(double *global_ground, float *global_vel);

    void getPosition(float* out);
    float getTowLength(void);

    void calcForce(Ground *g_cb, RigidBody* body, State* s);

    // Computed values: total force
    void getForce(float* force, float* off);

    void integrate (float dt);

    const char *getConnectedPropertyNode() const;
    void setConnectedPropertyNode(const char *nodename);

private:
    float _pos[3];
    bool _open;
    float _towLength;
    float _towElasticConstant;
    float _towBrakeForce;
    float _towWeightPerM;
    float _winchMaxSpeed;
    float _winchRelSpeed;
    float _winchInitialTowLength;
    float _winchMaxTowLength;
    float _winchMinTowLength;
    float _winchPower;
    float _winchMaxForce;
    float _winchActualForce;
    double _winchPos[3];
    float _force[3];
    float _forceMagnitude;
    double _global_ground[4];
    float _global_vel[3];
    char _name[256];
    State* _state;
    float _dist;
    SGPropertyNode *_towEndNode;
    const char *_towEndPropertyName;
    bool _towEndIsConnectedToProperty;
    bool _nodeIsMultiplayer;
    bool _nodeIsAiAircraft;
    int _nodeID;
    const char *_ai_MP_callsign;

    float _height_above_ground;
    float _winch_height_above_ground;
    float _loPosFrac;
    float _lowest_tow_height;

    bool _displayed_len_lower_dist_message;
    bool _last_wish;

};

}; // namespace yasim
#endif // _HITCH_HPP
