
extern "C" {
 #include <ftlib.h>
};

using namespace std;

#include <string>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <libgen.h>

#include "flow_procs.h"
#include "flow_error.h"
#include "defs.h"

void usage(string base_name) {
 cout << base_name << " flow-raw-file" << endl;
 exit(0);
};


int main(int argc,char **argv) {
 if (argc!=2) {
  usage(argv[0]);
 };
 char flow_raw_file_full[100];
 struct stat stat_buf;
 char *arg_file=argv[1];
 ftprof ftp;
 if (debug_level>=4) {
  ftprof_start(&ftp);
 };

 sprintf(flow_raw_file_full,"%s%s",flow_work_dir,arg_file);
 if (stat(flow_raw_file_full,&stat_buf)<0) {
  x_error("stat(): %s : %s",strerror(errno),flow_raw_file_full);
 };
 int flow_file_fd;
 if ((flow_file_fd=open(flow_raw_file_full,O_RDONLY))<0) {
  x_error("open(): %s : %s",strerror(errno),flow_raw_file_full);
 };
 
 fts3rec_offsets fo;
 ftio ftio;
 ftver ftv;
 char *rec; 
 
 if (!ft_init(argv[0],&ftio,flow_file_fd,&ftv,&fo)) {
  fterr_errx(1,"ft_init() error for read %s",flow_raw_file_full);
 };

 exporters_vector exporters;
 exporters_vector::iterator curr;
 exporters_vector::iterator last;
 
 bool found;
 
 while ((rec=(char*)ftio_read(&ftio))) {
  u_int32 *ip=(u_int32*)(rec+fo.exaddr);
  found=false;
  curr=exporters.begin();
  last=exporters.end();
  while (curr!=last) {
   if (curr->ip==*ip) {
    found=true;
    break;
   };
   curr++;
  };
  if (!found) {
   exporter exp_s;
   struct ftio exp_file_fd;
   exp_s.ip=*ip;
   exp_s.ftio=exp_file_fd;
   exp_s.count_flows=0;
   exporters.push_back(exp_s);
  };
 };
 if (!exporters.empty()) {
  if (debug_level==5) {
   dump_exporters(&exporters);
  };
 } else {
  x_error("Not found any exporters in raw flows????");
 };

 char *arg=strdup(arg_file);
 char *arg2=strdup(arg_file);
 char *dir_date;
 char *dump_file_name;
 char exp_path[200];
 dir_date=dirname(arg);
 dump_file_name=basename(arg2);
 curr=exporters.begin();
 last=exporters.end();
 while (curr!=last) {    
  string dip;
  ftip_to_dip(&curr->ip,&dip);
  sprintf(exp_path,"%s%s",exporters_dir,dip.c_str());
  if (!check_path(exp_path)) {
   x_error("check_path() error %s : %s",strerror(errno),exp_path);
  };
  sprintf(exp_path,"%s/%s",exp_path,dir_date);
  if (!check_path(exp_path)) {
   x_error("check_path() error %s : %s",strerror(errno),exp_path);
  };
  sprintf(exp_path,"%s/%s",exp_path,dump_file_name);
  struct ftio ftio_out;
  int fd_out;
  if ((fd_out=open(exp_path,O_WRONLY|O_CREAT|O_TRUNC,0644))==-1) {
   x_error("open() error :%s :%s",strerror(errno),exp_path);
  };
  curr->ftio=ftio_out;
  if (!ft_init_w(&curr->ftio,fd_out,&ftv)) {
   fterr_errx(1,"ft_init() error for write %s",exp_path); 
  };
  curr->file_name=strdup(exp_path);
  curr++;
 }; 
  
 ftio_close(&ftio);
 close(flow_file_fd);
 fts3rec_offsets fo_s;
 struct ftio ftio_s;
 ftver ftv_s;
 if ((flow_file_fd=open(flow_raw_file_full,O_RDONLY))<0) {
  x_error("open(): %s : %s",strerror(errno),flow_raw_file_full);
 };
 if (!ft_init(argv[0],&ftio_s,flow_file_fd,&ftv_s,&fo_s)) {
  fterr_errx(1,"ft_init() error for read : %s",flow_raw_file_full);
 };
 
 int64 total_flows=0;
 
 while ((rec=(char *)ftio_read(&ftio_s))) {
  total_flows++;
  string dip;
  u_int32 *ip=(u_int32*)(rec+fo.exaddr);
  bool found=false;
  curr=exporters.begin();
  last=exporters.end();
  while (curr!=last) {
   if (curr->ip==*ip) {
    found=true;
    break;
   };
   curr++;
  };
  if (found) {
   curr->count_flows++;
   if (ftio_write(&curr->ftio,rec)<0) {
    fterr_errx(1,"ftio_write() error");
   };
  } else {
   x_error("corrupted explorer list????????????");
  };
 };
 
 x_debug(5,"Total flows: %i",total_flows);
 for (curr=exporters.begin();curr!=exporters.end();curr++) {
  x_debug(5,"Flows write for %s : %i",curr->file_name.c_str(),curr->count_flows);
  total_flows-=curr->count_flows;
  ftio_close(&curr->ftio);
 };
 if (total_flows!=0) {
  x_debug(1,"ERROR IN ALGORITM??? total_flows!=0");
 } else {
  x_debug(5,"Flows left: %i",total_flows);
 };
 
 if (debug_level>=4) {
  ftprof_end(&ftp,ftio_get_rec_total(&ftio));
  ftprof_print(&ftp,argv[0],stdout); 
 };
 
 ftio_close(&ftio);
 close(flow_file_fd);
 return 0;
};
