import java.io.*;

public class ISO88591TOUTF8 {
    public static void main(String[] argv) throws Throwable {
        if (argv.length != 2) {
            System.out.println("Usage: java ISO88591TOUTF8 fromFile toFile");
            System.exit(-1);
        }

        File file = new File(argv[0]);
        if (!file.exists()) throw new RuntimeException("File not found.");
        long size = file.length();
        byte[] b8859_1 = new byte[(int)size];

        DataInputStream in = new DataInputStream(new FileInputStream(file));
        in.readFully(b8859_1);
        in.close();
        byte[] bUTF8 = (new String(b8859_1,"8859_1")).getBytes("UTF-8");

        FileOutputStream out = new FileOutputStream(argv[1]);
        out.write(bUTF8);
        out.close();
    }
}
