#include "test.h"

//--- Testcases checking try/catch ---//

void t00() throw()
{
  try {}
  catch(A) {}
}
// RES: /
// XES: catch(A)

void t01() throw()
{
  try
    {
      fA();
    }
  catch(A) {}
}
// RES: /
// XES: /

void t02() throw()
{
  try
    {
      fB();
    }
  catch(A) {}
}
// RES: B
// XES: catch(A)

void t03() throw()
{
  try
    {
      fAny();
    }
  catch(A) {}
}
// RES: ...
// XES: /

void t04() throw()
{
  try
    {
      fA();
      fB();
    }
  catch(A) {}
  catch(C) {}
}
// RES: B
// XES: catch(C)

void t05() throw()
{
  try {}
  catch(A)
    {
      throw;
    }
}
// RES: A
// XES: catch(A)

void t06() throw()
{
  try {}
  catch(...) {}
}
// RES: /
// XES: catch(...)

void t07() throw()
{
  try {}
  catch(...)
    {
      throw;
    }
}
// RES: /
// XES: catch(...)

void t08() throw()
{
  try
    {
      fA();
    }
  catch(...) {}
}
// RES: /
// XES: /

void t09() throw()
{
  try
    {
      fAny();
    }
  catch(...) {}
}
// RES: /
// XES: /

void t10() throw()
{
  try
    {
      fA();
    }
  catch(...)
    {
      throw;
    }
}
// RES: A
// XES: /

void t11() throw()
{
  try
    {
      fAny();
    }
  catch(...)
    {
      throw;
    }
}
// RES: ...
// XES: /

void t12() throw()
{
  try
    {
      fA();
      fB();
    }
  catch(A) {}
  catch(...)
    {
      throw;
    }
}
// RES: B
// XES: /

