//--- Testcases for nonstandard calls. ---//

class A {};

class B
{
  public:
    B() throw(A);
    ~B();
    void f();
};

class C
{
  public:
    C();
    ~C() throw(A);
    void f();
};

class D
{
  public:
    void f() throw(A);
};

/* Overloaded function. */
void fn() throw();
void fn(int) throw(A);
void fn(int, int) throw();
void t00() throw()
{
  fn(1); // RES. t00() calls fn(x). <FAILS>
}

/* Operator. */
A operator +(A, A) throw(A);
void t01() throw()
{
  A a;
  a = a + a; // RES: bar() calls operator +(A, A). <FAILS>
}

/* Function pointer. */
void f02() throw()
{
  void (*fp)() throw(A);
  fp(); // RES. t01() calls fp. <FAILS>
}

/* Ctor initializer list. */
A cfA() throw(A);
class Q
{
  public:
    Q() throw() : a(cfA()) {} // RES: Q() calls cfA(). <OK>
    A a;
};

/* Inherited ctor. */
class R : public B
{
  public:
    R() throw(); // RES. R() calls this.B(). <FAILS>
};

/* Ctor of member variable. */
class S
{
  public:
    S() throw(); // RES. S() calls b.B(). <FAILS>
    B b;
};

/* In ctor of local variable. */
void f03() throw()
{
  B b; // RES: zug() calls c.C(). <FAILS>
  b.f();
}

/* In dtor of local variable. */
void f04() throw()
{
  C c; // RES. quz() calls c.~C(). <FAILS>
  c.f();
}

/* Basic template function. */
template <typename T>
void f05(T t) throw()
{
  throw t; // RES: T. <OK>
  cfA(); // RES: A. <OK>
}

/* Template instantiation. */
template <typename T>
void tf(T t) throw()
{
  t.f();
}
void f06()
{
  D d;
  tf(d); // RES. tf<D>() calls D::f(). <FAILS>
}
