pragma Ada_95;
with System;
package ada_main is
   pragma Warnings (Off);

   gnat_argc : Integer;
   gnat_argv : System.Address;
   gnat_envp : System.Address;

   pragma Import (C, gnat_argc);
   pragma Import (C, gnat_argv);
   pragma Import (C, gnat_envp);

   gnat_exit_status : Integer;
   pragma Import (C, gnat_exit_status);

   GNAT_Version : constant String :=
                    "GNAT Version: 4.5.0 20090614 (experimental)" & ASCII.NUL;
   pragma Export (C, GNAT_Version, "__gnat_version");

   Ada_Main_Program_Name : constant String := "_ada_main" & ASCII.NUL;
   pragma Export (C, Ada_Main_Program_Name, "__gnat_ada_main_program_name");

   procedure adafinal;
   pragma Export (C, adafinal, "adafinal");

   procedure adainit;
   pragma Export (C, adainit, "adainit");

   procedure Break_Start;
   pragma Import (C, Break_Start, "__gnat_break_start");

   function main
     (argc : Integer;
      argv : System.Address;
      envp : System.Address)
      return Integer;
   pragma Export (C, main, "main");

   type Version_32 is mod 2 ** 32;
   u00001 : constant Version_32 := 16#476e4640#;
   u00002 : constant Version_32 := 16#6385d640#;
   u00003 : constant Version_32 := 16#4ea93bb8#;
   u00004 : constant Version_32 := 16#28c5f38a#;
   u00005 : constant Version_32 := 16#2d0459d5#;
   u00006 : constant Version_32 := 16#dcf37a1d#;
   u00007 : constant Version_32 := 16#2b00dc1c#;
   u00008 : constant Version_32 := 16#82bd3c91#;
   u00009 : constant Version_32 := 16#9c7dd3ea#;
   u00010 : constant Version_32 := 16#3dc27028#;
   u00011 : constant Version_32 := 16#d0d51bbe#;
   u00012 : constant Version_32 := 16#de4c8cc2#;
   u00013 : constant Version_32 := 16#633f84f7#;
   u00014 : constant Version_32 := 16#ba011fb9#;
   u00015 : constant Version_32 := 16#e3d85f73#;
   u00016 : constant Version_32 := 16#83f59500#;
   u00017 : constant Version_32 := 16#63a35e59#;
   u00018 : constant Version_32 := 16#1f4497ab#;
   u00019 : constant Version_32 := 16#2ea84b20#;
   u00020 : constant Version_32 := 16#70dbc3e9#;
   u00021 : constant Version_32 := 16#18c4823a#;
   u00022 : constant Version_32 := 16#f5e3bedd#;
   u00023 : constant Version_32 := 16#bcda8803#;
   u00024 : constant Version_32 := 16#2720e926#;
   u00025 : constant Version_32 := 16#892f4d5b#;
   u00026 : constant Version_32 := 16#6f3f77bb#;
   u00027 : constant Version_32 := 16#2f60aa04#;
   u00028 : constant Version_32 := 16#54367357#;
   u00029 : constant Version_32 := 16#c325b17e#;
   u00030 : constant Version_32 := 16#db404f38#;
   u00031 : constant Version_32 := 16#88c8686c#;
   u00032 : constant Version_32 := 16#c7aadac4#;
   u00033 : constant Version_32 := 16#6997f8be#;
   u00034 : constant Version_32 := 16#00b27d4a#;
   u00035 : constant Version_32 := 16#430c6fe5#;
   u00036 : constant Version_32 := 16#08a5f9f2#;
   u00037 : constant Version_32 := 16#b33118c1#;
   u00038 : constant Version_32 := 16#776b72d1#;
   u00039 : constant Version_32 := 16#37465730#;
   u00040 : constant Version_32 := 16#22417946#;
   u00041 : constant Version_32 := 16#18d15f2a#;
   u00042 : constant Version_32 := 16#a69cad5c#;
   u00043 : constant Version_32 := 16#093802d2#;
   u00044 : constant Version_32 := 16#90421990#;
   u00045 : constant Version_32 := 16#fe5e1c6e#;
   u00046 : constant Version_32 := 16#259b6760#;
   u00047 : constant Version_32 := 16#a8d17654#;
   u00048 : constant Version_32 := 16#0a7e05c0#;
   u00049 : constant Version_32 := 16#04fd4e8a#;
   u00050 : constant Version_32 := 16#647de85b#;
   u00051 : constant Version_32 := 16#a23322db#;
   u00052 : constant Version_32 := 16#0d0a8d0c#;
   u00053 : constant Version_32 := 16#d9dbe86c#;
   u00054 : constant Version_32 := 16#895f8c1e#;
   u00055 : constant Version_32 := 16#9d76bf9a#;
   u00056 : constant Version_32 := 16#62e56d2b#;
   u00057 : constant Version_32 := 16#ced5a363#;
   u00058 : constant Version_32 := 16#f972a97f#;
   u00059 : constant Version_32 := 16#f1de4b60#;
   u00060 : constant Version_32 := 16#ab1aeb7b#;
   u00061 : constant Version_32 := 16#1a3a7ed3#;
   u00062 : constant Version_32 := 16#37a7e042#;
   u00063 : constant Version_32 := 16#6d0998e1#;
   u00064 : constant Version_32 := 16#f2b1549d#;
   u00065 : constant Version_32 := 16#a0a00019#;
   u00066 : constant Version_32 := 16#f2351593#;
   u00067 : constant Version_32 := 16#293ff6f7#;
   u00068 : constant Version_32 := 16#8d087e6b#;
   u00069 : constant Version_32 := 16#2461b049#;
   u00070 : constant Version_32 := 16#0aa29e81#;
   u00071 : constant Version_32 := 16#2274d34a#;
   u00072 : constant Version_32 := 16#59507545#;
   u00073 : constant Version_32 := 16#e98c0dd7#;
   u00074 : constant Version_32 := 16#899a6187#;
   u00075 : constant Version_32 := 16#a0aa86d6#;
   u00076 : constant Version_32 := 16#cc47afb0#;
   u00077 : constant Version_32 := 16#4b4a95e1#;
   u00078 : constant Version_32 := 16#54a6bf64#;
   u00079 : constant Version_32 := 16#4be846ff#;
   u00080 : constant Version_32 := 16#e42a19e8#;
   u00081 : constant Version_32 := 16#7e93ed41#;
   u00082 : constant Version_32 := 16#457693b3#;

   pragma Export (C, u00001, "mainB");
   pragma Export (C, u00002, "system__standard_libraryB");
   pragma Export (C, u00003, "system__standard_libraryS");
   pragma Export (C, u00004, "cB");
   pragma Export (C, u00005, "cS");
   pragma Export (C, u00006, "pkgB");
   pragma Export (C, u00007, "pkgS");
   pragma Export (C, u00008, "text_ioS");
   pragma Export (C, u00009, "adaS");
   pragma Export (C, u00010, "ada__text_ioB");
   pragma Export (C, u00011, "ada__text_ioS");
   pragma Export (C, u00012, "ada__exceptionsB");
   pragma Export (C, u00013, "ada__exceptionsS");
   pragma Export (C, u00014, "ada__exceptions__last_chance_handlerB");
   pragma Export (C, u00015, "ada__exceptions__last_chance_handlerS");
   pragma Export (C, u00016, "systemS");
   pragma Export (C, u00017, "system__soft_linksB");
   pragma Export (C, u00018, "system__soft_linksS");
   pragma Export (C, u00019, "system__parametersB");
   pragma Export (C, u00020, "system__parametersS");
   pragma Export (C, u00021, "system__secondary_stackB");
   pragma Export (C, u00022, "system__secondary_stackS");
   pragma Export (C, u00023, "system__storage_elementsB");
   pragma Export (C, u00024, "system__storage_elementsS");
   pragma Export (C, u00025, "system__stack_checkingB");
   pragma Export (C, u00026, "system__stack_checkingS");
   pragma Export (C, u00027, "system__exception_tableB");
   pragma Export (C, u00028, "system__exception_tableS");
   pragma Export (C, u00029, "system__htableB");
   pragma Export (C, u00030, "system__htableS");
   pragma Export (C, u00031, "system__exceptionsB");
   pragma Export (C, u00032, "system__exceptionsS");
   pragma Export (C, u00033, "system__tracebackB");
   pragma Export (C, u00034, "system__tracebackS");
   pragma Export (C, u00035, "system__unsigned_typesS");
   pragma Export (C, u00036, "system__wch_conB");
   pragma Export (C, u00037, "system__wch_conS");
   pragma Export (C, u00038, "system__wch_stwB");
   pragma Export (C, u00039, "system__wch_stwS");
   pragma Export (C, u00040, "system__wch_cnvB");
   pragma Export (C, u00041, "system__wch_cnvS");
   pragma Export (C, u00042, "interfacesS");
   pragma Export (C, u00043, "system__wch_jisB");
   pragma Export (C, u00044, "system__wch_jisS");
   pragma Export (C, u00045, "system__traceback_entriesB");
   pragma Export (C, u00046, "system__traceback_entriesS");
   pragma Export (C, u00047, "ada__streamsS");
   pragma Export (C, u00048, "ada__tagsB");
   pragma Export (C, u00049, "ada__tagsS");
   pragma Export (C, u00050, "system__val_unsB");
   pragma Export (C, u00051, "system__val_unsS");
   pragma Export (C, u00052, "system__val_utilB");
   pragma Export (C, u00053, "system__val_utilS");
   pragma Export (C, u00054, "system__case_utilB");
   pragma Export (C, u00055, "system__case_utilS");
   pragma Export (C, u00056, "interfaces__c_streamsB");
   pragma Export (C, u00057, "interfaces__c_streamsS");
   pragma Export (C, u00058, "system__crtlS");
   pragma Export (C, u00059, "system__file_ioB");
   pragma Export (C, u00060, "system__file_ioS");
   pragma Export (C, u00061, "ada__finalizationB");
   pragma Export (C, u00062, "ada__finalizationS");
   pragma Export (C, u00063, "system__finalization_rootB");
   pragma Export (C, u00064, "system__finalization_rootS");
   pragma Export (C, u00065, "system__finalization_implementationB");
   pragma Export (C, u00066, "system__finalization_implementationS");
   pragma Export (C, u00067, "system__restrictionsB");
   pragma Export (C, u00068, "system__restrictionsS");
   pragma Export (C, u00069, "system__stream_attributesB");
   pragma Export (C, u00070, "system__stream_attributesS");
   pragma Export (C, u00071, "ada__io_exceptionsS");
   pragma Export (C, u00072, "interfaces__cB");
   pragma Export (C, u00073, "interfaces__cS");
   pragma Export (C, u00074, "system__os_libB");
   pragma Export (C, u00075, "system__os_libS");
   pragma Export (C, u00076, "system__stringsB");
   pragma Export (C, u00077, "system__stringsS");
   pragma Export (C, u00078, "system__file_control_blockS");
   pragma Export (C, u00079, "ada__finalization__list_controllerB");
   pragma Export (C, u00080, "ada__finalization__list_controllerS");
   pragma Export (C, u00081, "system__memoryB");
   pragma Export (C, u00082, "system__memoryS");

   --  BEGIN ELABORATION ORDER
   --  ada%s
   --  interfaces%s
   --  system%s
   --  system.case_util%s
   --  system.case_util%b
   --  system.htable%s
   --  system.htable%b
   --  system.parameters%s
   --  system.parameters%b
   --  system.crtl%s
   --  interfaces.c_streams%s
   --  interfaces.c_streams%b
   --  system.restrictions%s
   --  system.restrictions%b
   --  system.standard_library%s
   --  system.exceptions%s
   --  system.exceptions%b
   --  system.storage_elements%s
   --  system.storage_elements%b
   --  system.secondary_stack%s
   --  system.stack_checking%s
   --  system.stack_checking%b
   --  system.strings%s
   --  system.strings%b
   --  system.traceback%s
   --  system.traceback%b
   --  system.traceback_entries%s
   --  system.traceback_entries%b
   --  ada.exceptions%s
   --  ada.exceptions.last_chance_handler%s
   --  system.soft_links%s
   --  system.soft_links%b
   --  ada.exceptions.last_chance_handler%b
   --  system.secondary_stack%b
   --  system.exception_table%s
   --  system.exception_table%b
   --  ada.io_exceptions%s
   --  ada.tags%s
   --  ada.streams%s
   --  interfaces.c%s
   --  interfaces.c%b
   --  system.finalization_root%s
   --  system.finalization_root%b
   --  system.memory%s
   --  system.memory%b
   --  system.standard_library%b
   --  system.os_lib%s
   --  system.os_lib%b
   --  system.unsigned_types%s
   --  system.stream_attributes%s
   --  system.stream_attributes%b
   --  system.finalization_implementation%s
   --  system.finalization_implementation%b
   --  ada.finalization%s
   --  ada.finalization%b
   --  ada.finalization.list_controller%s
   --  ada.finalization.list_controller%b
   --  system.file_control_block%s
   --  system.file_io%s
   --  system.file_io%b
   --  system.val_uns%s
   --  system.val_util%s
   --  system.val_util%b
   --  system.val_uns%b
   --  system.wch_con%s
   --  system.wch_con%b
   --  system.wch_cnv%s
   --  system.wch_jis%s
   --  system.wch_jis%b
   --  system.wch_cnv%b
   --  system.wch_stw%s
   --  system.wch_stw%b
   --  ada.tags%b
   --  ada.exceptions%b
   --  ada.text_io%s
   --  ada.text_io%b
   --  text_io%s
   --  c%s
   --  main%b
   --  pkg%s
   --  pkg%b
   --  c%b
   --  END ELABORATION ORDER

end ada_main;
