#include <sys/socket.h>
#include <stdlib.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <stropts.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>

struct sockaddr_in* if_addrs = NULL;
int if_num_addrs;

int load_ifs(void)
{
    struct ifconf ifconf;
//    char buf[48] = {0};
    int fd;
    int i;

    if((fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
        printf("ERROR creating socket: %s\n", strerror(errno));
        return -1;
    }

    ifconf.ifc_len = sizeof(struct ifreq) * 16;
    ifconf.ifc_req = malloc(ifconf.ifc_len);

    if(ioctl(fd, SIOCGIFCONF, &ifconf) < 0) {
        printf("ERROR: ioctl: %s\n", strerror(errno));
        return -1;
    }

    if_num_addrs = ifconf.ifc_len / sizeof(struct ifreq);
    if_addrs = malloc(sizeof(struct sockaddr_in) * if_num_addrs);

//    printf("%d addrs\n", if_num_addrs);
    for(i = 0; i < if_num_addrs; i++) {
        memcpy(&if_addrs[i],
                &ifconf.ifc_req[i].ifr_addr, sizeof(struct sockaddr_in));
//        inet_ntop(AF_INET, &if_addrs[i].sin_addr, buf, 48);
//        printf("addr %s name %s\n", buf, ifconf.ifc_req[i].ifr_name);
    }

    return 0;
}

int unload_ifs(void)
{
    free(if_addrs);
    return 0;
}

