#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <errno.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>
#include <assert.h>
#include <infiniband/verbs.h>


/* Variables globales */
#define IBPING_TX_DEPTH   20
#define IBPING_RX_DEPTH   20
#define IBPING_RDMA_DEPTH 2
#define IBPING_MAX_SG_SQ  2
#define IBPING_MAX_SG_RQ  2
#define IBPING_MAX_INLINE 128
#define IBPING_WRID_SEND  1
#define IBPING_PORT       1
#define IBPING_TCP_PORT (8657)


/* Structure contenant les données nécessaires à l'établissement de la communications */
struct ibping_address_s
{
  uint16_t lid; /* <=> adresse IP de la carte */
  uint32_t qpn; /* numero de file */
  uint32_t psn; /* */
  uint64_t raddr; /* adresse memoire */
  uint32_t rkey; /* Clef d'acces distante */
};


/** Bloc de variables globales pour l'accès à la carte IB
 */
static struct
{
  /* Info. de base sur la carte IB */
  struct ibv_context*context;   /**< contexte IB (point d'entrée HCA) */
  struct ibv_pd*pd;             /**< Protection Domain */
  struct ibv_mr*mr;             /**< Memory Region correspondant au buffer ci-dessous */

  /* Adresses */
  struct ibping_address_s local_addr; /**< adresse locale */
  struct ibping_address_s peer_addr;  /**< adresse du noeud distant */

  /* Informations de connexion */
  struct ibv_qp*qp;             /**< QP vers le noeud distant */
  struct ibv_comp_channel * comp_ch;
  struct ibv_cq*of_cq;          /**< CQ pour l'émission */
  struct ibv_cq*if_cq;          /**< CQ pour réception */

  /* boites aux lettres */
  struct
  {
    /* piste de décollage */
    struct
    {
      char data[65536];       /**< données de la boîte à lettres */
      int busy;               /**< flag de présence de données */
    } emission;
    /* piste d'atterrissage */
    struct
    {
      char data[65536];       /**< données de la boîte à lettres */
      volatile int busy;      /**< flag de présence de données */
    } reception;
  } buffer;
} ib_globals;


