/*******************************************************************************
 * FILE:        GrassLocation.java
 * DESCRIPTION:
 * NOTES:       ---
 * AUTHOR:      Antonello Andrea
 * EMAIL:       andrea.antonello@hydrologis.com
 * COMPANY:     HydroloGIS / Engineering, University of Trento / CUDAM
 * COPYRIGHT:   Copyright (C) 2005 HydroloGIS / University of Trento / CUDAM, ITALY, GPL
 *******************************************************************************
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 ******************************************************************************
 *
 * CHANGE LOG:
 *
 * version:
 * comments: changes
 * author:
 * created:
 *****************************************************************************/

package com.hydrologis.jgrass.io;

import java.io.File;

public class GrassLocation
{

  public final static String PERMAMENT_MAPSET = "PERMANENT";
  public final static String DEFAULT_WIND = "DEFAULT_WIND";
  public final static String PROJ_INFO = "PROJ_INFO";
  public final static String PROJ_UNITS = "PROJ_UNITS";
  public final static String WIND = "WIND";
  public final static String MYNAME = "MYNAME";

  public final static String FCELL = "fcell";
  public final static String CELL = "cell";
  public final static String CATS = "cats";
  public final static String HIST = "hist";
  public final static String CELLHD = "cellhd";
  public final static String COLR = "colr";
  public final static String CELL_MISC = "cell_misc";
  public final static String CELLMISC_FORMAT = "f_format";
  public final static String CELLMISC_QUANT = "f_quant";
  public final static String CELLMISC_RANGE = "f_range";
  public final static String CELLMISC_NULL = "null";
  public static final String DIG = "dig";
  public static final String DIG_ATTS = "dig_atts";
  public static final String DIG_CATS = "dig_cats";
  public static final String SITE_LISTS = "site_lists";

  private String mapname = null;
  private String mapsetPath = null;
  private String locationPath = null;

  public GrassLocation(
      String cellFilePath)
  {
    int fileslash = cellFilePath.lastIndexOf(File.separator);

    mapname = cellFilePath.substring(fileslash, cellFilePath.length());
    String cellFolderPath = cellFilePath.substring(0, fileslash);

    fileslash = cellFolderPath.lastIndexOf(File.separator);
    mapsetPath = cellFilePath.substring(0, fileslash);
    fileslash = mapsetPath.lastIndexOf(File.separator);
    locationPath = mapsetPath.substring(0, fileslash);

  }

  public String getLocationPath()
  {
    return locationPath;
  }

  public String getMapname()
  {
    return mapname;
  }

  public String getMapsetPath()
  {
    return mapsetPath;
  }

}
