/*******************************************************************************
 * FILE:        FileUtils.java
 * DESCRIPTION:
 * NOTES:       ---
 * AUTHOR:  Antonello Andrea based in part on a class by  Victor Vishnyakov[tch_@mail.ru]
 * EMAIL:       andrea.antonello@hydrologis.com
 * COMPANY:     HydroloGIS / Engineering, University of Trento / CUDAM/ 
 * COPYRIGHT:   Copyright (C) 2005 HydroloGIS / University of Trento / CUDAM ,  GPL
 ******************************************************************************
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 ******************************************************************************
 *
 * CHANGE LOG:
 *
 * version:
 * comments: changes
 * author:
 * created:
 *****************************************************************************/
package com.hydrologis.jgrass.io.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.Vector;

public class FileUtils
{

  public FileUtils()
  {

  }

  public static byte[] double2bytearray(double rastervalue)
  {
    long l = Double.doubleToLongBits(rastervalue);
    byte[] b = new byte[8];
    int shift = 64 - 8;
    for (int k = 0; k < 8; k++, shift -= 8)
    {
      b[k] = (byte) (l >>> shift);
    }
    return b;
  }

  public static BitSet fromByteArray(byte[] bytes)
  {
    BitSet bits = new BitSet();
    for (int i = 0; i < bytes.length * 8; i++)
    {
      if ((bytes[bytes.length - i / 8 - 1] & (1 << (i % 8))) > 0)
      {
        bits.set(i);
      }
    }
    return bits;
  }

  public static BitSet fromByte(byte thebyte)
  {
    BitSet bits = new BitSet();
    for (int i = 0; i < 8; i++)
    {
      if ((thebyte & (1 << (i % 8))) > 0)
      {
        bits.set(i);
      }
    }
    return bits;
  }

  public static byte[] BitSet2ByteArray(BitSet bs)
  {
    byte[] bytes = new byte[bs.size() / 8 + 1];

    for (int i = 0; i < bs.size(); i++)
      if (bs.get(i)) bytes[i / 8] |= 1 << (i % 8);

    return bytes;
  }

  public static byte[] toByteArray(BitSet bits)
  {
    byte[] bytes = new byte[bits.length() / 8 + 1];
    for (int i = 0; i < bits.length(); i++)
    {
      if (bits.get(i))
      {
        bytes[bytes.length - i / 8 - 1] |= 1 << (i % 8);
      }
    }
    return bytes;
  }

  public static void copyFile(String fromFile, String toFile) throws IOException, FileNotFoundException
  {
    File in = new File(fromFile);
    File out = new File(toFile);
    FileInputStream fis = new FileInputStream(in);
    FileOutputStream fos = new FileOutputStream(out);
    byte[] buf = new byte[1024];
    int i = 0;
    while ((i = fis.read(buf)) != -1)
    {
      fos.write(buf, 0, i);
    }
    fis.close();
    fos.close();
  }

  /**
   * This Vector stores information from scan
   */
  private Vector filesVector = new Vector();

  private Vector folderNameVector = new Vector();
  private Vector fileNameVector = new Vector();

  /**
   * This function returns list of files and folders on path
   */
  private String[] getList(File path)
  {
    try
    {
      return path.list();
    }
    catch (Exception e)
    {
      System.out.println(e.toString());
    }
    return null;
  }

  /**
   * This function returns list of folders in the current folder
   * 
   * @author Antonello Andrea
   */
  public Vector getListOfFolders(File f, String path)
  {
    try
    {
      String[] fileList;
      String[] folderList;
      String fileStatus;
      fileList = getList(f);
      for (int i = 0; i < fileList.length; i++)
      {
        if (isDirectory(path + "/" + fileList[i]))
        {
          folderNameVector.addElement(fileList[i]);
        }
      }

    }
    catch (Exception e)
    {
      System.out.println(e.toString());
    }
    return folderNameVector;
  }

  /**
   * This function returns list of files in the current folder
   * 
   * @author Antonello Andrea
   */
  public Vector getListOfFiles(File f, String path)
  {
    try
    {
      String[] fileList;
      String[] folderList;
      String fileStatus;
      fileList = getList(f);
      for (int i = 0; i < fileList.length; i++)
      {
        if (!isDirectory(path + "/" + fileList[i]))
        {
          fileNameVector.addElement(fileList[i]);
        }
      }

    }
    catch (Exception e)
    {
      System.out.println(e.toString());
    }
    return fileNameVector;
  }

  /**
   * returns whether this path directory or not
   */
  private boolean isDirectory(String path)
  {
    File f = new File(path);
    return f.isDirectory();
  }

  /**
   * This recursive method scans folders and files from path till the end of
   * file.
   */
  private void scanTree(String path)
  {
    File f = new File(path);
    String[] fileList;
    String fileStatus;
    fileList = getList(f);
    for (int i = 0; i < fileList.length; i++)
    {
      if (isDirectory(path + "/" + fileList[i]))
      {
        scanTree(path + "/" + fileList[i]);
      }
      else
      {
        filesVector.addElement(path + "/" + fileList[i]);
      }
    }
  }

  /**
   * this function returns Enumeration of files from this path
   */
  public java.util.Enumeration getList(String path)
  {
    scanTree(path);
    return filesVector.elements();
  }
} // end of class
