/*******************************************************************************
 * FILE:        Window.java
 * DESCRIPTION:
 * NOTES:       ---
 * AUTHOR:      Andrea Antonello, John Preston
 * EMAIL:       andrea.antonello@hydrologis.com, john.preston@uwimona.edu.jm
 * COMPANY:     HydroloGIS / Engineering, University of Trento / CUDAM / ICENS
 * COPYRIGHT:   Copyright (C) 2005 HydroloGIS / University of Trento / CUDAM/ ICENS,  GPL
 *
 ******************************************************************************
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 ******************************************************************************
 *
 * CHANGE LOG:
 *
 * version:
 * comments: changes
 * author:
 * created:
 *****************************************************************************/

package com.hydrologis.jgrass.io.utils;

/**
 * @author moovida
 */
public class ShowPercent
{

  /**
   * 
   */
  public static int prev = -1;

  /**
   * this method shows the percentage done on the console and on the progressbar
   * 
   * 
   * WARNING: sometimes the prev is not resetted to -1 at the end of the 100%.
   *                   If you have problems, set it manually to -1 before starting the 0%.
   * 
   * @param runningvalue - running value
   * @param endvalue - end value
   * @param startvalue - start value
   */
  public static void getPercent(int runningvalue, int endvalue, int startvalue)
  {
    int x = (endvalue <= 0 || startvalue <= 0) ? 100 : 100 * runningvalue / endvalue;

    if (runningvalue <= 0 || runningvalue >= endvalue || x > prev + startvalue)
    {
      prev = x;
      System.out.println(x + "%");
    }

    if (x >= 100)
    {
      prev = -1;
    }
  }

}