/*******************************************************************************
 * FILE:        Window.java
 * DESCRIPTION:
 * NOTES:       ---
 * AUTHOR:      Andrea Antonello, John Preston
 * EMAIL:       andrea.antonello@hydrologis.com, john.preston@uwimona.edu.jm
 * COMPANY:     HydroloGIS / Engineering, University of Trento / CUDAM / ICENS
 * COPYRIGHT:   Copyright (C) 2005 HydroloGIS / University of Trento / CUDAM/ ICENS,  GPL
 *
 ******************************************************************************
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 ******************************************************************************
 *
 * CHANGE LOG:
 *
 * version:
 * comments: changes
 * author:
 * created:
 *****************************************************************************/
package com.hydrologis.jgrass.map;

import java.util.HashMap;

/**
 *
 */
public class Window extends Object
{

  private int proj = 0;

  private int zone = 0;

  private double n = -9999.0;

  private double s = -9999.0;

  private double w = -9999.0;

  private double e = -9999.0;

  private double ns_res = -9999.0;

  private double we_res = -9999.0;

  private int rows = 0;

  private int cols = 0;

  /**
   * Creates a new instance of Window
   */
  public Window(
      double west, double east, double south, double north, int _rows, int _cols)
  {
    //System.out.println("NEW WINDOW 2");
    w = west;
    e = east;
    s = south;
    n = north;
    rows = _rows;
    cols = _cols;
    fixResolution();
  }

  /**
   * Creates a new instance of Window
   */
  public Window(
      Window win)
  {
    w = win.getWest();
    e = win.getEast();
    s = win.getSouth();
    n = win.getNorth();
    rows = win.getRows();
    cols = win.getCols();
    fixResolution();
  }

  /**
   * Creates a new instance of Window
   * 
   * ATTENTION!!!! This method seems to be not always consistent!!!! Has to
   * be tested and reviewed
   */
  public Window(
      double west, double east, double south, double north, double weres, double nsres)
  {
    w = west;
    e = east;
    s = south;
    n = north;
    we_res = weres;
    ns_res = nsres;
    //System.out.println("WINDOW 2 - west=" + w + ", east=" + e + ", south=" + s + ", north=" + n
    //        + ", we_res=" + we_res + ", ns_res=" + ns_res);

    fixRowsAndCols();
  }

  /**
   *
   */
  public void limitRowsCols(int _rows, int _cols)
  {
    /* If current rows > _rows then clamp the value. */
    if (rows > _rows)
    {
      rows = _rows;
    }
    if (cols > _cols)
    {
      cols = _cols;
    }
    fixResolution();
  }

  /**
   *
   */
  public boolean isVisibleInWindow(Window w)
  {
    /* Not yet implemented */
    return false;
  }

  public boolean isContainedIn(Window w)
  {
    /* Not yet implemented */
    return false;
  }

  public int getProj()
  {
    return proj;
  }

  public void setProj(int _proj)
  {
    proj = _proj;
  }

  public int getZone()
  {
    return zone;
  }

  public void setZone(int _zone)
  {
    zone = _zone;
  }

  public void setWest(double west)
  {
    w = west;
  }

  public double getWest()
  {
    return w;
  }

  public void setEast(double east)
  {
    e = east;
  }

  public double getEast()
  {
    return e;
  }

  public void setSouth(double south)
  {
    s = south;
  }

  public double getSouth()
  {
    return s;
  }

  public void setNorth(double north)
  {
    n = north;
  }

  public double getNorth()
  {
    return n;
  }

  public int getRows()
  {
    return rows;
  }

  public void setRows(int _rows)
  {
    rows = _rows;
  }

  public int getCols()
  {
    return cols;
  }

  public void setCols(int _cols)
  {
    cols = _cols;
  }

  public void setWEResolution(double res)
  {
    we_res = res;
  }

  public double getWEResolution()
  {
    return we_res;
  }

  public void setNSResolution(double res)
  {
    ns_res = res;
  }

  public double getNSResolution()
  {
    return ns_res;
  }

  public double getXExtent()
  {
    return e - w;
  }

  public double getYExtent()
  {
    return n - s;
  }

  /**
   * Sets the extent of this window using another window.
   */
  public void setExtent(Window win)
  {
    w = win.getWest();
    e = win.getEast();
    n = win.getNorth();
    s = win.getSouth();
    fixResolution();
    fixRowsAndCols();
  }

  public java.awt.geom.Rectangle2D.Double getRectangle()
  {
    return new java.awt.geom.Rectangle2D.Double(w, s, getXExtent(), getYExtent());
  }

  public String toString()
  {
    return ("Window: west=" + w + ", east=" + e + ", south=" + s + ", north=" + n + ", we_res=" + we_res
        + ", ns_res=" + ns_res + ", rows=" + rows + ", cols=" + cols);
  }

  public HashMap toHashMap()
  {
    HashMap<String, Object> windowMap = new HashMap<String, Object>();

    windowMap.put("west", new Double(w).toString());
    windowMap.put("east", new Double(e).toString());
    windowMap.put("south", new Double(s).toString());
    windowMap.put("north", new Double(n).toString());
    windowMap.put("we_res", new Double(we_res).toString());
    windowMap.put("ns_res", new Double(ns_res).toString());
    windowMap.put("rows", new Integer(rows).toString());
    windowMap.put("cols", new Integer(cols).toString());

    return windowMap;
  }

  /**
   *
   */
  public void fixResolution()
  {
    we_res = (e - w) / (double) cols;
    ns_res = (n - s) / (double) rows;
  }

  /**
   *
   */
  public void fixRowsAndCols()
  {
    rows = (int) ((n - s) / ns_res);
    if (rows < 1) rows = 1;
    cols = (int) ((e - w) / we_res);
    if (cols < 1) cols = 1;
  }
}