package javax.enterprise.deploy.shared.factories;

import junit.framework.TestCase;

import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.enterprise.deploy.spi.factories.MockDeploymentFactory;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.DeploymentManager;

/**
 * Low level tests on the DeploymentFactoryManager.
 */
public class DeploymentFactoryManagerTest extends TestCase {
    private DeploymentFactoryManager factoryManager;

    protected void setUp() throws Exception {
        super.setUp();
        factoryManager = DeploymentFactoryManager.getInstance();
    }

    protected void tearDown() throws Exception {
        factoryManager = null;
        super.tearDown();
    }

    public void testGetDeploymentManagerWithoutAnyRegisteredFactories() {
        try {
            factoryManager.getDeploymentManager(null, null, null);
        } catch (DeploymentManagerCreationException e) {
            assertEquals("Could not get DeploymentManager", e.getMessage());
            return;
        }
        fail("Expected a DeploymentManagerCreationException");
    }

    public void testDisconnectedGetDeploymentManagerWithoutAnyRegisteredFactories() {
        try {
            factoryManager.getDisconnectedDeploymentManager(null);
        } catch (DeploymentManagerCreationException e) {
            assertEquals("Could not get DeploymentManager", e.getMessage());
            return;
        }
        fail("Expected a DeploymentManagerCreationException");
    }

    public void testRegisterDeploymentFactory() {
        int initialNumberOfFactories = factoryManager.getDeploymentFactories().length;

        DeploymentFactory factory = new MockDeploymentFactory();
        factoryManager.registerDeploymentFactory(factory);

        int expectedNumberOfFactories = initialNumberOfFactories + 1;
        int currentNumberOfFactories = factoryManager.getDeploymentFactories().length;

        assertEquals(expectedNumberOfFactories, currentNumberOfFactories);
    }

    /**
     * Relies on succesful completion of @link #testRegisterDeploymentFactory()
     * bacause we need a registered DeploymentManager for this test.
     */
    public void testGetDeploymentManager() {
        int numberOfFactories = factoryManager.getDeploymentFactories().length;
        assertTrue("We should have a registered MockDeploymentFactory", numberOfFactories > 0);

        DeploymentManager deploymentManager = null;
        try {
            deploymentManager = factoryManager.getDeploymentManager(null, null, null);
        } catch (DeploymentManagerCreationException e) {
            fail("Didn't expect a DeploymentManagerException here.");
        }
        assertNotNull("Expected an instance of the MockDeploymentManager", deploymentManager);
    }

    public void testDeploymentManagerCreationException() {
        try {
            factoryManager.getDisconnectedDeploymentManager("throw-exception");
        } catch (DeploymentManagerCreationException e) {
            assertEquals("Could not get DeploymentManager", e.getMessage());
            return;
        }
        fail("Expected a DeploymentManagerCreationException");
    }

    public void testGetNullDeploymentManagerCreationException() {
        DeploymentManager disconnectedDeploymentManager = null;
        try {
            disconnectedDeploymentManager = factoryManager.getDisconnectedDeploymentManager("return-null");
        } catch (DeploymentManagerCreationException e) {
            fail("Didn't expect a DeploymentManagerException here.");
        }
        // Apperently the DeploymentFactoryManager doesn't care about the DeploymentFactory
        // returning null
        assertNull(disconnectedDeploymentManager);
    }
}
