#!/bin/sh

# Carta Tecnica Regionale Numerica 1:5000
# Script per riproiettare i layer sull'elissoide WGS84

if [ ! -d merged/WGS84 ]
then
  mkdir -p merged/WGS84
fi

for shp in `ls merged/GaussBoaga/*.shp`
do
  file=${shp##*/}
  echo $file
  ogr2ogr -t_srs EPSG:4326 -s_srs "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.999600 +x_0=2520000 +y_0=0 +ellps=intl +units=m +towgs84=-104.1,-49.1,-9.9,0.971,-2.917,0.714,-11.68" -f "ESRI Shapefile" merged/WGS84/$file $shp
done