#!/bin/bash
#
# integration as a git alias as folow :
# ~/.gitconfig
# [alias]
#   all =  "!f() { git_all.sh $@ ; }; f"

##
## variables
##

# colors
Color_Off='\e[0m'
BGreen='\e[1;32m'
BRed='\e[1;31m'

COMMAND="$@"
REPO_LIST=""

##
## functions
##

function intrusive_info()
{
    echo -e "${BGreen} $@ ${Color_Off}" 1>&2
}

##
## main
##

# find all git repository in sub-tree
for git_path in $(find -type d -name ".git")
do
    REPO_LIST="$REPO_LIST
$(dirname $git_path)"
done

# exec git command foreach repo
for repo in $REPO_LIST
do
    if [ -d $repo ]
    then
        pushd $repo 1>/dev/null
        intrusive_info "[`basename $PWD`]"
#        for git versions >= 2.5.1
#        replace with command below to work around the issue
#        GIT_WORK_TREE=`pwd` git $COMMAND
        git $COMMAND
        popd 1>/dev/null
    fi
done

exit 0
