-------------------------------------------------------------------------------
-- Concurrent Haskell Debugger 
--   GuiGraphicWindow Module
--
-------------------------------------------------------------------------------

-- this implements the double-listbox-window

-- needed: an init-function
--         an operate-function

-- programming TclHaskell:
--   init composes all elements together
--   operate reads and writes messages to the CHD

module CHD.GuiGraphicWindow
  (
    initGraphicWindow,
    operateGraphicWindow
  )
  where


-------------------------------------------------------------------------------
-- IMPORTS
-------------------------------------------------------------------------------

import CHD.GuiGraphicWindowState
import CHD.GuiMsgChan
import CHD.DebugMsgChan
import CHD.Environment
import CHD.GuiWindow
import CHD.BaseTypes
import CHD.BaseFunctions
import CHD.BaseTypes

import Tcl

import Debug.Trace

-------------------------------------------------------------------------------
-- TYPES
-------------------------------------------------------------------------------


-------------------------------------------------------------------------------
-- FUNCTIONS
-------------------------------------------------------------------------------

initGraphicWindow :: GuiWindow -> GUI () -> GUI ()
initGraphicWindow viewWin windowFinalizer = do
-- new Window
  myWindow <- window []
  title myWindow ("CHD - " ++ (show viewWin))
  bind myWindow "<Destroy>" (do interactGui (CloseGuiWin viewWin)
				windowFinalizer)
-- new Grid
  myFrame <- frame myWindow []

-- new Frame
  myCanvas <- canvas myWindow [ background "white", takefocus True,
				scrollregion ((0,0),(0,0)) ]

  packAdd myCanvas [packH, inFrame myFrame, expand True, fillXY]
  packAdd myFrame [packV, expand True, fillXY]
   
-- telling Debugger & Gui
  interactGui (OpenGuiWin viewWin 
      (operateGraphicWindow (initGuiGraphicWindowState myWindow myCanvas)))
  proc $ interactCHD (GetInfoGuiWin viewWin)
  
  return ()


operateGraphicWindow :: GuiGraphicWindowState -> GuiWinMsg -> GUI ()
operateGraphicWindow state msg = return ()
  -- case msg of
  --     InsertCanvas ProgressCanvas threadObj steps -> return ()
           --mapM_ (displayStep state threadObj) steps
	   --interactGui (OpenGuiWin ProgressViewWindow (operateGraphicWindow state))   

