-------------------------------------------------------------------------------
-- Concurrent Haskell Debugger 
--   GuiGraphicWindowState Module
--
-------------------------------------------------------------------------------

-- description shortcut: GGWS = GuiGraphicWindowState

module CHD.GuiGraphicWindowState
  (
    GuiGraphicWindowState(..),
    initGuiGraphicWindowState	-- :: GGWS
  )
    where


-------------------------------------------------------------------------------
-- IMPORTS
-------------------------------------------------------------------------------

import CHD.BaseTypes

import Tcl


-------------------------------------------------------------------------------
-- TYPES
-------------------------------------------------------------------------------

data GuiGraphicWindowState = GuiGraphicWindowState {
  windowWindow		 :: Window,
  canvasWindow		 :: Canvas
  }


-------------------------------------------------------------------------------
-- FUNCTIONS
-------------------------------------------------------------------------------

initGuiGraphicWindowState :: Window -> Canvas -> GuiGraphicWindowState
initGuiGraphicWindowState window canvas = GuiGraphicWindowState {
  windowWindow		      = window,
  canvasWindow		      = canvas
}

{-
stateAddObject :: GuiGraphicWindowState -> Object -> GUI GuiGraphicWindowState
stateAddObject 
-}

displayStep :: GuiGraphicWindowState -> Object -> Step
				     -> GUI GuiGraphicWindowState
displayStep state (ThreadObj threadNo) (Step action object _ False codePos)= do
  let canvas = canvasWindow state 
  case object of
       ThreadObj _ -> 
           coval canvas (1,1) (20,20) [outline "black", fill "white", width 2] 
		      >> return state
       
       MVarObj _   -> crectangle canvas (10,1) (20,20) 
			    [outline "black", fill "white", width 2] 
		      >> return state
       obj	   -> return state

displayStep state actorObj (Step action object _ True codePos) = return state


{-
displayObject :: Canvas -> Object -> GUI ()
displayObject canvas ThreadObj = do
  -}