--------------------------------------------------------------------------------
-- Concurrent Haskell Debugger
--   CHD.GuiInterface Module
--     by Thomas Boettcher <thomas.boettcher@gmx.de>
-------------------------------------------------------------------------------

module CHD.GuiInterface 
  (
  GuiMsg(..),
  GuiInteract(..),
  Parameter(..),
--  GuiKey(..),
  GuiWinMsg(..),
  GuiWindow(..),
  sendGuiMsg,
  sendPriorGuiInteract,
  debugMsgChan,
  DebugMsg(..),
  DebugMsgAction(..),
  reduceDebugMsg,
  CHDInteractMsg(..),
  parseGuiMsg
  )
where


------------------------------------------------------------------------------
-- IMPORTS
-------------------------------------------------------------------------------

import qualified Control.Concurrent as C
import System.IO.Unsafe

import CHD.GuiMain
import CHD.GuiMsgChan
import CHD.DebugMsgChan
import CHD.GuiWindow
import CHD.BaseTypes
import CHD.Environment
import CHD.PriorDoubleChannel


-------------------------------------------------------------------------------
-- FUNCTIONS
-------------------------------------------------------------------------------

sendGuiMsg :: GuiMsg -> IO ()
sendGuiMsg message = do
  putStr forkGui
  writeDblChanLess guiMsgChan message
  

sendPriorGuiInteract :: GuiInteract -> IO ()
sendPriorGuiInteract message = do
  putStr forkGui
  priorGui message
  
{-
sendGuiInteract :: GuiInteract -> GUI ()
sendInteractGui message =
  proc $ sendPriorGui message
-}


forkGui :: String
forkGui = unsafePerformIO( do
  chdMessage "forking Gui-Interface"
  chdMessage "Gui-Interface: go!"
  C.forkIO (startGui guiReceive)
  return []
  )
