// sharp geometrical features.
Merge "remesh-data.med";

// Create the topology of the discrete model
CreateTopology;

// We can now define a compound line (resp. surface) for each discrete
// line (resp. surface) in the model
ll[] = Line "*";
l=newl;
For j In {0 : #ll[]-1}
  Compound Line(l+j) = ll[j];
EndFor


// And we can create the surface based on the new compound entities
Line Loop(999) = {l : l + #ll[]-1};
Surface(1) = {999};

Mesh.RemeshAlgorithm = 1; // (0) no split (1) automatic (2) automatic only with metis
Mesh.RemeshParametrization = 1; // (0) harmonic (1) conformal
Geometry.HideCompounds = 1; // don't hide the compound entities
