//
//  main.m
//  gnash
//
//  Created by Piero Contezini on 24/06/10.
//  Copyright Informant 2010. All rights reserved.
//

#import <UIKit/UIKit.h>

#include <vector>
#include <string>
#include <iostream>
#include <ios>
#include <stdio.h>
#include <signal.h>

#include "arg_parser.h"
#include "Player.h"

std::vector<std::string> infiles;
std::string url;

using namespace std;

static void
parseCommandLine(int argc, char* argv[], gnash::Player& player)
{  
	
    const Arg_parser::Option opts[] =
	{
        { 'h', "help",              Arg_parser::no  },
        { 'v', "verbose",           Arg_parser::no  },
        { 'a', 0,                   Arg_parser::no  },
        { 'p', 0,                   Arg_parser::no  },
        { 's', "scale",             Arg_parser::yes },
        { 256, "max-advances",      Arg_parser::yes },
        { 257, "fullscreen",        Arg_parser::no  },
        { 258, "hide-menubar",      Arg_parser::no  },
        { 'c', 0,                   Arg_parser::no  },
        { 'd', "delay",             Arg_parser::yes },
        { 'x', "xid",               Arg_parser::yes },
        { 'r', "render-mode",       Arg_parser::yes },
        { 't', "timeout",           Arg_parser::yes },
        { '1', "once",              Arg_parser::no  },
        { 'w', "writelog",          Arg_parser::no  },
        { 'j', "width",             Arg_parser::yes },
        { 'k', "height",            Arg_parser::yes },
        { 'X', "x-position",        Arg_parser::yes },
        { 'Y', "y-position",        Arg_parser::yes },
        { 'u', "real-url",          Arg_parser::yes },
        { 'P', "param",             Arg_parser::yes },
        { 'U', "base-url",          Arg_parser::yes },
        { 'g', "debugger",          Arg_parser::no  },
        { 'V', "version",           Arg_parser::no  },
        { 'f', "debug-fps",         Arg_parser::yes },
        { 'F', "fd",                Arg_parser::yes },
        { 'A', "dump",              Arg_parser::yes },
        { 259, "screenshot",        Arg_parser::yes },
        { 260, "screenshot-file",   Arg_parser::yes },
        { 'D', 0,                   Arg_parser::yes }, // Handled in dump gui
        {   0, 0,                   Arg_parser::no  }
    };
	
    Arg_parser parser(argc, argv, opts);
    if (!parser.error().empty()) {
        cout << parser.error() << endl;
        exit(EXIT_FAILURE);
    }

    for (int i = 0; i < parser.arguments(); ++i) {
		
        const int code = parser.code(i);
        try {
            switch (code) {
                case 'h':
                    exit(EXIT_SUCCESS);
                case 0:
                    infiles.push_back(parser.argument(i));
                    break;
            }
        }
        catch (Arg_parser::ArgParserException &e) {
            cerr << _("Error parsing command line options: ") << e.what()
			<< endl;
            cerr << _("This is a Gnash bug.") << endl;
        }
    }
}
	
			

int main(int argc, char *argv[]) {
    NSAutoreleasePool * pool = [[NSAutoreleasePool alloc] init];
	std::ios::sync_with_stdio(false);
		
	gnash::Player player;
	try {
		parseCommandLine(argc, argv, player);
	} catch( const std::exception& ex) {
		cerr << ex.what() << endl;
		return(-1);
	} catch(...) {
		cerr << "erro desconhecido" << endl;
		return(-1);
	}
	infiles.push_back("/tmp/blah.swf");
	
//	system("pwd;ls");
	if(infiles.empty()) {
		cerr << "sem arquivos pra abrir" << endl;
		return(-1);
	}
	
	player.setDoRender(true);
	player.setDoSound(false);
//	player.setScreenShots("0,1,2,3,4,5,6,7,8,9,10");
//	player.setScreenShotFile("/tmp/shot");
	return(player.run(argc, argv, infiles.front(), url));
	
//    int retVal = UIApplicationMain(argc, argv, nil, nil);
    [pool release];
//    return retVal;
}
