/*
 *  UIKitCairoGlue.h
 *  gnash
 *
 *  Created by Piero Contezini on 25/06/10.
 *  Copyright 2010 Informant. All rights reserved.
 *
 */

#include <sys/types.h>
#include <cstring>

#include <boost/cstdint.hpp>
#include <cairo.h>

#include "snappingrange.h"
#include "Renderer.h"
#include "Renderer_cairo.h"

namespace gnash
{
	
	class UIKitCairoGlue
	{
	public:
		UIKitCairoGlue();
		~UIKitCairoGlue();
		bool init(int argc, char **argv[]);
		
		void setInvalidatedRegions(const InvalidatedRanges& ranges);
		bool prepDrawingArea(int width, int height, boost::uint32_t flags);
		Renderer* createRenderHandler(int depth);
		void render();
		void checksum();
	protected:
		int _bpp;
	private:
		cairo_surface_t *_cairo_surface;
		cairo_t         *_cairo_handle;
		unsigned char   *_render_image;
		Renderer  *_renderer;
		
		int frameCounter;
		int bufferSize;
	};
	
} // namespace gnash
