/*
 *  UIKitCairoGlue.cpp
 *  gnash
 *
 *  Created by Piero Contezini on 25/06/10.
 *  Copyright 2010 Informant. All rights reserved.
 *
 */

#include "UIKitCairoGlue.h"


#include <UIKit/UIKit.h>

namespace gnash {
	
UIKitCairoGlue::UIKitCairoGlue() {
	frameCounter = 0;
}

UIKitCairoGlue::~UIKitCairoGlue() {
	if ( _cairo_surface ) cairo_surface_destroy(_cairo_surface);
	delete [] _render_image;
}

bool UIKitCairoGlue::init(int argc, char ** argv[]) {
	return(true);
}

Renderer *UIKitCairoGlue::createRenderHandler(int depth) {
	_bpp = depth;
	
	_renderer = renderer::cairo::create_handler();
	NSLog(@"UIKitCairoGlue::createRenderHandler() %x", &_renderer);
	return(_renderer);
	
}

void UIKitCairoGlue::setInvalidatedRegions(const InvalidatedRanges& ranges) {
	
}
	
void UIKitCairoGlue::checksum() {
	int sum = 0;
	for(unsigned int i = 0; i < bufferSize; i++) {
		sum += _render_image[i];
	}
	printf("checksum imagem: %d\n", sum);
}

bool UIKitCairoGlue::prepDrawingArea(int width, int height, boost::uint32_t flags) {
	NSLog(@"UIKitCairoGlue::prepDrawingArea(): %d %d", width, height);
	int stride = width * 4;	
	bufferSize = stride * height;
	_render_image = new unsigned char [stride * height];
//	bzero(_render_image, bufferSize);
	
	_cairo_surface = cairo_image_surface_create_for_data(_render_image, CAIRO_FORMAT_ARGB32, width, height, stride);
	
	_cairo_handle = cairo_create(_cairo_surface);
	
	renderer::cairo::set_context(_renderer, _cairo_handle);
	
	printf("cairo::set_context: _renderer: %x _cairo_handle: %x\n", _renderer, _cairo_handle);
	
	boost::uint32_t rmask, gmask, bmask, amask;
	
    rmask = 0x00ff0000;
    gmask = 0x0000ff00;
    bmask = 0x000000ff;
    amask = 0xff000000;
	
//	cairo_rectangle(_cairo_handle, 0.0, 0.0, width, height);
//	cairo_set_source_rgb(_cairo_handle, 0.0, 0.0, 0.5);
//	cairo_fill(_cairo_handle);
	
//	cairo_select_font_face (_cairo_handle, "serif", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
//	cairo_set_font_size (_cairo_handle, 32.0);
//	cairo_set_source_rgb (_cairo_handle, 0.0, 0.0, 1.0);
//	cairo_move_to (_cairo_handle, 10.0, 50.0);
//	cairo_show_text (_cairo_handle, "Hello, world");	
	
//    _sdl_surface = SDL_CreateRGBSurfaceFrom((void *) _render_image, width, height,
//											_bpp, stride, rmask, gmask, bmask, amask);
//    assert(_sdl_surface);
	checksum();
    return true;
}

void UIKitCairoGlue::render() {
	GNASH_REPORT_FUNCTION;	
	NSLog(@"UIKitCairoGlue::render()");
	cairo_surface_mark_dirty(_cairo_surface);
//	cairo_show_page(_cairo_handle);
	char file[128];
	snprintf(file,127,"/tmp/gnash-%d.png", frameCounter);
	cairo_surface_write_to_png(_cairo_surface, file);
	cairo_status_t code = cairo_surface_status(_cairo_surface);
	printf("status: %s\n", cairo_status_to_string(code));
	printf("type: %d\n", cairo_surface_get_type(_cairo_surface));
	checksum();
	frameCounter++;
}

}