/*
 *  uikitgui.h
 *  gnash
 *
 *  Created by Piero Contezini on 25/06/10.
 *  Copyright 2010 Informant. All rights reserved.
 *
 */

#include <sys/types.h>
#include <cstring>
using namespace std;

#include <gui.h>

#include "gnash.h"
#include "UIKitCairoGlue.h"
#include "GnashSleep.h"

namespace gnash
{

	
	
class UIKitGui : public Gui {
public:
    UIKitGui(unsigned long xid, float scale, bool loop, RunResources& r);
    ~UIKitGui();
    bool init(int argc, char **argv[]);
    bool createWindow(const char *title, int width, int height,
                              int xPosition = 0, int yPosition = 0);
    bool run();
    bool createMenu();
    bool setupEvents(); 
    void renderBuffer();
    void setInterval(unsigned int interval);
    void disableCoreTrap();
    void setTimeout(unsigned int timeout);
	void quitUI() { _quit = true; };
    
	void expose_event();
	unsigned int getTime();
//    void key_event(SDL_KeyboardEvent * key, bool down);
	
    // See gui.h for documentation
    void setInvalidatedRegions(const InvalidatedRanges& ranges);
	
	key::code uikit_to_gnash_key();
		
	UIKitCairoGlue    _glue;
	
private:
	unsigned int _timeout;
	bool _core_trap;
	bool _quit;
	
};
	
	
	
}