/*
 *  uikitgui.cpp
 *  gnash
 *
 *  Created by Piero Contezini on 25/06/10.
 *  Copyright 2010 Informant. All rights reserved.
 *
 */

#include "uikitgui.h"
#include <UIKit/UIKit.h>
#include <time.h>

#include "gnash.h"
#include "Renderer.h"
#include "RunResources.h"

using namespace std;


namespace gnash
{
	
std::auto_ptr<Gui> createUIKitGui(unsigned long windowid, float scale, bool do_loop, RunResources& r)
{
       return std::auto_ptr<Gui>(new UIKitGui(windowid, scale, do_loop, r));
}
	
	
UIKitGui *uikit = NULL;

void receive_signal(int signal) {
	if(uikit) {
		uikit->quitUI();
	}
}
		
	
	
unsigned int UIKitGui::getTime() {
		return (unsigned int)(1000*(clock()/(double)CLOCKS_PER_SEC));
}
	
UIKitGui::UIKitGui(unsigned long xid, float scale, bool loop, RunResources& r)
	: Gui(xid, scale, loop, r),
	_timeout(0),
	_core_trap(true),
	_quit(false) {
		NSLog(@"passou no construtor do UiKitGui");
}

UIKitGui::~UIKitGui() {
	GNASH_REPORT_FUNCTION;
}

bool UIKitGui::run() {
	GNASH_REPORT_FUNCTION;
	NSLog(@"UiKitGui::run()");
//	expose_event();
	
	SystemClock timer;
	
	unsigned long prevtime = timer.elapsed();
	while (!_quit)
	{
		
		Gui::advance_movie(this);
		unsigned long now = timer.elapsed();
		unsigned long spent = now-prevtime;
		
		long rem = _interval-spent;
		if ( rem > 0 )
		{
			gnashSleep( rem * 1000 );
		}
		
		if ( _timeout && now > _timeout)
		{  
			break;
		}
		
		prevtime = now;
		
	}
	
		
	return(false);
}


void UIKitGui::setTimeout(unsigned int timeout) {
	GNASH_REPORT_FUNCTION;
	_timeout = timeout;
}

bool UIKitGui::init(int argc, char **argv[]) {
	NSLog(@"passou no init do UiKitGui");
	uikit = this;
	signal(SIGHUP, receive_signal);
	signal(SIGKILL, receive_signal);
	signal(SIGQUIT, receive_signal);
	
	GNASH_REPORT_FUNCTION;
	_glue.init(argc, argv);
	_renderer.reset(_glue.createRenderHandler(32));
	if(! _renderer ) {
		NSLog(@"erro ao criar o render");
		return(false);
	}
	_runResources.setRenderer(boost::shared_ptr<Renderer>(_renderer));
	printf("UiKit::init(): renderer: %x\n", &_renderer);
	return(true);
}
	
bool UIKitGui::createWindow(const char *title, int width, int height, int x_pos, int y_pos) {
	GNASH_REPORT_FUNCTION;
	_width = width;
	_height = height;
	_glue.prepDrawingArea(width, height, 0);
	return(true);
}

void UIKitGui::disableCoreTrap() {
	_core_trap = false;
}

void UIKitGui::setInvalidatedRegions(const InvalidatedRanges& ranges) {
	_glue.setInvalidatedRegions(ranges);
}

void UIKitGui::renderBuffer() {
	_glue.render();
}

void UIKitGui::setInterval(unsigned int interval) {
	NSLog(@"UIKitGui::setInterval: %d", interval);
	_interval = interval;
}

bool UIKitGui::createMenu() {
	return(false);
}
	
key::code UIKitGui::uikit_to_gnash_key() {
	gnash::key::code c(gnash::key::INVALID);
	return(c);
}
	
bool UIKitGui::setupEvents() {
	return(true);
}
	
void UIKitGui::expose_event() {
	renderBuffer();
}
	
}