#include <libgda/libgda.h>
#include <stdio.h>
#include <string.h>
#include <glib.h>
#include <unistd.h>

static GdaConnection *db_connection = NULL;
static GdaClient *gda_client = NULL;
static gchar *data_source = NULL;
static gchar *dsn_name;

#define ANJUTA_DB_FILE	".anjuta_sym_db"

// FIXME
#define TABLES_SQL		"/path/to/tables.sql"


#define PRJ_DIRECTORY	"/tmp/foo/"

static gboolean
sdb_engine_connect_to_db (const gchar* data_source)
{
	
	if (db_connection != NULL) {
		/* if it's the case that the connection isn't NULL, we should notify the user
		 * and return FALSE. It's his task to disconnect and retry to connect */
		g_warning ("connection is already established. Please disconnect and then "
				   "try to reconnect.");
		return FALSE;
	}
	
	/* create new client */
	gda_client = gda_client_new ();
	
	/* establish a connection. If the sqlite file does not exist it will be created */
	db_connection = gda_client_open_connection (gda_client, data_source,
												 "", "", 
												 GDA_CONNECTION_OPTIONS_READ_ONLY, 
												 NULL);

	if ( !GDA_IS_CONNECTION (db_connection)) {
		g_warning ("could not open connection to %s\n", data_source);
		return FALSE;
	}
	
	g_message ("connected to database %s", data_source);
	return TRUE;
}


static gboolean
sdb_engine_create_db_tables (gchar* tables_sql_file)
{
	GError *err;
	GdaCommand *command;
	gchar *contents;
	gsize size;
	
	g_return_val_if_fail (tables_sql_file != NULL, FALSE);
	g_return_val_if_fail (db_connection != NULL, FALSE);	
	
	/* read the contents of the file */
	if (g_file_get_contents (tables_sql_file, &contents, &size, &err) == FALSE) {
		g_warning ("Something went wrong while trying to read %s", tables_sql_file);
		
		if (err != NULL)
			g_message ("%s", err->message);
		return FALSE;
	}

	command = gda_command_new (contents, GDA_COMMAND_TYPE_SQL,
				   GDA_COMMAND_OPTION_STOP_ON_ERRORS);
	gda_connection_execute_non_select_command (db_connection, command, NULL, NULL);
	gda_command_free (command);

	g_free (contents);
}



gboolean 
db_engine_open_db (gchar* prj_directory)
{
	/* Connection data */
	gchar *dsn_name;
	gboolean needs_tables_creation = FALSE;
	
	g_return_val_if_fail (prj_directory != NULL, FALSE);
	
	/* check whether the db filename already exists. If it's not the case
	 * create the tables for the database. */
	gchar *tmp_file = g_strdup_printf ("%s/%s.db", prj_directory, ANJUTA_DB_FILE);

	g_message ("tmp file is %s", tmp_file);
	
	if (g_file_test (tmp_file, G_FILE_TEST_EXISTS) == FALSE) {
		needs_tables_creation = TRUE;
	}
	g_free (tmp_file);
	
	
	data_source = prj_directory;
	dsn_name = g_strdup_printf ("DB_DIR=%s;DB_NAME=%s", prj_directory, ANJUTA_DB_FILE);

	if (gda_config_save_data_source (data_source, "SQLite", dsn_name, 
									 "Anjuta Project", "", "", FALSE) == FALSE) {
		return FALSE;
	}
	
	g_message ("connecting to database...");
	sdb_engine_connect_to_db (data_source);
	
	if (needs_tables_creation == TRUE) {
		g_message ("creating database...");		
		
		g_message ("creating tables...");		
		sdb_engine_create_db_tables (TABLES_SQL);
	}
	
	return TRUE;
}


gboolean 
db_engine_add_new_workspace (gchar* workspace,
									gchar* data_source)
{
/*
CREATE TABLE workspace (workspace_id integer PRIMARY KEY AUTOINCREMENT,
                        name varchar (50) not null unique,
                        analize_time DATE
                        );
*/
	GdaDict *dict;
	GdaQuery *query;
	GdaParameterList *par_list;
	GdaParameter *param;
	GValue *value;
	GError *err;
	
	g_return_val_if_fail (db_connection != NULL, FALSE);
	

	dict = gda_dict_new();
	gda_dict_set_connection(dict, db_connection);
	gda_dict_load(dict, NULL);

	/* here it is the wrong query. */
	
	gchar *query_1st = "INSERT INTO workspace (name) VALUES (##/* name:'+0' type:'gchararray' */)";
	gchar *query_2nd = "INSERT INTO workspace (analize_time, name) VALUES (datetime('now'), ##/* name:'+0' type:'gchararray' */)";
	gchar *query_3rd = "SELECT * FROM workspace WHERE name = ## /* name:'+0' type:gchararray */ AND analize_time = ##/* name:'+1' type:'date' */";
	gchar *query_4th = "SELECT * FROM workspace WHERE name = ## /* name:'+0' type:gchararray */";
	
	query = gda_query_new_from_sql (dict, 
									query_4th,
									NULL);

	if (query == NULL)
		g_message ("query is null");

	g_message ("gda_query_get_query_type is %d\n",  gda_query_get_query_type (query));
	
	par_list = gda_query_get_parameter_list (query);
	
	if (par_list == NULL) {
		g_warning ("par_list is NULL!\n");
		exit(0);
	}
	
	param = gda_parameter_list_find_param (par_list, "+0");

	if (param == NULL)
		g_warning ("PARAM is NULL!\n");
	
	value = gda_value_new (G_TYPE_STRING);

	g_value_set_string (value, "bla bla bla workspace");

	gda_parameter_set_value (param, value);

	
	GObject *obj = (GObject*)gda_query_execute (query, par_list, FALSE, NULL);
	return TRUE;
}


int main(int argc, char** argv)
{
	
    g_type_init();
	gda_init ("Test db", "0.1", argc, argv);

	db_engine_open_db (PRJ_DIRECTORY);
	
	db_engine_add_new_workspace ("my_foo_workspace", PRJ_DIRECTORY);
	
}
